/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon_script.CupCommand;
import cupcarbon_script.CupScript;
import cupcarbon_script.CupScriptAddCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import map.MapLayer;

public class CupCommand_FILE
extends CupCommand {
    protected String path = "";
    protected String name = "";
    protected String option = "";

    public CupCommand_FILE(CupScript script, String option, String name, String path) {
        this.script = script;
        this.path = path;
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        this.path = (String)path + name;
        this.name = name;
        this.option = option;
    }

    @Override
    public String execute() {
        currentExecution = false;
        String rep = "";
        String sPath = this.script.getVariableValue(this.path);
        Object sName = this.script.getVariableValue(this.name);
        String sOption = this.script.getVariableValue(this.option);
        CupScript.slog.println("Script");
        switch (sOption) {
            case "open": {
                if (!((String)sName).endsWith(".scc")) {
                    sName = (String)sName + ".scc";
                }
                CupCommand_FILE.loadAndExecute(this.script, sPath, (String)sName);
                rep = "000 Script File opened";
                currentExecution = true;
                break;
            }
            default: {
                rep = "001 [ERROR] No file or Directory";
                currentExecution = false;
            }
        }
        System.out.println(rep);
        CupScript.slog.println(rep);
        isExecuted = currentExecution;
        return rep;
    }

    public static void loadAndExecute(CupScript script, String path, String fileName) {
        CupScript.slog.println("Script");
        MapLayer.initLists();
        CupScript.slog.println("Init Object lists");
        try {
            BufferedReader br = new BufferedReader(new FileReader(path));
            String s = "";
            while ((s = br.readLine()) != null) {
                CupScriptAddCommand.addCommand(script, s.trim());
                script.nextAndExecute();
            }
            script.next();
            String st = "";
            while (!st.startsWith("111")) {
                st = script.executeCommand();
                script.next();
                MapLayer.repaint();
            }
            br.close();
            System.out.println("BYE");
            CupScript.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "FILE";
    }
}

