/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon.CupCarbonApp;
import cupcarbon_script.CupCommand;
import cupcarbon_script.CupScript;
import device.DeviceList;
import device.SensorNode;
import radio_module.RadioModule;

public class CupCommand_RADIO
extends CupCommand {
    protected String sensor;
    protected String radioName = "";
    protected String standard = "";
    protected String option = "";

    public CupCommand_RADIO(CupScript script, String option, String sensor, String radioName, String standard) {
        this.script = script;
        this.option = option;
        this.sensor = sensor;
        this.radioName = radioName;
        this.standard = standard;
    }

    @Override
    public String execute() {
        currentExecution = false;
        Object rep = "";
        String sOption = this.script.getVariableValue(this.option);
        String sName = this.script.getVariableValue(this.radioName);
        String sStandard = this.script.getVariableValue(this.standard);
        String sSensor = this.script.getVariableValue(this.sensor);
        SensorNode sensor = (SensorNode)DeviceList.getNodeByName(sSensor);
        int number = Integer.parseInt(sName.replaceAll("[^0-9?!\\.]", ""));
        if (isExecuted) {
            switch (this.option) {
                case "add": {
                    if (sensor == null) {
                        rep = "There is no sensor with the name " + sSensor + ", try again!";
                        currentExecution = true;
                        break;
                    }
                    if ((sName.substring(0, 5).equals("radio") || sName.substring(0, 5).equals("RADIO")) && number > 0 && number <= 10 && RadioModule.getStandardByName(sStandard) > 0 && !sensor.getRadioModuleList().contains(sensor.getRadioModuleByName(sName))) {
                        sensor.addRadioModule(sName, sStandard);
                        rep = "000 Adding Radio module: " + sName + " Standard: " + sStandard + " to the Device " + sSensor;
                        if (!CupCarbonApp.cupCarbonController.radioParamPane.isExpanded()) {
                            CupCarbonApp.cupCarbonController.radioParamPane.setExpanded(true);
                        }
                        if (CupCarbonApp.cupCarbonController != null) {
                            CupCarbonApp.cupCarbonController.updateObjectListView();
                            CupCarbonApp.cupCarbonController.getNodeInformations();
                            CupCarbonApp.cupCarbonController.getRadioInformations();
                            CupCarbonApp.cupCarbonController.updateSelectionInListView();
                        }
                        DeviceList.deselectAll();
                        sensor.setSelected(true);
                        currentExecution = true;
                        break;
                    }
                    rep = "[ERROR] Unknown Radio Name or Standard";
                    currentExecution = false;
                    break;
                }
                case "current": {
                    sensor.selectCurrentRadioModule(sName);
                    rep = "000 Radio module " + sName + " is selected for the device " + sSensor;
                    currentExecution = true;
                    if (!CupCarbonApp.cupCarbonController.radioParamPane.isExpanded()) {
                        CupCarbonApp.cupCarbonController.radioParamPane.setExpanded(true);
                    }
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.updateObjectListView();
                        CupCarbonApp.cupCarbonController.getNodeInformations();
                        CupCarbonApp.cupCarbonController.getRadioInformations();
                        CupCarbonApp.cupCarbonController.updateSelectionInListView();
                    }
                    DeviceList.deselectAll();
                    sensor.setSelected(true);
                    break;
                }
                case "delete": {
                    sensor.removeRadioModule(sName);
                    rep = "000 Radio module " + sName + " is deleted from the device " + sSensor;
                    currentExecution = true;
                    if (!CupCarbonApp.cupCarbonController.radioParamPane.isExpanded()) {
                        CupCarbonApp.cupCarbonController.radioParamPane.setExpanded(true);
                    }
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.updateObjectListView();
                        CupCarbonApp.cupCarbonController.getNodeInformations();
                        CupCarbonApp.cupCarbonController.getRadioInformations();
                        CupCarbonApp.cupCarbonController.updateSelectionInListView();
                    }
                    DeviceList.deselectAll();
                    sensor.setSelected(true);
                    break;
                }
                default: {
                    rep = "001 [ERROR] Radio option error: " + sOption;
                    currentExecution = false;
                    break;
                }
            }
        } else {
            rep = "ERROR IN EXECUTING THE PREVIOUS STEP, THE SCRIPT WILL NOT CONTINUE TO EXECUTE";
            this.script.setBreaked(true);
        }
        System.out.println((String)rep);
        CupScript.slog.println((String)rep);
        isExecuted = currentExecution;
        return rep;
    }

    @Override
    public String toString() {
        return "RADIO";
    }
}

