/*
 * Decompiled with CFR 0.152.
 */
package device;

import device.Device;
import device.DeviceList;
import device.SensorNode;
import device.StdSensorNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import project.Project;
import utilities.MapCalc;
import utilities.UColor;

public class BaseStation
extends StdSensorNode {
    protected int type = 4;

    public BaseStation(String id, String x, String y, String z, String radius, String radioRadius, String cuRadius, String gpsFileName, String scriptFileName) {
        super(id, x, y, z, radius, radioRadius, cuRadius, gpsFileName, scriptFileName);
    }

    public BaseStation(double x, double y, double z, double radius, double radioRadius, double cuRadius, int id) {
        super(x, y, z, radius, radioRadius, cuRadius, id);
    }

    @Override
    public void drawTheCenter(Graphics g, int x, int y) {
        int[] triangleX = new int[3];
        int[] triangleY = new int[3];
        int sz = 8;
        triangleX[0] = x - sz;
        triangleX[1] = x;
        triangleX[2] = x + sz;
        triangleY[0] = y + sz;
        triangleY[1] = y - sz;
        triangleY[2] = y + sz;
        if (this.underSimulation) {
            g.setColor(new Color(38, 194, 27));
        } else {
            g.setColor(UColor.ORANGE);
            if (this.getScript() != null && this.getScript().isWaiting()) {
                g.setColor(Color.RED);
            }
        }
        if (this.isDead()) {
            g.setColor(Color.BLACK);
        }
        if (this.getScriptFileName().equals("")) {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.fillPolygon(triangleX, triangleY, 3);
        g.setColor(UColor.BLACK_TTRANSPARENT);
        g.drawPolygon(triangleX, triangleY, 3);
    }

    @Override
    public String getIdFL() {
        return "SINK_";
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void consumeTx(int v) {
    }

    @Override
    public void consumeRx(int v) {
    }

    @Override
    public boolean detect(Device device) {
        return false;
    }

    @Override
    public SensorNode createNewWithTheSameType() {
        return new BaseStation(this.longitude, this.latitude, this.elevation, this.radius, 0.0, this.sensorUnit.getRadius(), DeviceList.number++);
    }

    @Override
    public void save(String ref) {
        String fileName = Project.getProjectNodePath();
        try {
            PrintStream fos = null;
            fos = new PrintStream(new FileOutputStream(fileName + File.separator + "basestation_" + ref));
            fos.println("List of parameters");
            fos.println("------------------------------------------");
            fos.println("device_type:" + this.getType());
            fos.println("device_id:" + this.getId());
            fos.println("device_longitude:" + this.getLongitude());
            fos.println("device_latitude:" + this.getLatitude());
            fos.println("device_elevation:" + this.getElevation());
            fos.println("device_radius:" + this.getRadius());
            fos.println("device_hide:" + this.getHide());
            fos.println("device_draw_battery:" + this.getDrawBatteryLevel());
            fos.println("device_sensor_unit_radius:" + this.getSensorUnitRadius());
            if (!this.getGPSFileName().equals("")) {
                fos.println("device_gps_file_name:" + this.getGPSFileName());
            }
            if (!this.getScriptFileName().equals("")) {
                fos.println("device_script_file_name:" + this.getScriptFileName());
            }
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.saveRadioModule(Project.getProjectRadioPath() + File.separator + "basestation_" + ref);
    }

    @Override
    public void drawMarked(Graphics g2) {
        if (!this.isDead()) {
            Graphics2D g = (Graphics2D)g2;
            g.setStroke(new BasicStroke(0.4f));
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int[] triangleX = new int[3];
            int[] triangleY = new int[3];
            int sz = 20;
            int x = coord[0];
            int y = coord[1];
            double f1 = 1.7;
            double f2 = 0.7;
            double f3 = 0.8;
            triangleX[0] = x - (int)(f2 * (double)sz);
            triangleX[1] = x;
            triangleX[2] = x + (int)(f2 * (double)sz);
            triangleY[0] = y + (int)((double)sz / f1);
            triangleY[1] = y - (int)(f3 * (double)sz);
            triangleY[2] = y + (int)((double)sz / f1);
            if (this.ledColor == 1) {
                g.setColor(UColor.GREEND_TRANSPARENT);
                g.fillPolygon(triangleX, triangleY, 3);
                g.setColor(Color.GRAY);
                g.drawPolygon(triangleX, triangleY, 3);
            }
            if (this.ledColor > 1) {
                g.setColor(UColor.colorTab[this.ledColor - 1]);
                g.fillPolygon(triangleX, triangleY, 3);
                g.setColor(Color.GRAY);
                g.drawPolygon(triangleX, triangleY, 3);
            }
        }
    }
}

