/*
 * Decompiled with CFR 0.152.
 */
package device;

import battery.Battery;
import device.Device;
import device.DeviceList;
import device.DeviceWithWithoutRadio;
import device.IoTNode;
import device.SensorNode;
import geo_objects.GeoZoneList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import map.MapLayer;
import map.NetworkParameters;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import radio_module.RadioDetection;
import radio_module.RadioModule;
import simulation.SimulationInputs;
import utilities.MapCalc;
import utilities.UColor;

public abstract class DeviceWithRadio
extends DeviceWithWithoutRadio {
    protected double porteeErr = 0.4;
    protected Random random = new Random();
    protected Vector<RadioModule> radioModuleList = new Vector();
    protected RadioModule currentRadioModule = null;
    protected Vector<SensorNode> neighbors = new Vector();
    protected int nPoint = 20;
    protected double deg = Math.PI * 2 / (double)this.nPoint;
    protected int[] polyX = new int[this.nPoint];
    protected int[] polyY = new int[this.nPoint];
    protected int[] polyX2 = new int[this.nPoint];
    protected int[] polyY2 = new int[this.nPoint];
    protected int numberOfNeighbors = 0;
    protected boolean ackReceived = false;
    protected boolean ackWaiting = false;
    protected HashSet<DeviceWithRadio> senders = new HashSet();

    public DeviceWithRadio() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, -1);
    }

    public DeviceWithRadio(double x, double y, double z, double radius, double radioRangeRadius, int id) {
        super(x, y, z, radius, id);
        this.initGeoZoneList();
    }

    public void setGeoZoneList(GeoZoneList geoZoneList) {
        this.geoZoneList = geoZoneList;
    }

    @Override
    public void initGeoZoneList() {
        this.geoZoneList = new GeoZoneList();
    }

    @Override
    public Polygon getRadioPolygon() {
        return new Polygon(this.polyX, this.polyY, this.nPoint);
    }

    public boolean contains(Point2D p) {
        if (this.nPoint > 0) {
            return this.getRadioPolygon().contains(p);
        }
        return this.geoZoneList.contains((Point)p);
    }

    public boolean contains(DeviceWithRadio device) {
        GeoPosition gp = new GeoPosition(device.getLatitude(), device.getLongitude());
        Point2D p = MapLayer.mapViewer.getTileFactory().geoToPixel(gp, MapLayer.mapViewer.getZoom());
        if (this.nPoint > 0) {
            return new Polygon(this.polyX, this.polyY, this.nPoint).contains(p);
        }
        return this.geoZoneList.contains(p);
    }

    @Override
    public Battery getBattery() {
        return this.battery;
    }

    public double getRadioRadiusOri() {
        return this.currentRadioModule.getRadioRangeRadiusOri();
    }

    public void setRadioRadius(double radioRadius) {
        this.currentRadioModule.setRadioRangeRadius(radioRadius);
    }

    @Override
    public void initSelection() {
        super.initSelection();
    }

    public void drawRadioRadius(int x, int y, int r, Graphics g) {
        this.getCurrentRadioModule().drawRadioRadius(x, y, r, g);
    }

    @Override
    public void drawMarked(Graphics g2) {
        if (!this.isDead() && !(this instanceof IoTNode)) {
            int r2;
            int y;
            int x;
            int[] coord;
            Graphics2D g = (Graphics2D)g2;
            g.setStroke(new BasicStroke(0.4f));
            if (this.ledColor == 1) {
                coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
                x = coord[0];
                y = coord[1];
                r2 = 8;
                g.setColor(UColor.GREEND_TRANSPARENT);
                g.fillOval(x - (r2 + 1), y - (r2 + 1), (r2 + 1) * 2, (r2 + 1) * 2);
                g.setColor(Color.GRAY);
                g.drawOval(x - (r2 + 1), y - (r2 + 1), (r2 + 1) * 2, (r2 + 1) * 2);
            }
            if (this.ledColor > 1) {
                coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
                x = coord[0];
                y = coord[1];
                r2 = 8;
                g.setColor(UColor.colorTab[this.ledColor - 1]);
                g.fillOval(x - (r2 + 1), y - (r2 + 1), (r2 + 1) * 2, (r2 + 1) * 2);
                g.setColor(Color.GRAY);
                g.drawOval(x - (r2 + 1), y - (r2 + 1), (r2 + 1) * 2, (r2 + 1) * 2);
            }
        }
    }

    public List<SensorNode> getNeighbors() {
        if (DeviceList.propagationsCalculated) {
            return this.neighbors;
        }
        LinkedList<SensorNode> neighnodes = new LinkedList<SensorNode>();
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            SensorNode sensorNode = DeviceList.sensors.get(i);
            if (!this.radioDetect(sensorNode) || this == sensorNode || this.isDead() || sensorNode.isDead()) continue;
            neighnodes.add(sensorNode);
        }
        return neighnodes;
    }

    public List<SensorNode> getNonMarkedNeighbors() {
        if (DeviceList.propagationsCalculated) {
            return this.neighbors;
        }
        LinkedList<SensorNode> neighnodes = new LinkedList<SensorNode>();
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            SensorNode sensorNode = DeviceList.sensors.get(i);
            if (!this.radioDetect(sensorNode) || this == sensorNode || this.isDead() || sensorNode.isDead() || sensorNode.isMarked()) continue;
            neighnodes.add(sensorNode);
        }
        return neighnodes;
    }

    public List<SensorNode> getMarkedNeighbors() {
        if (DeviceList.propagationsCalculated) {
            return this.neighbors;
        }
        LinkedList<SensorNode> neighnodes = new LinkedList<SensorNode>();
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            SensorNode sensorNode = DeviceList.sensors.get(i);
            if (!this.radioDetect(sensorNode) || this == sensorNode || this.isDead() || sensorNode.isDead() || !sensorNode.isMarked()) continue;
            neighnodes.add(sensorNode);
        }
        return neighnodes;
    }

    public List<SensorNode> getActiveNodes() {
        LinkedList<SensorNode> neighActiveNodes = new LinkedList<SensorNode>();
        for (int i = 0; i < this.getNeighbors().size(); ++i) {
            SensorNode sensorNode = this.getNeighbors().get(i);
            if (!sensorNode.isSending()) continue;
            neighActiveNodes.add(sensorNode);
        }
        return neighActiveNodes;
    }

    public int getPerActiveNodes() {
        int n = this.getNeighbors().size();
        int p = 0;
        for (int i = 0; i < this.getNeighbors().size(); ++i) {
            SensorNode sensorNode = this.getNeighbors().get(i);
            if (!sensorNode.isSending()) continue;
            ++p;
        }
        return p / n;
    }

    public void displayNeighbors() {
        System.out.print(this.id + " : ");
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            if (this == DeviceList.sensors.get(i) || !DeviceList.sensors.get(i).radioDetect(this) && !this.radioDetect(DeviceList.sensors.get(i))) continue;
            System.out.print(String.valueOf(DeviceList.sensors.get(i)) + " ");
        }
        System.out.println();
    }

    public void drawRadioLinks2(Graphics g, int type) {
        this.numberOfNeighbors = 0;
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            SensorNode sensorNode = DeviceList.sensors.get(i);
            if (this == sensorNode || !this.radioDetect(sensorNode) || this.isDead() || sensorNode.isDead()) continue;
            this.drawRadioLink(sensorNode, g, 1);
            ++this.numberOfNeighbors;
            if (!NetworkParameters.displayRLDistance) continue;
            MapLayer.drawDistance(this.longitude, this.latitude, this.elevation, sensorNode.getLongitude(), sensorNode.getLatitude(), sensorNode.getElevation(), g);
        }
    }

    @Override
    public void drawRadioLinks(Graphics g, int type) {
        this.numberOfNeighbors = 0;
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            SensorNode sensor = DeviceList.sensors.get(i);
            if (this == sensor || !this.radioDetect(sensor) || this.isDead() || sensor.isDead()) continue;
            if (this.senders.contains(sensor)) {
                this.drawRadioLink(sensor, g, 3);
                sensor.drawRadioLinkArrows(this, g, 1);
            } else {
                this.drawRadioLink(sensor, g, type);
            }
            ++this.numberOfNeighbors;
            if (!NetworkParameters.displayRLDistance) continue;
            MapLayer.drawDistance(this.longitude, this.latitude, this.elevation, sensor.getLongitude(), sensor.getLatitude(), sensor.getElevation(), g);
        }
    }

    public void drawRadioLinkArrows(Graphics g, int aType) {
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            SensorNode sensor = DeviceList.sensors.get(i);
            if (this == sensor || !this.radioDetect(sensor) || this.isDead() || sensor.isDead()) continue;
            this.drawRadioLinkArrows(sensor, g, aType);
        }
    }

    @Override
    public void drawRadioPropagations(Graphics g) {
        for (int i = 0; i < this.neighbors.size(); ++i) {
            SensorNode sensor = this.neighbors.get(i);
            this.drawRadioLink(sensor, g, 0);
            if (!NetworkParameters.displayRLDistance) continue;
            MapLayer.drawDistance(this.longitude, this.latitude, this.elevation, sensor.getLongitude(), sensor.getLatitude(), sensor.getElevation(), g);
        }
    }

    public void drawRadioLink(Device device, Graphics g, int type) {
        if (NetworkParameters.drawRadioLinks || type > 0) {
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int lx1 = coord[0];
            int ly1 = coord[1];
            coord = MapCalc.geoToPixelMapA(device.getLatitude(), device.getLongitude());
            int lx2 = coord[0];
            int ly2 = coord[1];
            Graphics2D g2 = (Graphics2D)g;
            this.setColor(g2, NetworkParameters.radioLinksColor);
            BasicStroke line = null;
            if (type == 0) {
                line = new BasicStroke(NetworkParameters.linkWidth);
            }
            if (type == 1) {
                line = new BasicStroke(0.5f);
            }
            if (type == 2) {
                line = new BasicStroke(2.0f);
            }
            if (type == 3) {
                g2.setColor(Color.red);
                line = new BasicStroke(3.0f);
            }
            if (type == 4) {
                line = new BasicStroke(0.6f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
            }
            g2.setStroke(line);
            g2.drawLine(lx1, ly1, lx2, ly2);
        }
    }

    public void drawRadioLinkArrows(Device device, Graphics g, int type) {
        if (NetworkParameters.drawRadioLinks || type > 0) {
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int lx1 = coord[0];
            int ly1 = coord[1];
            coord = MapCalc.geoToPixelMapA(device.getLatitude(), device.getLongitude());
            int lx2 = coord[0];
            int ly2 = coord[1];
            this.setColor(g, NetworkParameters.radioLinksColor);
            if (NetworkParameters.drawSensorArrows || type > 0) {
                double dx = 0.0;
                double dy = 0.0;
                double alpha = 0.0;
                coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
                lx1 = coord[0];
                ly1 = coord[1];
                coord = MapCalc.geoToPixelMapA(device.getLatitude(), device.getLongitude());
                lx2 = coord[0];
                ly2 = coord[1];
                dx = lx2 - lx1;
                dy = ly2 - ly1;
                alpha = Math.atan(dy / dx);
                alpha = 180.0 * alpha / Math.PI;
                int as = 11;
                if (type == 1) {
                    as = 16;
                    g.setColor(Color.red);
                }
                if (type == 2) {
                    as = 20;
                    g.setColor(Color.red);
                }
                if (dx >= 0.0) {
                    g.fillArc(lx2 - as, ly2 - as, as * 2, as * 2, 180 - (int)alpha - as, as * 2);
                } else {
                    g.fillArc(lx2 - as, ly2 - as, as * 2, as * 2, -((int)alpha) - as, as * 2);
                }
            }
        }
    }

    public void setColor(Graphics g, int intColor) {
        switch (intColor) {
            case 0: {
                g.setColor(UColor.DARK_GRAY_T);
                if (!MapLayer.dark) break;
                g.setColor(UColor.LIGHT_GRAY_T);
                break;
            }
            case 1: {
                g.setColor(UColor.BLACK_T);
                if (!MapLayer.dark) break;
                g.setColor(UColor.DARK_GRAY_T);
                break;
            }
            case 2: {
                g.setColor(UColor.GRAY_T);
                if (!MapLayer.dark) break;
                g.setColor(UColor.DWHITE_T);
                break;
            }
            case 3: {
                g.setColor(UColor.RED_TTRANSPARENT);
                break;
            }
            case 4: {
                g.setColor(UColor.BLUEMT);
                if (!MapLayer.dark) break;
                g.setColor(UColor.BLUEM);
                break;
            }
            case 5: {
                g.setColor(UColor.ORANGE_TRANSPARENT2);
                if (!MapLayer.dark) break;
                g.setColor(UColor.ORANGE_TRANSPARENT);
            }
        }
    }

    @Override
    public void drawRadius(int x, int y, int r, Graphics g) {
        if (r > 0 && this.displayRadius) {
            g.setColor(UColor.WHITE_TRANSPARENT);
            int lr2 = (int)((double)r * Math.cos(0.7853981633974483));
            g.drawLine(x, y, x - lr2, y - lr2);
            g.drawString("" + r, x - lr2, y - lr2);
        }
    }

    @Override
    public boolean radioDetect(DeviceWithRadio device) {
        if (!DeviceList.propagationsCalculated) {
            return RadioDetection.simpleDetection(this, device);
        }
        if (SimulationInputs.radioDetectionType == 1) {
            return RadioDetection.powerReceptionDetection(this, device);
        }
        if (SimulationInputs.radioDetectionType == 2) {
            return RadioDetection.threeDDetection(this, device);
        }
        return false;
    }

    public boolean radioDetect_vt(DeviceWithRadio device) {
        if (!DeviceList.propagationsCalculated) {
            return RadioDetection.simpleDetection(this, device);
        }
        return true;
    }

    public boolean propagationDetect(DeviceWithRadio device) {
        if (DeviceList.propagationsCalculated) {
            return this.neighbors.contains(device);
        }
        return this.radioDetect(device);
    }

    @Override
    public void calculatePropagations() {
        SimulationInputs.radioDetectionType = 1;
        this.neighbors = new Vector();
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            SensorNode sensorNode = DeviceList.sensors.get(i);
            if (!this.radioDetect(sensorNode) || this.isDead() || sensorNode.isDead()) continue;
            this.neighbors.add(sensorNode);
        }
    }

    @Override
    public void resetPropagations() {
        SimulationInputs.radioDetectionType = 0;
        this.neighbors = new Vector();
    }

    public double getRequiredQuality() {
        return this.getCurrentRadioModule().getRequiredQuality();
    }

    public void setRequiredQuality(double requiredQuality) {
        this.getCurrentRadioModule().setRequiredQuality(requiredQuality);
    }

    public double getTransmitPower() {
        return this.getCurrentRadioModule().getTransmitPower();
    }

    public int getTextXPosition() {
        return 10;
    }

    public int getTextYPosition() {
        return 0;
    }

    public void setTransmitPower(double transmitPower) {
        this.getCurrentRadioModule().setTransmitPower(transmitPower);
    }

    @Override
    public void drawId(int x, int y, Graphics g) {
        if (NetworkParameters.displayDetails) {
            g.setColor(UColor.PURPLE);
            if (MapLayer.dark) {
                g.setColor(new Color(198, 232, 106));
            }
            g.drawString(this.getName() + " [" + this.currentRadioModule.getMy() + "]", x - this.getTextXPosition() / 2, y + this.getTextYPosition() + 15);
        }
        if (!this.scriptFileName.equals("") && NetworkParameters.drawScriptFileName) {
            g.setColor(Color.DARK_GRAY);
            if (MapLayer.dark) {
                g.setColor(Color.LIGHT_GRAY);
            }
            g.drawString(this.scriptFileName, x + this.getTextXPosition(), y - this.getTextYPosition() - 6);
        }
        if (NetworkParameters.displayPrintMessage) {
            g.setColor(new Color(0, 120, 180));
            if (MapLayer.dark) {
                g.setColor(UColor.ORANGE);
            }
            g.drawString("| " + this.message, x - this.getTextXPosition() / 2, y + this.getTextYPosition() + 28 + MapLayer.fontSize / 2);
        }
    }

    public void setMy(int my) {
        this.getCurrentRadioModule().setMy(my);
    }

    public void setPl(double pl) {
        this.getCurrentRadioModule().setPl(pl);
    }

    public double getPl() {
        return this.getCurrentRadioModule().getPl();
    }

    public RadioModule getCurrentRadioModule() {
        return this.currentRadioModule;
    }

    public int getAttempts() {
        return this.currentRadioModule.getAttempts();
    }

    public void setAttempts(int attempts) {
        this.currentRadioModule.setAttempts(attempts);
    }

    public void incAttempts() {
        this.currentRadioModule.incAttempts();
    }

    public int getStandard() {
        return this.getCurrentRadioModule().getStandard();
    }

    public void selectCurrentRadioModule(String name) {
        for (RadioModule rm : this.radioModuleList) {
            if (!rm.getName().equals(name)) continue;
            this.currentRadioModule = rm;
            return;
        }
    }

    public void removeRadioModule(String name) {
        for (RadioModule rm : this.radioModuleList) {
            if (!rm.getName().equals(name) || rm == this.getCurrentRadioModule()) continue;
            this.radioModuleList.remove(rm);
            return;
        }
    }

    public void removeRadioModule(RadioModule radioModule) {
        for (RadioModule rm : this.radioModuleList) {
            if (!rm.getName().equals(radioModule.getName()) || rm == this.getCurrentRadioModule()) continue;
            this.radioModuleList.remove(rm);
            return;
        }
    }

    public double getTimeToResend() {
        return this.getCurrentRadioModule().getTimeToResend();
    }

    public void setTimeToResend(double timeToResend) {
        this.getCurrentRadioModule().setTimeToResend(timeToResend);
    }

    public int getNumberOfSends() {
        return this.getCurrentRadioModule().getNumberOfSends();
    }

    public void setNumberOfSends(int numberOfSends) {
        this.getCurrentRadioModule().setNumberOfSends(numberOfSends);
    }

    public void consumeTx(int v) {
        this.getCurrentRadioModule().consumeTx(v);
    }

    public void consumeRx(int v) {
        this.getCurrentRadioModule().consumeRx(v);
    }

    public double getETx() {
        return this.getCurrentRadioModule().getETx();
    }

    public void setETx(double eTx) {
        this.getCurrentRadioModule().setETx(eTx);
    }

    public double getERx() {
        return this.getCurrentRadioModule().getERx();
    }

    public void setERx(double eRx) {
        this.getCurrentRadioModule().setERx(eRx);
    }

    public double getEL() {
        return this.getCurrentRadioModule().getEListen();
    }

    public void setEL(double eL) {
        this.getCurrentRadioModule().setEListen(eL);
    }

    public void initRadioModule() {
        this.radioModuleList = new Vector();
    }

    public double getCurrentRadioRangeRadius() {
        return this.currentRadioModule.getRadioRangeRadius();
    }

    @Override
    public String[][] getInfos() {
        super.getInfos();
        this.infos[2][1] = "" + this.getCurrentRadioModule().getMy();
        this.infos[3][1] = this.getCurrentRadioModule().getNId() + " (" + Integer.toHexString(this.getCurrentRadioModule().getNId()).toUpperCase() + ")";
        this.infos[4][1] = this.getCurrentRadioModule().getCh() + " (" + Integer.toHexString(this.getCurrentRadioModule().getCh()).toUpperCase() + ")";
        return this.infos;
    }

    @Override
    public void initForSimulation() {
        super.initForSimulation();
    }

    public boolean canCommunicateWith(DeviceWithRadio device) {
        return !this.isDead() && !device.isDead() && this.sameCh(device) && this.sameNId(device) && this.sameStandard(device);
    }

    public boolean sameCh(DeviceWithRadio device) {
        return this.getCurrentRadioModule().getCh() == device.getCurrentRadioModule().getCh();
    }

    public boolean sameNId(DeviceWithRadio device) {
        return this.getCurrentRadioModule().getNId() == device.getCurrentRadioModule().getNId();
    }

    public boolean sameStandard(DeviceWithRadio device) {
        return this.getStandard() == device.getStandard();
    }

    public int getNumberOfNeighbors() {
        return this.numberOfNeighbors;
    }

    public boolean isAckReceived() {
        return this.ackReceived;
    }

    public void setAckReceived(boolean ackReceived) {
        this.ackReceived = ackReceived;
    }

    public boolean isAckWaiting() {
        return this.ackWaiting;
    }

    public void setAckWaiting(boolean b) {
        this.ackWaiting = b;
    }
}

