/*
 * Decompiled with CFR 0.152.
 */
package device;

import cupcarbon.CupCarbonIcons;
import device.DeviceList;
import device.DeviceWithRadio;
import device.MobileG;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.ImageIcon;
import map.MapLayer;
import utilities.MapCalc;
import utilities.UColor;

public class Mobile
extends MobileG {
    private String idFL = "M";
    Image drone = new ImageIcon(CupCarbonIcons.class.getResource("drone3.png")).getImage();

    public Mobile(double x, double y, double z, double radius) {
        super(x, y, z, radius, "", DeviceList.number++);
    }

    public Mobile(double x, double y, double z, double radius, int id) {
        super(x, y, z, radius, "", id);
    }

    public Mobile(double x, double y, double z, double radius, String gpsFileName, int id) {
        super(x, y, z, radius, gpsFileName, id);
    }

    public Mobile(String x, String y, String z, String radius, String gpsFileName, int id) {
        super(Double.valueOf(x), Double.valueOf(y), Double.valueOf(z), Double.valueOf(radius), gpsFileName, id);
    }

    @Override
    public void draw(Graphics g2) {
        if (this.visible) {
            Graphics2D g = (Graphics2D)g2;
            g.setStroke(new BasicStroke(0.5f));
            this.initDraw(g);
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int x = coord[0];
            int y = coord[1];
            int radius = MapCalc.radiusInPixels(this.radius);
            int ra = 15;
            if (this.inside || this.selected) {
                g.setColor(Color.GRAY);
                if (MapLayer.dark) {
                    g.setColor(Color.ORANGE);
                }
                g.drawLine(x - ra - 3, y - ra - 3, x - ra + 2, y - ra - 3);
                g.drawLine(x - ra - 3, y - ra - 3, x - ra - 3, y - ra + 2);
                g.drawLine(x - ra - 3, y + ra + 3, x - ra + 2, y + ra + 3);
                g.drawLine(x - ra - 3, y + ra + 3, x - ra - 3, y + ra - 2);
                g.drawLine(x + ra + 3, y - ra - 3, x + ra - 2, y - ra - 3);
                g.drawLine(x + ra + 3, y - ra - 3, x + ra + 3, y - ra + 2);
                g.drawLine(x + ra + 3, y + ra + 3, x + ra - 2, y + ra + 3);
                g.drawLine(x + ra + 3, y + ra + 3, x + ra + 3, y + ra - 2);
            }
            switch (this.hide) {
                case 0: {
                    g.setColor(Color.LIGHT_GRAY);
                    g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
                }
                case 1: {
                    g.drawImage(this.drone, x - 20, y - 30, null);
                }
            }
            if (this.selected) {
                g.setColor(Color.GRAY);
                if (MapLayer.dark) {
                    g.setColor(Color.LIGHT_GRAY);
                }
                g.drawOval(x - radius - 8, y - radius - 8, (radius + 8) * 2, (radius + 8) * 2);
            }
            if (this.displayRadius) {
                this.drawRadius(x, y, radius, g);
            }
            int r = 5;
            g.setColor(Color.GRAY);
            g.fillOval(x - r, y - r, r * 2, r * 2);
            if (!this.getGPSFileName().equals("")) {
                if (this.underSimulation) {
                    g.setColor(UColor.GREEN);
                    g.fillOval(x - 3, y - 3, 6, 6);
                } else {
                    g.setColor(Color.ORANGE);
                    g.fillOval(x - 3, y - 3, 6, 6);
                }
            }
            this.drawId(x, y, g);
        }
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public String getIdFL() {
        return this.idFL;
    }

    @Override
    public String getName() {
        return this.getIdFL() + this.id;
    }

    @Override
    public void loadScript() {
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public int execute() {
        return 0;
    }

    @Override
    public void drawRadioLinks(Graphics g, int type) {
    }

    @Override
    public void drawRadioPropagations(Graphics g) {
    }

    @Override
    public void initBattery() {
    }

    @Override
    public Polygon getRadioPolygon() {
        return null;
    }

    @Override
    public void calculatePropagations() {
    }

    @Override
    public void resetPropagations() {
    }

    @Override
    public boolean radioDetect(DeviceWithRadio device) {
        return false;
    }

    @Override
    public void initGeoZoneList() {
    }

    @Override
    public void initBuffer() {
    }

    @Override
    public Mobile duplicate() {
        this.selected = false;
        Mobile mobile = new Mobile(this.longitude, this.latitude, this.elevation, this.radius);
        mobile.setHide(this.hide);
        mobile.setDrawBatteryLevel(this.drawBatteryLevel);
        mobile.setScriptFileName(this.scriptFileName);
        mobile.setSelected(true);
        return mobile;
    }

    @Override
    public Mobile duplicateWithShift(double sLongitude, double sLatitude, double sElevation) {
        Mobile mobile = this.duplicate();
        mobile.shift(sLongitude, sLatitude, sElevation);
        return mobile;
    }

    @Override
    public double getSensorUnitRadius() {
        return 0.0;
    }

    @Override
    public double getESensing() {
        return 0.0;
    }

    @Override
    public void save(String fileName) {
        try {
            PrintStream fos = null;
            fos = new PrintStream(new FileOutputStream(fileName + File.separator + "mobile_" + this.getId()));
            fos.println("List of parameters");
            fos.println("------------------------------------------");
            fos.println("device_type:" + this.getType());
            fos.println("device_id:" + this.getId());
            fos.println("device_longitude:" + this.getLongitude());
            fos.println("device_latitude:" + this.getLatitude());
            fos.println("device_elevation:" + this.getElevation());
            fos.println("device_radius:" + this.getRadius());
            fos.println("device_hide:" + this.getHide());
            if (!this.getGPSFileName().equals("")) {
                fos.println("device_gps_file_name:" + this.getGPSFileName());
            }
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public double getNextValueTime() {
        return Double.MAX_VALUE;
    }

    @Override
    public void generateNextValue() {
    }

    @Override
    public void drawMarked(Graphics g) {
    }

    @Override
    public String startingName() {
        return null;
    }
}

