/*
 * Decompiled with CFR 0.152.
 */
package device;

import battery.Battery;
import buildings.BuildingList;
import device.Device;
import device.DeviceList;
import device.SensorNode;
import java.awt.Graphics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import project.Project;
import sensorunit.StdSensorUnit;
import utilities.MapCalc;

public class RealSensorNode
extends SensorNode {
    public RealSensorNode() {
        this.sensorUnit = new StdSensorUnit(this.longitude, this.latitude, this.elevation, this);
    }

    public RealSensorNode(double x, double y, double z, double radius, double radioRadius, int id) {
        super(x, y, z, radius, radioRadius, id);
        this.sensorUnit = new StdSensorUnit(this.longitude, this.latitude, this.elevation, this);
    }

    public RealSensorNode(double x, double y, double z, double radius, double radioRadius, double suRadius, int id) {
        super(x, y, z, radius, radioRadius, id);
        this.sensorUnit = new StdSensorUnit(this.longitude, this.latitude, this.elevation, suRadius, this);
    }

    public RealSensorNode(double x, double y, double z, double radius, double radioRadius, double suRadius, String[][] sb, int id) {
        this(x, y, z, radius, radioRadius, suRadius, id);
        this.setInfos(sb);
        this.initBuffer();
    }

    public RealSensorNode(String id, String x, String y, String z, String radius, String radioRadius, String suRadius, String gpsFileName, String scriptFileName) {
        this(x, y, z, radius, radioRadius, suRadius, (int)Integer.valueOf(id));
        this.setGPSFileName(gpsFileName);
        this.setScriptFileName(scriptFileName);
        this.calculateRadioSpace();
        this.initBuffer();
    }

    public RealSensorNode(String x, String y, String z, String radius, String radioRadius, String suRadius, int id) {
        super(Double.valueOf(x), Double.valueOf(y), Double.valueOf(z), Double.valueOf(radius), Double.valueOf(radioRadius), id);
        this.sensorUnit = new StdSensorUnit(this.longitude, this.latitude, this.elevation, Double.valueOf(suRadius), this);
    }

    @Override
    public void drawSensorUnit(Graphics g) {
        int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
        int x = coord[0];
        int y = coord[1];
        if (this.hide == 0 || this.hide == 4) {
            this.sensorUnit.setPosition(x, y);
            this.sensorUnit.draw(g, 0, this.isSensorDetecting(), this.detectBuildings());
        }
        if (this.hide == 3) {
            this.sensorUnit.setPosition(x, y);
            this.sensorUnit.draw(g, 1, this.isSensorDetecting(), this.detectBuildings());
        }
    }

    @Override
    public double getSensorUnitRadius() {
        return this.sensorUnit.getRadius();
    }

    @Override
    public Device clone() throws CloneNotSupportedException {
        Battery newBattery = this.battery.clone();
        RealSensorNode newSensor = (RealSensorNode)super.clone();
        StdSensorUnit newSensorUnit = new StdSensorUnit(this.sensorUnit.getLongitude(), this.sensorUnit.getLatitude(), this.sensorUnit.getElevation(), this.sensorUnit.getRadius(), newSensor);
        newSensor.setSensorUnit(newSensorUnit);
        newSensor.setBattery(newBattery);
        return newSensor;
    }

    @Override
    public String getIdFL() {
        return "S";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void initBattery() {
        this.getBattery().init();
    }

    @Override
    public String getParamsStr() {
        return "";
    }

    @Override
    public boolean detectBuildings() {
        return BuildingList.intersect(this.sensorUnit.getPoly());
    }

    @Override
    public SensorNode createNewWithTheSameType() {
        return new RealSensorNode(this.longitude, this.latitude, this.elevation, this.radius, 0.0, this.sensorUnit.getRadius(), DeviceList.number++);
    }

    @Override
    public void save(String ref) {
        String fileName = Project.getProjectNodePath();
        try {
            PrintStream fos = null;
            fos = new PrintStream(new FileOutputStream(fileName + File.separator + "sensor_" + ref));
            fos.println("List of parameters");
            fos.println("------------------------------------------");
            fos.println("device_type:" + this.getType());
            fos.println("device_id:" + this.getId());
            fos.println("device_longitude:" + this.getLongitude());
            fos.println("device_latitude:" + this.getLatitude());
            fos.println("device_elevation:" + this.getElevation());
            fos.println("device_radius:" + this.getRadius());
            fos.println("device_hide:" + this.getHide());
            fos.println("device_draw_battery:" + this.getDrawBatteryLevel());
            fos.println("device_sensor_unit_radius:" + this.getSensorUnitRadius());
            if (!this.getGPSFileName().equals("")) {
                fos.println("device_gps_file_name:" + this.getGPSFileName());
            }
            if (!this.getScriptFileName().equals("")) {
                fos.println("device_script_file_name:" + this.getScriptFileName());
            }
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.saveRadioModule(Project.getProjectRadioPath() + File.separator + "sensor_" + ref);
    }

    @Override
    public double getNextValueTime() {
        return Double.MAX_VALUE;
    }

    @Override
    public void generateNextValue() {
    }

    @Override
    public String startingName() {
        return null;
    }
}

