/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Vertex;
import java.util.LinkedList;

public class Graph {
    private LinkedList<Vertex> vertexList = new LinkedList();

    public void add(Vertex s) {
        this.vertexList.add(s);
    }

    public void addFirst(Vertex s) {
        this.vertexList.addFirst(s);
    }

    public Vertex get(int index) {
        return this.vertexList.get(index);
    }

    public int size() {
        return this.vertexList.size();
    }

    public void display() {
        for (Vertex s : this.vertexList) {
            s.display();
            System.out.println();
        }
        System.out.println("------------------");
    }

    public StringBuilder displayNames() {
        StringBuilder sb = new StringBuilder();
        for (Vertex s : this.vertexList) {
            sb.append((CharSequence)s.displayNames());
            sb.append("\n");
            System.out.println();
        }
        System.out.println("------------------");
        return sb;
    }

    public void remove(int idx) {
        this.vertexList.set(idx, null);
        this.vertexList.remove(idx);
    }

    public void removeWithNeighbors(int idx) {
        Vertex s = this.get(idx);
        this.vertexList.remove(idx);
        for (int i = 0; i < s.getNbNeignbors(); ++i) {
            int v = s.getNeighbors().get(i);
            for (int j = 0; j < this.vertexList.size(); ++j) {
                if (!this.vertexList.get(j).hasNeighbor(v)) continue;
                this.vertexList.get(j).remove(v);
                if (this.vertexList.get(j).getNbNeignbors() != 0) continue;
                this.vertexList.remove(j);
                --j;
            }
        }
    }
}

