/*
 * Decompiled with CFR 0.152.
 */
package interference;

import java.util.Random;
import math.UFunctions;

public class AlphaStableRandom {
    public static double[] generateNext(int noTotalNodes, int radio_range, double perActiveNodes, int sizeOut) {
        double b = 2.0;
        double alpha = 2.0 / b;
        double area = Math.PI * (double)radio_range * (double)radio_range;
        double activeNodes = perActiveNodes / 100.0;
        double lambda2 = (double)noTotalNodes / area * activeNodes;
        double temp = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        double c3 = 0.0;
        if (alpha == 1.0) {
            temp = 0.6366197723675814;
        } else {
            c1 = 1.0 - alpha;
            c2 = UFunctions.gamma(Math.ceil(2.0 - alpha));
            c3 = Math.cos(Math.PI * alpha / 2.0);
            temp = c1 / (c2 * c3);
        }
        double scale_para = 3.1623;
        double expected_value_Q = Math.pow(2.0, 1.0 / b) * Math.pow(scale_para, 2.0 / b) * UFunctions.gamma(1.0 / b + 1.0);
        double sigma = lambda2 * (Math.PI * temp) * expected_value_Q;
        int beta = 0;
        boolean delta = false;
        double[] outsizen = new double[sizeOut];
        double mean = 0.0;
        double std = 1.0;
        Random rng = new Random();
        for (int i = 0; i < sizeOut; ++i) {
            outsizen[i] = mean + std * rng.nextGaussian();
        }
        double[] outsize = new double[sizeOut];
        for (int i = 0; i < outsize.length; ++i) {
            outsize[i] = Math.random();
        }
        double[] r = new double[sizeOut];
        double[] V = new double[sizeOut];
        double[] W = new double[sizeOut];
        double[] chunk1 = new double[sizeOut];
        double[] chunk2 = new double[sizeOut];
        double[] chunk3 = new double[sizeOut];
        double[] chunk4 = new double[sizeOut];
        double[] chunk5 = new double[sizeOut];
        double[] chunk6 = new double[sizeOut];
        double[] chunk7 = new double[sizeOut];
        if (alpha == 2.0) {
            for (int i = 0; i < sizeOut; ++i) {
                r[i] = Math.sqrt(2.0) * outsizen[i];
            }
        } else if (alpha == 1.0 && beta == 0) {
            for (int i = 0; i < sizeOut; ++i) {
                r[i] = Math.tan(1.5707963267948966 * (2.0 * outsize[i] - 1.0));
            }
        } else if (alpha == 0.5 && Math.abs(beta) == 1) {
            for (int i = 0; i < sizeOut; ++i) {
                r[i] = (double)beta / Math.pow(outsizen[i], 2.0);
            }
        } else if (beta == 0) {
            for (int i = 0; i < sizeOut; ++i) {
                V[i] = 1.5707963267948966 * (2.0 * outsize[i] - 1.0);
                W[i] = -Math.log10(outsize[i]);
                chunk1[i] = Math.sin(alpha * V[i]);
                chunk2[i] = Math.pow(Math.cos(V[i]), 1.0 / alpha);
                chunk3[i] = Math.cos(V[i] * (1.0 - alpha));
                chunk4[i] = (1.0 - alpha) / alpha;
                chunk5[i] = chunk3[i] / W[i];
                chunk6[i] = Math.pow(chunk5[i], chunk4[i]);
                chunk7[i] = chunk2[i] * chunk6[i];
                r[i] = chunk1[i] / chunk7[i];
            }
        } else if (alpha != 1.0) {
            double constant = (double)beta * Math.tan(Math.PI * alpha / 2.0);
            double B = Math.atan(constant);
            double S = Math.pow(1.0 + constant * constant, 1.0 / (2.0 * alpha));
            for (int i = 0; i < sizeOut; ++i) {
                V[i] = 1.5707963267948966 * (2.0 * outsize[i] - 1.0);
                W[i] = -Math.log(outsize[i]);
                chunk1[i] = S * Math.sin(alpha * V[i] + B);
                chunk2[i] = Math.pow(Math.cos(V[i]), 1.0 / alpha);
                chunk3[i] = Math.cos((1.0 - alpha) * V[i] - B);
                chunk4[i] = chunk3[i] / W[i];
                chunk5[i] = (1.0 - alpha) / alpha;
                chunk6[i] = Math.pow(chunk4[i], chunk5[i]);
                chunk7[i] = chunk2[i] * chunk6[i];
                r[i] = chunk1[i] / chunk7[i];
            }
        } else {
            double[] sclshftV = new double[sizeOut];
            double piover2 = 1.5707963267948966;
            for (int i = 0; i < sizeOut; ++i) {
                V[i] = 1.5707963267948966 * (2.0 * outsize[i] - 1.0);
                W[i] = -Math.log(outsize[i]);
                sclshftV[i] = piover2 + (double)beta * V[i];
                r[i] = 1.0 / piover2 * (sclshftV[i] * Math.tan(V[i]) - (double)beta * Math.log(piover2 * W[i] * Math.cos(V[i]) / sclshftV[i]));
            }
        }
        if (alpha != 1.0) {
            for (int i = 0; i < sizeOut; ++i) {
                r[i] = sigma * r[i] + (double)delta;
            }
        } else {
            for (int i = 0; i < sizeOut; ++i) {
                r[i] = sigma * r[i] + 0.6366197723675814 * (double)beta * sigma * Math.log(sigma) + (double)delta;
            }
        }
        return r;
    }
}

