/*
 * Decompiled with CFR 0.152.
 */
package interference;

import java.util.Random;

public class LoRaTransceiver {
    public static double getNumberOfReceivedErrorBits(String inputMsg, int spreadingFactor, int CR) {
        System.out.println(spreadingFactor);
        double errBits = 0.0;
        double BW = 125000.0;
        double CodingRate = 4 / (CR + 4);
        boolean A = true;
        double fMin = 0.0;
        double fMax = BW;
        double fs = 5.0 * fMax;
        double Tchirp = 0.001;
        double inter = 1.0 / fs;
        double[] timeInter = new double[626];
        timeInter[0] = fMin;
        for (int i = 1; i < 626; ++i) {
            timeInter[i] = timeInter[i - 1] + inter;
        }
        double b = (fMax - fMin) / Tchirp;
        double[] f = new double[626];
        double[] chirp = new double[626];
        for (int i = 0; i < 626; ++i) {
            f[i] = timeInter[i] * b + fMin;
            chirp[i] = (double)A * Math.cos(Math.PI * 2 * f[i] * timeInter[i]);
        }
        int symbolSize = 4;
        byte[] binaryData = LoRaTransceiver.getStringToBinary(inputMsg);
        byte[] binarySource = new byte[64];
        if (binaryData.length >= 512) {
            System.out.print("Too Long Message");
        } else {
            int i;
            for (int i2 = 0; i2 < 64; ++i2) {
                binarySource[i2] = i2 < binaryData.length ? binaryData[i2] : (byte)0;
            }
            int tx_b = binarySource.length;
            int CodInB = 0;
            int CodOutB = 0;
            if (CR == 0) {
                CodInB = 4;
                CodOutB = 4;
            } else if (CR == 1) {
                CodInB = 4;
                CodOutB = 5;
            } else if (CR == 2) {
                CodInB = 2;
                CodOutB = 3;
            } else if (CR == 3) {
                CodInB = 4;
                CodOutB = 7;
            } else if (CR == 4) {
                CodInB = 1;
                CodOutB = 2;
            } else {
                System.out.println("CR value should be b/w 1-4");
            }
            byte[] codedSource = null;
            codedSource = LoRaTransceiver.encoder(CR, binarySource, CodInB, CodOutB);
            int[] codedSourceNRZ = new int[tx_b];
            for (int i3 = 0; i3 < tx_b; ++i3) {
                codedSourceNRZ[i3] = 2 * codedSource[i3] - 1;
            }
            int[][] codedSourceNRZmat = new int[tx_b / symbolSize][CodOutB];
            for (int i4 = 0; i4 < tx_b / symbolSize; ++i4) {
                for (int j = 0; j < CodOutB; ++j) {
                    codedSourceNRZmat[i4][j] = codedSourceNRZ[i4 * CodOutB + j];
                }
            }
            int[][] interleavedSource = new int[tx_b / symbolSize][CodOutB];
            for (int i5 = 0; i5 < tx_b / symbolSize; ++i5) {
                for (int j = 0; j < CodOutB; ++j) {
                    interleavedSource[i5][j] = codedSourceNRZmat[(i5 + j) % (tx_b / symbolSize)][j];
                }
            }
            int[] interleavedSourceSerial = new int[tx_b];
            int ss = 0;
            for (int i6 = 0; i6 < tx_b / symbolSize; ++i6) {
                for (int j = 0; j < CodOutB; ++j) {
                    interleavedSourceSerial[ss++] = interleavedSource[i6][j];
                }
            }
            int codelength = (int)Math.pow(2.0, spreadingFactor);
            double[] spreadingCode = LoRaTransceiver.getcode(codelength);
            int[] spreadedSeq = new int[tx_b * codelength];
            for (int i7 = 0; i7 < tx_b; ++i7) {
                for (int j = 0; j < codelength; ++j) {
                    spreadedSeq[i7 * codelength + j] = (int)((double)interleavedSourceSerial[i7] * spreadingCode[j]);
                }
            }
            int rows = spreadedSeq.length;
            int cols = chirp.length;
            double[][] tx_modulated = new double[rows][cols];
            double[] txSignal = new double[rows * cols];
            for (int i8 = 0; i8 < spreadedSeq.length; ++i8) {
                for (int j = 0; j < chirp.length; ++j) {
                    tx_modulated[i8][j] = (double)spreadedSeq[i8] * chirp[j];
                    txSignal[i8 * cols + j] = tx_modulated[i8][j];
                }
            }
            double[] rxSignal = LoRaTransceiver.AWGNchannel(spreadingFactor, CodingRate, spreadingCode, txSignal);
            double[] rxDemodulated = new double[rxSignal.length / chirp.length];
            for (int i9 = 0; i9 < rxSignal.length / chirp.length; ++i9) {
                double x = 0.0;
                for (int j = 0; j < chirp.length; ++j) {
                    x += rxSignal[i9 * chirp.length + j] * chirp[j];
                }
                rxDemodulated[i9] = x;
            }
            double[] rxDespread = new double[rxDemodulated.length / codelength];
            for (int i10 = 0; i10 < rxDemodulated.length / codelength; ++i10) {
                double x = 0.0;
                for (int j = 0; j < codelength; ++j) {
                    x += spreadingCode[j] * rxDemodulated[i10 * codelength + j];
                }
                rxDespread[i10] = x / (double)codelength;
            }
            double[][] rxDespreadMat = new double[rxDespread.length / symbolSize][symbolSize];
            for (int i11 = 0; i11 < rxDespread.length / symbolSize; ++i11) {
                for (int j = 0; j < symbolSize; ++j) {
                    rxDespreadMat[i11][j] = rxDespread[i11 * symbolSize + j];
                }
            }
            double[][] rxDeInterleave = new double[rxDespread.length / symbolSize][symbolSize];
            double s = rxDespread.length / symbolSize;
            for (int j = 0; j < symbolSize; ++j) {
                for (i = 0; i < rxDespread.length / symbolSize; ++i) {
                    s = i < j ? (double)(rxDespread.length / symbolSize - j + i) : (double)(i - j);
                    rxDeInterleave[i][j] = rxDespreadMat[(int)s][j];
                }
            }
            double[][] rxDeNRZ = new double[rxDespread.length / symbolSize][symbolSize];
            for (i = 0; i < rxDespread.length / symbolSize; ++i) {
                for (int j = 0; j < symbolSize; ++j) {
                    rxDeNRZ[i][j] = rxDeInterleave[i][j] > 0.0 ? 1.0 : 0.0;
                }
            }
            double[] receivedData = new double[rxDespread.length / symbolSize * symbolSize];
            int ss1 = 0;
            for (int i12 = 0; i12 < rxDespread.length / symbolSize; ++i12) {
                for (int j = 0; j < symbolSize; ++j) {
                    receivedData[ss1++] = rxDeNRZ[i12][j];
                }
            }
            byte[] cb = new byte[receivedData.length];
            for (int i13 = 0; i13 < receivedData.length; ++i13) {
                cb[i13] = binarySource[i13];
                errBits += (double)cb[i13] == receivedData[i13] ? 0.0 : 1.0;
            }
        }
        return errBits;
    }

    public static byte[] encoder(int CR, byte[] binarySource, int CodInB, int CodOutB) {
        int j;
        int i;
        byte[] reg1 = new byte[]{0, 0, 0, 0, 0};
        byte[] reg2 = new byte[]{0, 0, 0, 0};
        byte[] reg3 = new byte[]{0, 0, 0, 0, 0};
        byte[] reg4 = new byte[]{0, 0, 0, 0};
        byte[][] codedSource = null;
        byte[] codedSourceOut = null;
        int nSymbols = binarySource.length / CodInB;
        codedSource = new byte[nSymbols][CodOutB];
        codedSourceOut = new byte[nSymbols * CodOutB];
        switch (CR) {
            case 0: {
                codedSourceOut = binarySource;
                break;
            }
            case 1: {
                byte xor7;
                byte xor6;
                byte xor5;
                byte xor4;
                byte xor3;
                byte xor2;
                byte xor1;
                for (i = 0; i < nSymbols; ++i) {
                    reg1[0] = binarySource[i * CodInB];
                    reg2[0] = binarySource[i * CodInB + 1];
                    reg3[0] = binarySource[i * CodInB + 2];
                    reg4[0] = binarySource[i * CodInB + 3];
                    xor1 = (byte)((reg1[0] + reg1[1] + reg1[2] + reg1[3] + reg1[4]) % 2);
                    xor2 = (byte)((reg1[0] + reg1[2] + reg1[3] + reg1[4]) % 2);
                    xor3 = (byte)((reg2[0] + reg2[1] + reg2[2] + reg2[3]) % 2);
                    xor4 = (byte)((reg3[0] + reg3[1] + reg3[3] + reg3[4]) % 2);
                    xor5 = (byte)((reg3[0] + reg3[2] + reg3[4]) % 2);
                    xor6 = (byte)((reg4[0] + reg4[2] + reg4[3]) % 2);
                    xor7 = (byte)((reg4[0] + reg4[1] + reg4[3]) % 2);
                    codedSource[i][0] = xor1;
                    codedSource[i][1] = (byte)((xor2 + xor3) % 2);
                    codedSource[i][2] = (byte)((xor3 + xor4) % 2);
                    codedSource[i][3] = (byte)((xor5 + xor6) % 2);
                    codedSource[i][4] = xor7;
                    reg1[4] = reg1[3];
                    reg3[4] = reg3[3];
                    for (int j2 = 3; j2 > 0; --j2) {
                        reg1[j2] = reg1[j2 - 1];
                        reg2[j2] = reg2[j2 - 1];
                        reg3[j2] = reg3[j2 - 1];
                        reg4[j2] = reg4[j2 - 1];
                    }
                }
                break;
            }
            case 2: {
                byte xor4;
                byte xor3;
                byte xor2;
                byte xor1;
                for (i = 0; i < nSymbols; ++i) {
                    reg1[0] = binarySource[i * CodInB];
                    reg2[0] = binarySource[i * CodInB + 1];
                    xor1 = (byte)((reg1[0] + reg1[3] + reg1[4]) % 2);
                    xor2 = (byte)((reg1[0] + reg1[1] + reg1[2] + reg1[4]) % 2);
                    xor3 = (byte)((reg2[1] + reg2[3]) % 2);
                    xor4 = (byte)((reg2[0] + reg2[2] + reg2[3]) % 2);
                    codedSource[i][0] = xor1;
                    codedSource[i][1] = (byte)((xor2 + xor3) % 2);
                    codedSource[i][2] = xor4;
                    reg1[4] = reg1[3];
                    for (int j3 = 3; j3 > 0; --j3) {
                        reg1[j3] = reg1[j3 - 1];
                        reg2[j3] = reg2[j3 - 1];
                    }
                }
                break;
            }
            case 3: {
                byte xor7;
                byte xor6;
                byte xor5;
                byte xor4;
                byte xor3;
                byte xor2;
                byte xor1;
                for (i = 0; i < nSymbols; ++i) {
                    reg1[0] = binarySource[i * CodInB];
                    reg2[0] = binarySource[i * CodInB + 1];
                    reg3[0] = binarySource[i * CodInB + 2];
                    reg4[0] = binarySource[i * CodInB + 3];
                    xor1 = (byte)((reg1[0] + reg1[1] + reg1[2] + reg1[3] + reg1[4]) % 2);
                    xor2 = (byte)((reg1[0] + reg1[2] + reg1[3] + reg1[4]) % 2);
                    xor3 = (byte)((reg2[0] + reg2[1] + reg2[2] + reg2[3]) % 2);
                    xor4 = (byte)((reg3[0] + reg3[2] + reg3[4]) % 2);
                    xor5 = (byte)((reg3[0] + reg3[1] + reg3[2] + reg3[4]) % 2);
                    xor6 = (byte)((reg4[0] + reg4[2] + reg4[3]) % 2);
                    xor7 = (byte)((reg4[0] + reg4[1] + reg4[3]) % 2);
                    byte xor8 = (byte)((reg1[0] + reg1[1] + reg1[3] + reg1[4]) % 2);
                    byte xor9 = (byte)((reg2[0] + reg2[2] + reg2[3]) % 2);
                    byte xor10 = (byte)((reg3[0] + reg3[1] + reg3[2] + reg3[3] + reg3[4]) % 2);
                    codedSource[i][0] = xor1;
                    codedSource[i][1] = (byte)((xor2 + xor3) % 2);
                    codedSource[i][2] = (byte)((xor3 + xor4) % 2);
                    codedSource[i][3] = (byte)((xor5 + xor6) % 2);
                    codedSource[i][4] = xor7;
                    codedSource[i][5] = (byte)((xor7 + xor8) % 2);
                    codedSource[i][6] = (byte)((xor9 + xor10) % 2);
                    reg1[4] = reg1[3];
                    reg3[4] = reg3[3];
                    for (int j4 = 3; j4 > 0; --j4) {
                        reg1[j4] = reg1[j4 - 1];
                        reg2[j4] = reg2[j4 - 1];
                        reg3[j4] = reg3[j4 - 1];
                        reg4[j4] = reg4[j4 - 1];
                    }
                }
                break;
            }
            case 4: {
                for (i = 0; i < nSymbols; ++i) {
                    reg1[0] = binarySource[i * CodInB];
                    codedSource[i][0] = (byte)((reg1[0] + reg1[3] + reg1[4]) % 2);
                    codedSource[i][1] = (byte)((reg1[0] + reg1[1] + reg1[2] + reg1[4]) % 2);
                    for (j = 4; j > 0; --j) {
                        reg1[j] = reg1[j - 1];
                    }
                }
                break;
            }
        }
        if (CR != 0) {
            for (i = 0; i < nSymbols; ++i) {
                for (j = 0; j < CodOutB; ++j) {
                    codedSourceOut[i * CodOutB + j] = codedSource[i][j];
                }
            }
        }
        return codedSourceOut;
    }

    public static double[][] generateHadamard(int codelength) {
        double[][] hadamard = new double[codelength][codelength];
        hadamard[0][0] = 1.0;
        for (int k = 1; k < codelength; k += k) {
            for (int i = 0; i < k; ++i) {
                for (int j = 0; j < k; ++j) {
                    hadamard[i + k][j] = hadamard[i][j];
                    hadamard[i][j + k] = hadamard[i][j];
                    hadamard[i + k][j + k] = -1.0 * hadamard[i][j];
                }
            }
        }
        return hadamard;
    }

    public static double[] getcode(int codelength) {
        return LoRaTransceiver.generateHadamard(codelength)[codelength - 1];
    }

    public static double[] AWGNchannel(int SF, double codingRate, double[] spreadingCode, double[] txSignal) {
        double eB = 0.5;
        double SNR = -60.0;
        double eBN0 = SNR - Math.log(codingRate * (double)(SF / spreadingCode.length));
        double N0 = eB * Math.pow(10.0, -eBN0 / 10.0);
        double[] h = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.3};
        double[] sm = LoRaTransceiver.filter(h, txSignal);
        double[] channelSignal = new double[txSignal.length];
        for (int i = 0; i < txSignal.length; ++i) {
            Random random = new Random();
            channelSignal[i] = Math.sqrt(N0) * random.nextGaussian() + sm[i];
        }
        return channelSignal;
    }

    public static double[] filter(double[] h, double[] txSignal) {
        int n = txSignal.length;
        int m = Math.min(h.length, txSignal.length);
        double[] filteredData = new double[n];
        for (int k = 0; k < n; ++k) {
            filteredData[k] = 0.0;
            int v = k < m ? k + 1 : m;
            for (int i = 0; i < v; ++i) {
                int n2 = k;
                filteredData[n2] = filteredData[n2] + h[i] * txSignal[k - i];
            }
        }
        return filteredData;
    }

    public static byte[] getStringToBinary(String inputMsg) {
        Object s2 = "";
        for (int i = 0; i < inputMsg.length(); ++i) {
            char c = inputMsg.charAt(i);
            s2 = (String)s2 + String.format("%8s", Integer.toBinaryString(c)).replaceAll(" ", "0");
        }
        s2 = ((String)s2).replaceAll("0", "\u0000");
        s2 = ((String)s2).replaceAll("1", "\u0001");
        byte[] binarySource = ((String)s2).getBytes();
        return binarySource;
    }
}

