/*
 * Decompiled with CFR 0.152.
 */
package natural_events;

import device.DeviceList;
import device.DeviceWithRadio;
import device.MobileG;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import map.MapLayer;
import map.NetworkParameters;
import project.Project;
import utilities.MapCalc;
import utilities.UColor;

public class Gas2
extends MobileG {
    protected LinkedList<Double> valueTime;
    protected LinkedList<Double> values;
    protected int valueIndex = 0;
    private String idFL = "A";

    public Gas2(double x, double y, double z, double radius) {
        super(x, y, z, radius, "", DeviceList.number++);
    }

    public Gas2(double x, double y, double z, double radius, int id) {
        super(x, y, z, radius, "", id);
    }

    public Gas2(double x, double y, double z, double radius, String gpsFileName, int id) {
        super(x, y, z, radius, gpsFileName, id);
    }

    public Gas2(String x, String y, String z, String radius, String gpsFileName, int id) {
        super(Double.valueOf(x), Double.valueOf(y), Double.valueOf(z), Double.valueOf(radius), gpsFileName, id);
    }

    @Override
    public void draw(Graphics g2) {
        if (this.visible) {
            Graphics2D g = (Graphics2D)g2;
            g.setStroke(new BasicStroke(0.6f));
            this.initDraw(g);
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int x = coord[0];
            int y = coord[1];
            int radius = MapCalc.radiusInPixels(this.radius);
            if (this.inside || this.selected) {
                g.setColor(UColor.ORANGE);
                g.drawLine(x - radius - 3, y - radius - 3, x - radius + 2, y - radius - 3);
                g.drawLine(x - radius - 3, y - radius - 3, x - radius - 3, y - radius + 2);
                g.drawLine(x - radius - 3, y + radius + 3, x - radius + 2, y + radius + 3);
                g.drawLine(x - radius - 3, y + radius + 3, x - radius - 3, y + radius - 2);
                g.drawLine(x + radius + 3, y - radius - 3, x + radius - 2, y - radius - 3);
                g.drawLine(x + radius + 3, y - radius - 3, x + radius + 3, y - radius + 2);
                g.drawLine(x + radius + 3, y + radius + 3, x + radius - 2, y + radius + 3);
                g.drawLine(x + radius + 3, y + radius + 3, x + radius + 3, y + radius - 2);
            }
            if (this.selected) {
                g.setColor(Color.GRAY);
                g.drawOval(x - radius - 4, y - radius - 4, (radius + 4) * 2, (radius + 4) * 2);
            }
            this.drawRadius(x, y, radius, g);
            if (this.displayRadius) {
                this.drawRadius(x, y, radius, g);
            }
            if (NetworkParameters.displayDetails) {
                g.setColor(Color.RED);
                String s = String.format("%2.2f", this.getValue());
                g.drawString("[" + s + "]", x + 15, y + 3);
            }
            g.setColor(Color.ORANGE);
            if (this.nateventFileName.equals("")) {
                g.setColor(Color.WHITE);
            }
            g.fillOval(x - 6, y - 6, 12, 12);
            if (this.underSimulation) {
                g.setColor(UColor.GREEN);
                g.fillOval(x - 3, y - 3, 6, 6);
            } else {
                g.setColor(UColor.ORANGE);
                if (this.gpsFileName.equals("")) {
                    g.setColor(UColor.RED);
                }
                g.fillOval(x - 3, y - 3, 6, 6);
            }
            if (NetworkParameters.displayDetails) {
                g.setColor(Color.BLACK);
                if (MapLayer.dark) {
                    g.setColor(new Color(179, 221, 67));
                }
                g.drawString(this.getName(), x + 12, y - 6);
            }
            if (this.hide == 0) {
                Image image = new ImageIcon(Toolkit.getDefaultToolkit().getImage("res/images/fire.png")).getImage();
                g.drawImage(image, x - 15, y - 25, null);
            }
        }
    }

    @Override
    public void drawId(int x, int y, Graphics g) {
        if (NetworkParameters.displayDetails) {
            g.setColor(Color.BLACK);
            if (MapLayer.dark) {
                g.setColor(new Color(179, 221, 67));
            }
            g.drawString(this.getName(), x + 10, y + 6);
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getIdFL() {
        return this.idFL;
    }

    @Override
    public String getName() {
        return this.getIdFL() + this.id;
    }

    @Override
    public void loadScript() {
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public int execute() {
        return 0;
    }

    @Override
    public void drawRadioLinks(Graphics g, int type) {
    }

    @Override
    public void drawRadioPropagations(Graphics g) {
    }

    @Override
    public void initBattery() {
    }

    @Override
    public Polygon getRadioPolygon() {
        return null;
    }

    @Override
    public void calculatePropagations() {
    }

    @Override
    public void resetPropagations() {
    }

    @Override
    public boolean radioDetect(DeviceWithRadio device) {
        return false;
    }

    @Override
    public void initGeoZoneList() {
    }

    @Override
    public void initBuffer() {
    }

    @Override
    public Gas2 duplicate() {
        this.selected = false;
        Gas2 gas = new Gas2(this.longitude, this.latitude, this.elevation, this.radius);
        gas.setHide(this.hide);
        gas.setDrawBatteryLevel(this.drawBatteryLevel);
        gas.setScriptFileName(this.scriptFileName);
        gas.setSelected(true);
        gas.setGPSFileName(this.gpsFileName);
        gas.setNatEventFileName(this.nateventFileName);
        return gas;
    }

    @Override
    public Gas2 duplicateWithShift(double sLongitude, double sLatitude, double sElevation) {
        Gas2 gas = this.duplicate();
        gas.shift(sLongitude, sLatitude, sElevation);
        return gas;
    }

    @Override
    public double getSensorUnitRadius() {
        return 0.0;
    }

    @Override
    public double getESensing() {
        return 0.0;
    }

    @Override
    public void save(String fileName) {
        try {
            PrintStream fos = null;
            fos = new PrintStream(new FileOutputStream(fileName + File.separator + "gas_" + this.getId()));
            fos.println("List of parameters");
            fos.println("------------------------------------------");
            fos.println("device_type:" + this.getType());
            fos.println("device_id:" + this.getId());
            fos.println("device_longitude:" + this.getLongitude());
            fos.println("device_latitude:" + this.getLatitude());
            fos.println("device_elevation:" + this.getElevation());
            fos.println("device_radius:" + this.getRadius());
            fos.println("device_hide:" + this.getHide());
            if (!this.getGPSFileName().equals("")) {
                fos.println("device_gps_file_name:" + this.getGPSFileName());
            }
            if (!this.getNatEventFileName().equals("")) {
                fos.println("natural_event_file_name:" + this.getNatEventFileName());
            }
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void loadValuesFromFile() {
        this.valueIndex = 0;
        this.valueTime = new LinkedList();
        this.values = new LinkedList();
        BufferedReader b = null;
        try {
            if (!this.nateventFileName.equals("")) {
                String s;
                FileInputStream fis = new FileInputStream(Project.getProjectNatEventPath() + File.separator + this.nateventFileName);
                b = new BufferedReader(new InputStreamReader(fis));
                b.readLine();
                while ((s = b.readLine()) != null) {
                    String[] ts = s.split(" ");
                    this.valueTime.add(Double.parseDouble(ts[0]));
                    this.values.add(Double.parseDouble(ts[1]));
                }
                b.close();
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initForSimulation() {
        super.initForSimulation();
        this.loadValuesFromFile();
        this.valueIndex = 0;
    }

    @Override
    public void toOri() {
        super.toOri();
        this.value = 0.0;
        this.valueIndex = 0;
    }

    @Override
    public double getNextValueTime() {
        if (this.valueTime.size() > 0) {
            return this.valueTime.get(this.valueIndex);
        }
        return 0.0;
    }

    @Override
    public void generateNextValue() {
        if (this.valueTime != null) {
            if (this.valueIndex == this.valueTime.size()) {
                this.valueIndex = 0;
            }
            this.value = this.values.get(this.valueIndex);
            ++this.valueIndex;
            if (this.valueIndex >= this.valueTime.size()) {
                this.valueIndex = 1;
            }
        }
    }

    @Override
    public void drawMarked(Graphics g) {
    }

    @Override
    public String startingName() {
        return null;
    }
}

