/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ezmorph.MorphUtils;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.array.CharArrayMorpher;
import net.sf.ezmorph.array.CharacterObjectArrayMorpher;
import net.sf.ezmorph.object.CharacterObjectMorpher;
import net.sf.ezmorph.primitive.CharMorpher;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONString;
import net.sf.json.regexp.RegexpMatcher;
import net.sf.json.regexp.RegexpUtils;
import net.sf.json.util.JSONDynaBean;
import net.sf.json.util.JSONDynaClass;

public final class JSONUtils {
    private static RegexpMatcher FUNCTION_HEADER_MATCHER;
    private static final String FUNCTION_HEADER_PATTERN = "^function[ ]?\\(.*\\)$";
    private static RegexpMatcher FUNCTION_MACTHER;
    private static RegexpMatcher FUNCTION_PARAMS_MATCHER;
    private static final String FUNCTION_PARAMS_PATTERN = "^function[ ]?\\((.*?)\\)$";
    private static final String FUNCTION_PATTERN = "^function[ ]?\\(.*\\)[ ]?\\{.*\\}$";
    private static final MorpherRegistry morpherRegistry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;

    static {
        morpherRegistry = new MorpherRegistry();
        FUNCTION_HEADER_MATCHER = RegexpUtils.getMatcher(FUNCTION_HEADER_PATTERN);
        FUNCTION_PARAMS_MATCHER = RegexpUtils.getMatcher(FUNCTION_PARAMS_PATTERN);
        FUNCTION_MACTHER = RegexpUtils.getMatcher(FUNCTION_PATTERN);
        MorphUtils.registerStandardMorphers(morpherRegistry);
        morpherRegistry.deregisterMorpher(morpherRegistry.getMorpherFor(Character.TYPE));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.deregisterMorpher(morpherRegistry.getMorpherFor(clazz));
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[C");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.deregisterMorpher(morpherRegistry.getMorpherFor(clazz2));
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("[Ljava.lang.Character;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        morpherRegistry.deregisterMorpher(morpherRegistry.getMorpherFor(clazz3));
        morpherRegistry.registerMorpher(new CharMorpher('\u0000'));
        morpherRegistry.registerMorpher(new CharacterObjectMorpher(new Character('\u0000')));
        morpherRegistry.registerMorpher(new CharArrayMorpher('\u0000'));
        morpherRegistry.registerMorpher(new CharacterObjectArrayMorpher(new Character('\u0000')));
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String getFunctionParams(String function) {
        return FUNCTION_PARAMS_MATCHER.getGroupIfMatches(function, 1);
    }

    public static Class getInnerComponentType(Class type) {
        if (!type.isArray()) {
            return type;
        }
        return JSONUtils.getInnerComponentType(type.getComponentType());
    }

    public static MorpherRegistry getMorpherRegistry() {
        return morpherRegistry;
    }

    public static Map getProperties(JSONObject jsonObject) {
        HashMap<String, Class> properties = new HashMap<String, Class>();
        Iterator keys2 = jsonObject.keys();
        while (keys2.hasNext()) {
            String key = (String)keys2.next();
            properties.put(key, JSONUtils.getTypeClass(jsonObject.get(key)));
        }
        return properties;
    }

    public static Class getTypeClass(Object obj) {
        if (JSONUtils.isNull(obj)) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (JSONUtils.isArray(obj)) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("java.util.List");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (JSONUtils.isFunction(obj)) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("net.sf.json.JSONFunction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (JSONUtils.isBoolean(obj)) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (JSONUtils.isNumber(obj)) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (JSONUtils.isString(obj)) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (JSONUtils.isObject(obj)) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        throw new JSONException("Unsupported type");
    }

    public static boolean isArray(Class clazz) {
        block7: {
            block8: {
                if (clazz == null) break block7;
                if (clazz.isArray()) break block8;
                Class<?> clazz2 = class$10;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$10 = Class.forName("java.util.Collection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.isAssignableFrom(clazz)) break block7;
            }
            return true;
        }
        return false;
    }

    public static boolean isArray(Object obj) {
        if (obj != null && obj.getClass().isArray()) {
            return true;
        }
        return obj instanceof Collection;
    }

    public static boolean isBoolean(Class clazz) {
        block7: {
            block8: {
                if (clazz == null) break block7;
                if (Boolean.TYPE.isAssignableFrom(clazz)) break block8;
                Class<?> clazz2 = class$7;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$7 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.isAssignableFrom(clazz)) break block7;
            }
            return true;
        }
        return false;
    }

    public static boolean isBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return true;
        }
        return obj != null && obj.getClass() == Boolean.TYPE;
    }

    public static boolean isDouble(Class clazz) {
        block7: {
            block8: {
                if (clazz == null) break block7;
                if (Double.TYPE.isAssignableFrom(clazz)) break block8;
                Class<?> clazz2 = class$8;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$8 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.isAssignableFrom(clazz)) break block7;
            }
            return true;
        }
        return false;
    }

    public static boolean isFunction(Object obj) {
        if (obj != null && obj instanceof String) {
            String str = (String)obj;
            return FUNCTION_MACTHER.matches(str);
        }
        return obj != null && obj instanceof JSONFunction;
    }

    public static boolean isFunctionHeader(Object obj) {
        if (obj != null && obj instanceof String) {
            String str = (String)obj;
            return FUNCTION_HEADER_MATCHER.matches(str);
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).isNullObject();
        }
        return JSONNull.getInstance().equals(obj);
    }

    public static boolean isNumber(Class clazz) {
        block27: {
            block28: {
                if (clazz == null) break block27;
                if (Byte.TYPE.isAssignableFrom(clazz)) break block28;
                Class<?> clazz2 = class$11;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$11 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) break block28;
                Class<?> clazz3 = class$12;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$12 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) break block28;
                Class<?> clazz4 = class$13;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$13 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz4.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) break block28;
                Class<?> clazz5 = class$14;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$14 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz5.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) break block28;
                Class<?> clazz6 = class$15;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$15 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz6.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) break block28;
                Class<?> clazz7 = class$8;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$8 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz7.isAssignableFrom(clazz)) break block27;
            }
            return true;
        }
        return false;
    }

    public static boolean isNumber(Object obj) {
        if (obj != null && obj.getClass() == Byte.TYPE || obj != null && obj.getClass() == Short.TYPE || obj != null && obj.getClass() == Integer.TYPE || obj != null && obj.getClass() == Long.TYPE || obj != null && obj.getClass() == Float.TYPE || obj != null && obj.getClass() == Double.TYPE) {
            return true;
        }
        return obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double;
    }

    public static boolean isObject(Object obj) {
        return !JSONUtils.isNumber(obj) && !JSONUtils.isString(obj) && !JSONUtils.isBoolean(obj) && !JSONUtils.isArray(obj) || JSONUtils.isNull(obj);
    }

    public static boolean isString(Class clazz) {
        block11: {
            block12: {
                if (clazz == null) break block11;
                Class<?> clazz2 = class$9;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$9 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) break block12;
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz3.isAssignableFrom(clazz)) break block11;
            }
            return true;
        }
        return false;
    }

    public static boolean isString(Object obj) {
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        return obj != null && obj.getClass() == Character.TYPE;
    }

    public static boolean mayBeJSON(String string) {
        return string != null && ("null".equalsIgnoreCase(string) || string.startsWith("[") && string.endsWith("]") || string.startsWith("{") && string.endsWith("}"));
    }

    public static JSONDynaBean newDynaBean(JSONObject jsonObject) throws Exception {
        Map props = JSONUtils.getProperties(jsonObject);
        Class<?> clazz = class$16;
        if (clazz == null) {
            try {
                clazz = class$16 = Class.forName("net.sf.json.util.JSONDynaBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JSONDynaClass dynaClass = new JSONDynaClass("JSON", clazz, props);
        JSONDynaBean dynaBean = (JSONDynaBean)dynaClass.newInstance();
        dynaBean.setDynamicFormClass(dynaClass);
        return dynaBean;
    }

    public static String numberToString(Number n) {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        JSONUtils.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String quote(String string) {
        if (JSONUtils.isFunction(string)) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public static void testValidity(Object o) {
        if (o != null) {
            if (o instanceof Double) {
                if (((Double)o).isInfinite() || ((Double)o).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers");
                }
            } else if (o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN())) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
        }
    }

    public static Number transformNumber(Number input) {
        if (input instanceof Float) {
            return new Double(input.doubleValue());
        }
        if (input instanceof Short) {
            return new Integer(input.intValue());
        }
        if (input instanceof Byte) {
            return new Integer(input.intValue());
        }
        if (input instanceof Long) {
            Long max = new Long(Integer.MAX_VALUE);
            if (input.longValue() <= max) {
                return new Integer(input.intValue());
            }
        }
        return input;
    }

    public static String valueToString(Object value) {
        if (value == null || JSONUtils.isNull(value)) {
            return "null";
        }
        if (value instanceof JSONFunction) {
            return ((JSONFunction)value).toString();
        }
        if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return JSONUtils.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        return JSONUtils.quote(value.toString());
    }

    public static String valueToString(Object value, int indentFactor, int indent) {
        if (value == null || JSONUtils.isNull(value)) {
            return "null";
        }
        if (value instanceof JSONFunction) {
            return ((JSONFunction)value).toString();
        }
        try {
            String o;
            if (value instanceof JSONString && (o = ((JSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return JSONUtils.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        return JSONUtils.quote(value.toString());
    }

    private JSONUtils() {
    }
}

