/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http.async;

import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.http.Header;
import org.jdesktop.http.Method;
import org.jdesktop.http.Parameter;
import org.jdesktop.http.Request;
import org.jdesktop.http.Response;
import org.jdesktop.http.Session;
import org.jdesktop.xpath.XPathUtils;
import org.w3c.dom.Document;

public class AsyncHttpRequest
extends AbstractBean {
    private ReadyState readyState = ReadyState.UNINITIALIZED;
    private String responseText;
    private int status;
    private String statusText;
    private AsyncWorker worker;
    private boolean asyncFlag;
    private Session s;
    private Exception exception;
    private PropertyChangeListener onReadyStateChange;
    private Request req = new Request();

    public void setSession(Session s) {
        Session old = this.getSession();
        this.s = s;
        this.firePropertyChange("session", old, this.getSession());
    }

    public Session getSession() {
        return this.s;
    }

    public void setOnReadyStateChange(PropertyChangeListener listener) {
        PropertyChangeListener old = this.getOnReadyStateChange();
        this.removeReadyStateChangeListener(old);
        this.addReadyStateChangeListener(listener);
        this.onReadyStateChange = listener;
        this.firePropertyChange("onReadyStateChange", old, listener);
    }

    public final PropertyChangeListener getOnReadyStateChange() {
        return this.onReadyStateChange;
    }

    public final ReadyState getReadyState() {
        return this.readyState;
    }

    public void open(Method method, String url) {
        this.open(method, url, true);
    }

    public void open(Method method, String url, boolean asyncFlag) {
        this.open(method, url, asyncFlag, null, null);
    }

    private void open(Method method, String url, boolean asyncFlag, String username) {
        this.open(method, url, asyncFlag, username, null);
    }

    private void open(Method method, String url, boolean asyncFlag, String username, String password) {
        if (this.worker != null && (this.readyState == ReadyState.SENT || this.readyState == ReadyState.RECEIVING)) {
            throw new IllegalStateException("You must abort() the current task, or wait for it to finish completing before starting a new one!");
        }
        try {
            new URL(url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.reset();
        this.asyncFlag = asyncFlag;
        this.req.setUrl(url);
        this.req.setMethod(method);
        this.setReadyState(ReadyState.OPEN);
    }

    public void setRequestHeader(String header, String value) {
        if (this.getReadyState() != ReadyState.OPEN) {
            throw new IllegalStateException("The AsyncHttpRequest must be opened prior to setting a request header");
        }
        if (header == null || value == null) {
            throw new IllegalArgumentException("Neither the header, nor value, may be null");
        }
        if (header.equalsIgnoreCase("Accept-Charset") || header.equalsIgnoreCase("Accept-Encoding") || header.equalsIgnoreCase("Content-Length") || header.equalsIgnoreCase("Expect") || header.equalsIgnoreCase("Date") || header.equalsIgnoreCase("Host") || header.equalsIgnoreCase("Keep-Alive") || header.equalsIgnoreCase("Referer") || header.equalsIgnoreCase("TE") || header.equalsIgnoreCase("Trailer") || header.equalsIgnoreCase("Transfer-Encoding") || header.equalsIgnoreCase("Upgrade")) {
            // empty if block
        }
        if (header.equalsIgnoreCase("Authorization") || header.equalsIgnoreCase("Content-Base") || header.equalsIgnoreCase("Content-Location") || header.equalsIgnoreCase("Content-MD5") || header.equalsIgnoreCase("Content-Range") || header.equalsIgnoreCase("Content-Type") || header.equalsIgnoreCase("Content-Version") || header.equalsIgnoreCase("Delta-Base") || header.equalsIgnoreCase("Depth") || header.equalsIgnoreCase("Destination") || header.equalsIgnoreCase("ETag") || header.equalsIgnoreCase("Expect") || header.equalsIgnoreCase("From") || header.equalsIgnoreCase("If-Modified-Since") || header.equalsIgnoreCase("If-Range") || header.equalsIgnoreCase("If-Unmodified-Since") || header.equalsIgnoreCase("Max-Forwards") || header.equalsIgnoreCase("MIME-Version") || header.equalsIgnoreCase("Overwrite") || header.equalsIgnoreCase("Proxy-Authorization") || header.equalsIgnoreCase("SOAPAction") || header.equalsIgnoreCase("Timeout")) {
            for (Header h : this.req.getHeaders()) {
                if (!h.getName().equalsIgnoreCase(header)) continue;
                this.req.removeHeader(h);
                this.req.setHeader(new Header(header, value));
                break;
            }
        } else {
            boolean appended = false;
            for (Header h : this.req.getHeaders()) {
                if (!h.getName().equalsIgnoreCase(header)) continue;
                this.req.removeHeader(h);
                this.req.setHeader(new Header(header, h.getValue() + ", " + value));
                appended = true;
                break;
            }
            if (!appended) {
                this.req.setHeader(new Header(header, value));
            }
        }
    }

    public void send() {
        this.send((String)null);
    }

    public void send(String content) {
        if (this.readyState != ReadyState.OPEN) {
            throw new IllegalStateException("AsyncHttpRequest must be in an OPEN state before invokation of the send() method");
        }
        this.worker = this.createAsyncWorker(content);
        this.worker.sendRequest(this.getSession(), content);
    }

    public void send(Document dom) {
        if (dom == null) {
            this.send((String)null);
        } else {
            this.send(XPathUtils.toXML(dom));
        }
    }

    public void abort() {
        if (this.worker != null) {
            this.worker.cancel(true);
            this.worker = null;
        }
        this.reset();
    }

    public String getAllResponseHeaders() {
        if (this.readyState == ReadyState.RECEIVING || this.readyState == ReadyState.LOADED) {
            StringBuffer buffer = new StringBuffer();
            for (Header header : this.worker.response.getHeaders()) {
                buffer.append(header.toString());
                buffer.append("\r\n");
            }
            return buffer.toString();
        }
        return null;
    }

    public String getResponseHeader(String headerLabel) {
        if (this.readyState == ReadyState.RECEIVING || this.readyState == ReadyState.LOADED) {
            StringBuffer buffer = new StringBuffer();
            Header header = this.worker.response.getHeader(headerLabel);
            return header == null ? null : header.getValue();
        }
        return null;
    }

    public String getResponseText() {
        if (this.readyState == ReadyState.RECEIVING) {
            return this.responseText == null ? "" : this.responseText;
        }
        if (this.readyState == ReadyState.LOADED) {
            return this.responseText;
        }
        return "";
    }

    public int getStatus() {
        if (this.readyState == ReadyState.RECEIVING || this.readyState == ReadyState.LOADED) {
            return this.status;
        }
        throw new IllegalStateException("You cannot call getStatus() unless readyState == RECEIVING || LOADING");
    }

    public String getStatusText() {
        if (this.readyState == ReadyState.RECEIVING || this.readyState == ReadyState.LOADED) {
            return this.statusText;
        }
        throw new IllegalStateException("You cannot call getStatusText() unless readyState == RECEIVING || LOADING");
    }

    public void setFollowsRedirects(boolean flag) {
        if (this.readyState != ReadyState.OPEN) {
            throw new IllegalStateException("The request must be OPEN before setting the follows redirects flag");
        }
        this.req.setFollowRedirects(flag);
    }

    public final boolean getFollowRedirects() {
        return this.req.getFollowRedirects();
    }

    public Exception getException() {
        if (this.readyState == ReadyState.LOADED) {
            return this.exception;
        }
        return null;
    }

    public Parameter getParameter(String name) {
        return this.req.getParameter(name);
    }

    public void setParameter(Parameter param) {
        this.req.setParameter(param);
    }

    public void setParameter(String name, String value) {
        this.setParameter(new Parameter(name, value));
    }

    public Parameter[] getParameters() {
        return this.req.getParameters();
    }

    public void setParameters(Parameter ... params) {
        this.req.setParameters(params);
    }

    public void addReadyStateChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener("readyState", listener);
    }

    public void removeReadyStateChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener("readyState", listener);
    }

    public PropertyChangeListener[] getReadyStateChangeListeners() {
        return super.getPropertyChangeListeners("readyState");
    }

    protected AsyncWorker createAsyncWorker(String content) {
        return new AsyncWorker();
    }

    protected void reset() {
        this.exception = null;
        this.req = new Request();
        this.req.setFollowRedirects(false);
        String old = this.responseText;
        this.responseText = null;
        this.firePropertyChange("responseText", old, null);
        this.setStatus(-1);
        this.setStatusText(null);
        this.setReadyState(ReadyState.UNINITIALIZED);
    }

    protected void handleResponse(String responseText) throws Exception {
    }

    private void setReadyState(ReadyState state) {
        ReadyState old = this.readyState;
        this.readyState = state;
        this.firePropertyChange("readyState", (Object)old, (Object)this.readyState);
    }

    private void setStatus(int status) {
        int old = this.status;
        this.status = status;
        this.firePropertyChange("status", old, this.status);
    }

    private void setStatusText(String text) {
        String old = this.statusText;
        this.statusText = text;
        this.firePropertyChange("statusText", old, this.statusText);
    }

    protected class AsyncWorker
    extends SwingWorker {
        private String data;
        private Session s;
        private Response response;

        protected AsyncWorker() {
        }

        private void sendRequest(Session s, String data) {
            this.s = s == null ? new Session() : s;
            this.safeSetReadyState(ReadyState.SENT);
            this.data = data;
            if (AsyncHttpRequest.this.asyncFlag) {
                this.execute();
            } else {
                this.run();
                this.done();
            }
        }

        protected Object doInBackground() throws Exception {
            try {
                this.response = null;
                AsyncHttpRequest.this.req.setBody(this.data);
                this.response = this.s.execute(AsyncHttpRequest.this.req);
                this.safeSetReadyState(ReadyState.RECEIVING);
                AsyncHttpRequest.this.responseText = this.response.getBody();
                AsyncHttpRequest.this.handleResponse(AsyncHttpRequest.this.responseText);
                return AsyncHttpRequest.this.responseText;
            }
            catch (Exception e) {
                AsyncHttpRequest.this.exception = e;
                return null;
            }
        }

        protected void safeSetReadyState(final ReadyState state) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AsyncHttpRequest.this.setReadyState(state);
                    }
                });
            } else {
                AsyncHttpRequest.this.setReadyState(state);
            }
        }

        protected void done() {
            AsyncHttpRequest.this.setReadyState(ReadyState.LOADED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReadyState {
        UNINITIALIZED,
        OPEN,
        SENT,
        RECEIVING,
        LOADED;

    }
}

