/*
 * Decompiled with CFR 0.152.
 */
package radio_module;

import device.DeviceWithRadio;
import simulation.SimulationInputs;

public class RadioDetection {
    public static final int SIMPLE_DETECTION = 0;
    public static final int POWER_RECEPTION_DETECTION = 1;
    public static final int THREED_DETECTION = 2;
    public static final int REAL_DETECTION = 3;

    public static boolean simpleDetection(DeviceWithRadio device1, DeviceWithRadio device2) {
        if (device1.canCommunicateWith(device2)) {
            if (SimulationInputs.symmetricalLinks) {
                return device1.contains(device2) || device2.contains(device1);
            }
            return device1.contains(device2);
        }
        return false;
    }

    public static boolean powerReceptionDetection(DeviceWithRadio device1, DeviceWithRadio device2) {
        if (device1.canCommunicateWith(device2) && RadioDetection.getPowerReception(device1, device2) > device2.getRequiredQuality()) {
            if (SimulationInputs.symmetricalLinks) {
                return device1.contains(device2) || device2.contains(device1);
            }
            return device1.contains(device2);
        }
        return false;
    }

    public static boolean threeDDetection(DeviceWithRadio device1, DeviceWithRadio device2) {
        return device1.canCommunicateWith(device2) && RadioDetection.getPowerReception(device1, device2) > device2.getRequiredQuality();
    }

    public static double getPowerReception(DeviceWithRadio device1, DeviceWithRadio device2) {
        return device1.getTransmitPower() - RadioDetection.getAttenuation(device1, device1.distance(device2));
    }

    public static double getAttenuation(DeviceWithRadio device, double distance) {
        double f = 2.9979E8;
        double lambda2 = f / device.getCurrentRadioModule().getFrequency();
        double attenuation = 20.0 * Math.log10(Math.PI * 4 * distance / lambda2);
        return attenuation;
    }
}

