/*
 * Decompiled with CFR 0.152.
 */
package radio_module;

import device.SensorNode;
import java.io.PrintStream;
import radio_module.RadioModule;
import utilities.UColor;

public class RadioModule_ZigBee
extends RadioModule {
    public RadioModule_ZigBee(SensorNode sensorNode, String name) {
        super(sensorNode, name);
        this.init();
    }

    @Override
    public void init() {
        this.frequency = 2.4E9;
        this.radioRangeColor1 = UColor.PURPLE_TTRANSPARENT;
        this.radioRangeColor2 = UColor.PURPLE_TRANSPARENT;
        this.setRadioRangeRadius(100.0);
        this.setRadioRangeRadiusOri(100.0);
    }

    @Override
    public int getStandard() {
        return 1;
    }

    @Override
    public String getStandardName() {
        return "ZIGBEE";
    }

    @Override
    public double getTransmitPower() {
        double tpW = Math.pow(10.0, this.transmitPower / 10.0) / 1000.0;
        double nTpW = tpW * 1000000.0;
        nTpW = nTpW * this.pl / 100.0;
        double nTpDbm = 10.0 * Math.log10(nTpW / 1000.0);
        return nTpDbm;
    }

    @Override
    public RadioModule duplicate(SensorNode sensorNode) {
        RadioModule_ZigBee nRadioModule = new RadioModule_ZigBee(sensorNode, this.name);
        nRadioModule.setMy(this.getMy());
        nRadioModule.setCh(this.getCh());
        nRadioModule.setNId(this.getNId());
        nRadioModule.setRadioRangeRadius(this.getRadioRangeRadius());
        nRadioModule.setETx(this.getETx());
        nRadioModule.setERx(this.getERx());
        nRadioModule.setESleep(this.getESleep());
        nRadioModule.setEListen(this.getEListen());
        nRadioModule.setRadioDataRate(this.getRadioDataRate());
        nRadioModule.setRadioConsoTxModel(this.getRadioConsoTxModel());
        nRadioModule.setRadioConsoRxModel(this.getRadioConsoRxModel());
        return nRadioModule;
    }

    public static String getPayLoad(String data) {
        return "";
    }

    @Override
    public void save(PrintStream fos, RadioModule currentRadioModule) {
        if (currentRadioModule.getName().equals(this.getName())) {
            fos.println("current_radio_name:" + this.getName());
        } else {
            fos.println("radio_name:" + this.getName());
        }
        fos.println("radio_standard:" + this.getStandardName());
        fos.println("radio_my:" + this.getMy());
        fos.println("radio_channel:" + this.getCh());
        fos.println("radio_network_id:" + this.getNId());
        fos.println("radio_radius:" + this.getRadioRangeRadius());
        fos.println("radio_etx:" + this.getETx());
        fos.println("radio_erx:" + this.getERx());
        fos.println("radio_esleep:" + this.getESleep());
        fos.println("radio_elisten:" + this.getEListen());
        fos.println("radio_data_rate:" + this.getRadioDataRate());
        fos.println("conso_tx_model:" + this.getRadioConsoTxModel());
        fos.println("conso_rx_model:" + this.getRadioConsoRxModel());
    }
}

