/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_ANGLE
extends Command {
    protected String arg1 = "";
    protected String arg2 = "";
    protected String arg3 = "";
    protected String arg4 = "";

    public Command_ANGLE(SensorNode sensor, String arg1, String arg2, String arg3, String arg4) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
        this.arg4 = arg4;
    }

    @Override
    public double execute() {
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " Calculate Angle.");
        String prev = this.sensor.getScript().getVariableValue(this.arg2);
        String local = this.sensor.getScript().getVariableValue(this.arg3);
        String next = this.sensor.getScript().getVariableValue(this.arg4);
        String[] prec_tab = prev.split("#");
        String[] local_tab = local.split("#");
        String[] next_tab = next.split("#");
        double prec_X = Double.valueOf(prec_tab[0]);
        double prec_Y = Double.valueOf(prec_tab[1]);
        double local_X = Double.valueOf(local_tab[0]);
        double local_Y = Double.valueOf(local_tab[1]);
        double next_X = Double.valueOf(next_tab[0]);
        double next_Y = Double.valueOf(next_tab[1]);
        double b = this.getAngle(prec_X, prec_Y, local_X, local_Y, next_X, next_Y);
        this.sensor.getScript().addVariable(this.arg1, "" + b);
        return 0.0;
    }

    public double getAngle(double prec_X, double prec_Y, double local_X, double local_Y, double next_X, double next_Y) {
        double b = 0.0;
        double a = 0.0;
        if ((prec_X -= local_X) == (next_X -= local_X) && (prec_Y -= local_Y) == (next_Y -= local_Y)) {
            b = Math.PI * 2;
        } else {
            a = Math.atan2(prec_X, prec_Y);
            if (a < 0.0) {
                a = Math.PI * 2 + a;
            }
            if ((b = Math.atan2(next_X, next_Y)) < 0.0) {
                b = Math.PI * 2 + b;
            }
            if ((b -= a) < 0.0) {
                b = Math.PI * 2 + b;
            }
        }
        return b;
    }

    @Override
    public String toString() {
        return "ANGLE";
    }
}

