/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import cupcarbon.CupCarbonApp;
import device.DeviceList;
import device.SensorNode;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_EDGE
extends Command {
    protected String arg1 = "";
    protected String arg2 = "";

    public Command_EDGE(SensorNode sensor, String arg1, String arg2) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public double execute() {
        if (this.arg1.equals("")) {
            System.err.println("[CupCarbon ERROR] (S" + this.sensor.getId() + "): EDGE function (" + this.arg1 + " is empty)");
            CupCarbonApp.cupCarbonController.displayShortErrMessageTh("ERROR");
        }
        if (this.arg2.equals("")) {
            System.err.println("[CupCarbon ERROR] (S" + this.sensor.getId() + "): EDGE function (" + this.arg2 + " is empty)");
            CupCarbonApp.cupCarbonController.displayShortErrMessageTh("ERROR");
        }
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " EDGE " + this.arg1 + " " + this.arg2);
        int v = Integer.parseInt(this.sensor.getScript().getVariableValue(this.arg1));
        int id = Integer.parseInt(this.sensor.getScript().getVariableValue(this.arg2));
        if (id > 0) {
            if (this.sensor.getId() != id) {
                SensorNode sensor2 = DeviceList.getSensorNodeById(id);
                if (sensor2 == null) {
                    System.err.println("[CupCarbon ERROR] (S" + this.sensor.getId() + "): EDGE function (id " + id + " does not exist)");
                    CupCarbonApp.cupCarbonController.displayVeryShortErrMessage("ERROR!");
                    return 0.0;
                }
                if (v == 1) {
                    DeviceList.addEdge(this.sensor, sensor2);
                } else {
                    DeviceList.removeEdge(this.sensor, sensor2);
                }
            }
        } else {
            System.out.println("[CupCarbon WARNING] (S" + this.sensor.getId() + "): EDGE function (id must be >0) ... id=" + id);
        }
        return 0.0;
    }

    @Override
    public String toString() {
        return "EDGE";
    }
}

