/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import arduino.Bracket;
import cupcarbon.CupCarbonApp;
import device.SensorNode;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_RECEIVE
extends Command {
    protected String arg1 = "";
    protected String arg2 = "";

    public Command_RECEIVE(SensorNode sensor) {
        this.sensor = sensor;
    }

    public Command_RECEIVE(SensorNode sensor, String arg1) {
        this.sensor = sensor;
        this.arg1 = arg1;
    }

    public Command_RECEIVE(SensorNode sensor, String arg1, String arg2) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public double execute() {
        double event = 0.0;
        if (this.sensor.dataAvailable()) {
            this.sensor.getScript().setWaiting(false);
            String rep = this.sensor.readMessage(this.arg1);
            WisenSimulation.simLog.add("S" + this.sensor.getId() + " Buffer available, exit waiting.");
            WisenSimulation.simLog.add("S" + this.sensor.getId() + " READ : " + this.arg1 + " = " + rep);
            return 0.0;
        }
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " is waiting for data ...");
        this.sensor.getScript().setWaiting(true);
        if (this.arg2.equals("")) {
            event = Double.MAX_VALUE;
        } else {
            if (this.sensor.getScript().getVariableValue(this.arg2) == null) {
                System.err.println("[CupCarbon ERROR] (File: " + this.sensor.getScriptFileName() + ") (S" + this.sensor.getId() + "): WAIT function (" + this.arg2 + " is null)");
                CupCarbonApp.cupCarbonController.displayShortErrMessageTh("ERROR");
            }
            this.sensor.readMessage(this.arg1);
            WisenSimulation.simLog.add("S" + this.sensor.getId() + " Buffer empty, exit waiting.");
            WisenSimulation.simLog.add("S" + this.sensor.getId() + " READ : " + this.arg1 + " = \"\"");
            event = Double.parseDouble(this.sensor.getScript().getVariableValue(this.arg2)) / 1000.0;
        }
        return event;
    }

    @Override
    public boolean isWait() {
        return true;
    }

    @Override
    public String getArduinoForm() {
        ++Bracket.n;
        ++Bracket.n;
        Object s = "";
        s = (String)s + "\txbee.readPacket(" + this.arg1 + ");\n";
        s = (String)s + "\tif (xbee.getResponse().isAvailable()) {\n";
        s = (String)s + "\tif (xbee.getResponse().getApiId() == RX_64_RESPONSE) {\n";
        return s;
    }

    @Override
    public String toString() {
        return "WAIT";
    }

    @Override
    public String finishMessage() {
        return "S" + this.sensor.getId() + " has finished waiting.";
    }
}

