/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import arduino.Arduino;
import device.DeviceList;
import device.MessageEventList;
import device.MultiChannels;
import device.SensorNode;
import radio_module.RadioPacketGenerator;
import senscript.Command;
import simulation.SimulationInputs;
import simulation.WisenSimulation;
import utilities.UColor;

public class Command_SEND
extends Command {
    protected boolean writtenInUART = false;
    protected boolean channelFree = false;
    protected String arg1 = "";
    protected String arg2 = "";
    protected String arg3 = "";
    protected String arg4 = "";
    protected String arg5 = "";
    protected String rRadioName = "";
    protected boolean checkForAckMessage = false;

    public Command_SEND(SensorNode sensor, String arg1, String arg2) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = arg2.split(":")[0];
        if (arg2.split(":").length > 1) {
            this.rRadioName = arg2.split(":")[1];
        }
        this.writtenInUART = false;
        this.channelFree = false;
    }

    public Command_SEND(SensorNode sensor, String arg1, String arg2, String arg3) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
        this.writtenInUART = false;
        this.channelFree = false;
    }

    public Command_SEND(SensorNode sensor, String arg1, String arg2, String arg3, String arg4) {
        this.sensor = sensor;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
        this.arg4 = arg4;
        this.writtenInUART = false;
        this.channelFree = false;
    }

    @Override
    public double execute() {
        boolean couleur = false;
        if (this.arg1.equals("!color")) {
            couleur = true;
        }
        if (!couleur && (this.sensor.getScript().getVariableValue(this.arg1) == null || this.sensor.getScript().getVariableValue(this.arg2) == null && !this.arg2.equals("*"))) {
            return 0.0;
        }
        if (couleur) {
            Double v = Double.parseDouble(this.sensor.getScript().getVariableValue(this.arg2));
            int iv = v.intValue() % 13;
            this.sensor.setRadioLinkColor(UColor.colorTab2[iv]);
            return 0.0;
        }
        String message = this.arg1;
        message = this.sensor.getScript().getVariableValue(message);
        int messageLength = message.length();
        if (SimulationInputs.ack && this.checkForAckMessage) {
            if (this.sensor.isAckReceived()) {
                this.sensor.setAckReceived(false);
                this.sensor.setAckWaiting(false);
                this.sensor.setAttempts(0);
                this.writtenInUART = false;
                this.executing = false;
                this.checkForAckMessage = false;
                return 0.0;
            }
            this.sensor.incAttempts();
            this.writtenInUART = true;
        }
        if (!this.writtenInUART) {
            this.sensor.setMessageLost(false);
            this.sensor.setAckReceived(false);
            this.sensor.setAttempts(0);
            WisenSimulation.simLog.add("S" + this.sensor.getId() + " is writing the message : \"" + message + "\" in its buffer.");
            this.writtenInUART = true;
            this.executing = true;
            double ratio = 1.0E-21;
            return ratio * (double)(messageLength * 8);
        }
        if (this.writtenInUART && !this.channelFree) {
            double macProba = 1.0;
            if (SimulationInputs.macLayer) {
                macProba = SimulationInputs.macProba;
            }
            WisenSimulation.simLog.add("S" + this.sensor.getId() + " is listening to the channel");
            double isChannelFree = Math.random();
            if (isChannelFree <= macProba) {
                WisenSimulation.simLog.add("S" + this.sensor.getId() + " the channel is free.");
                this.channelFree = true;
            } else {
                double randomWaitTime = Math.random();
                WisenSimulation.simLog.add("S" + this.sensor.getId() + " the channel is not free, wait for " + randomWaitTime + "ms.");
                return randomWaitTime;
            }
        }
        if (this.channelFree && this.writtenInUART && (!SimulationInputs.ack || this.arg2.equals("*") && this.arg3.equals(""))) {
            WisenSimulation.simLog.add("S" + this.sensor.getId() + " starts sending the message : \"" + message + "\".");
            this.sensor.setAckReceived(false);
            this.sensor.setAckWaiting(false);
            this.writtenInUART = false;
            this.channelFree = false;
            this.executing = false;
            this.sensor.setAttempts(0);
            this.sendOperation(message);
            return 0.0;
        }
        if (this.channelFree && this.writtenInUART && SimulationInputs.ack && !this.sensor.isAckWaiting()) {
            if (this.sensor.getAttempts() < this.sensor.getNumberOfSends()) {
                WisenSimulation.simLog.add("S" + this.sensor.getId() + " starts sending the message : \"" + message + "\".");
                this.sensor.setAckWaiting(true);
                this.sendOperation(message);
                this.checkForAckMessage = true;
                this.writtenInUART = false;
                return this.sensor.getTimeToResend();
            }
            MessageEventList.numberOfLostMessages += this.sensor.getPl() / 100.0;
            MessageEventList.numberOfLostMessages_b += (double)messageLength * (this.sensor.getPl() / 100.0);
            this.sensor.setAckWaiting(false);
            this.checkForAckMessage = false;
            this.sensor.setAckReceived(false);
            this.writtenInUART = false;
            this.channelFree = false;
            this.executing = false;
            this.sensor.setAttempts(0);
            this.sensor.setMessageLost(true);
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public String getArduinoForm() {
        Object s = "";
        if (this.arg1.charAt(0) == '$') {
            s = (String)s + "\tfor(int i=0; i<30; i++) {\n";
            s = (String)s + "\t\tsdata[i] = " + this.arg1.substring(1) + ".charAt(i);\n";
            s = (String)s + "\t}\n";
        } else {
            for (int i = 0; i < this.arg1.length(); ++i) {
                s = (String)s + "\tsdata[" + i + "] = '" + this.arg1.charAt(i) + "';\n";
            }
            s = (String)s + "\tfor(int i=" + this.arg1.length() + "; i < 30; i++) {\n";
            s = (String)s + "\t\tsdata[i] = ' ';\n\t}\n";
        }
        if (this.arg2.equals("") || this.arg2.equals("*")) {
            s = (String)s + "\taddr = XBeeAddress64(0x0, 0xFFFF);\n";
        } else if (this.arg2.equals("0")) {
            String[] info = this.getXBeeInfoById(this.arg2);
            s = (String)s + "\taddr = XBeeAddress16(0x0, " + info[1] + ");\n";
        } else {
            String[] info = this.getXBeeInfoById(this.arg2);
            s = (String)s + "\taddr = XBeeAddress64(" + info[2] + ", " + info[3] + ");\n";
        }
        s = (String)s + "\ttx = Tx64Request(addr, sdata, sizeof(sdata));\n";
        s = (String)s + "\txbee.send(tx);";
        return s;
    }

    public String[] getXBeeInfoById(String id) {
        String[] info = new String[]{"", "", "", ""};
        for (String[] s : Arduino.xbeeList) {
            if (!s[0].equals(id)) continue;
            info[0] = s[1];
            info[1] = s[2];
            info[2] = s[3];
            info[3] = s[4];
        }
        return info;
    }

    @Override
    public String toString() {
        if (this.writtenInUART) {
            return "SEND [BY RADIO]";
        }
        return "SEND [TO UART]";
    }

    public void sendOperation(String message) {
        MessageEventList.numberOfSentMessages += 1.0;
        MessageEventList.numberOfSentMessages_b += (double)message.length();
        this.sensor.consumeTx(RadioPacketGenerator.packetLengthInBits(message, 0, this.sensor.getStandard()));
        if (this.arg2.equals("*")) {
            WisenSimulation.simLog.add("S" + this.sensor.getId() + " has finished sending in a broadcast the message : \"" + message + "\" to the nodes: ");
            double v = 0.0;
            if (!this.arg3.equals("")) {
                v = Double.valueOf(this.sensor.getScript().getVariableValue(this.arg3));
            }
            for (SensorNode rnode : this.sensor.getSensorNodeNeighbors()) {
                if (!this.sensor.propagationDetect(rnode) || !this.sensor.canCommunicateWith(rnode) || (double)rnode.getId() == v) continue;
                MultiChannels.addPacketEvent(2, message, this.sensor, rnode);
            }
        } else {
            String dest = this.arg2;
            dest = this.sensor.getScript().getVariableValue(dest);
            if (!dest.equals("0")) {
                double destNodeId = Double.valueOf(dest);
                SensorNode rnode = DeviceList.getSensorNodeById((int)destNodeId);
                if (rnode != null) {
                    WisenSimulation.simLog.add("S" + this.sensor.getId() + " has finished sending the message : \"" + message + "\" to the node: ");
                    if (this.sensor.propagationDetect(rnode) && this.sensor.canCommunicateWith(rnode)) {
                        if (this.rRadioName.equals("") || this.rRadioName.equals(rnode.getCurrentRadioModule().getName())) {
                            MultiChannels.addPacketEvent(0, message, this.sensor, rnode);
                        }
                    } else {
                        WisenSimulation.simLog.add("S" + this.sensor.getId() + " and S" + destNodeId + "have not the same protocol!");
                    }
                } else {
                    WisenSimulation.simLog.add("S" + this.sensor.getId() + " can not send the message : \"" + message + "\" to the non-existent node: " + destNodeId);
                }
            } else {
                dest = this.arg3;
                dest = this.sensor.getScript().getVariableValue(dest);
                double destNodeId = Double.valueOf(dest);
                if (!dest.equals("0")) {
                    WisenSimulation.simLog.add("S" + this.sensor.getId() + " has finished sending the message : \"" + message + "\" to the nodes with MY=" + destNodeId + ": ");
                    for (SensorNode rnode : DeviceList.sensors) {
                        if (!this.sensor.propagationDetect(rnode) || (double)rnode.getCurrentRadioModule().getMy() != destNodeId || !this.sensor.canCommunicateWith(rnode)) continue;
                        WisenSimulation.simLog.add("  -> S" + rnode.getId() + " ");
                        MultiChannels.addPacketEvent(0, message, this.sensor, rnode);
                    }
                } else {
                    dest = this.arg4;
                    dest = this.sensor.getScript().getVariableValue(dest);
                    if (!dest.equals("0")) {
                        destNodeId = Integer.valueOf(dest).intValue();
                        SensorNode rnode = DeviceList.getSensorNodeById((int)destNodeId);
                        if (rnode != null) {
                            WisenSimulation.simLog.add("S" + this.sensor.getId() + " has finished sending the message : \"" + message + "\" to the node: ");
                            if (this.sensor.canCommunicateWith(rnode)) {
                                MultiChannels.addPacketEvent(0, message, this.sensor, rnode);
                            }
                        } else {
                            WisenSimulation.simLog.add("S" + this.sensor.getId() + " can not send the message : \"" + message + "\" to the non-existent node: " + destNodeId);
                        }
                    }
                }
            }
        }
    }
}

