/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;

public class SenScriptToken {
    public static final int UNKNOWN = -1;
    public static final int NUMBER = 0;
    public static final int OPERATOR = 1;
    public static final int LEFT_PARENTHESIS = 2;
    public static final int RIGHT_PARENTHESIS = 3;
    private int type;
    private double value;
    private char operator;
    private int precedence;

    public SenScriptToken() {
        this.type = -1;
    }

    public SenScriptToken(double value) {
        this.type = 0;
        this.value = value;
    }

    public SenScriptToken(String contents) {
        switch (contents) {
            case "+": {
                this.type = 1;
                this.operator = contents.charAt(0);
                this.precedence = 1;
                break;
            }
            case "-": {
                this.type = 1;
                this.operator = contents.charAt(0);
                this.precedence = 1;
                break;
            }
            case "*": {
                this.type = 1;
                this.operator = contents.charAt(0);
                this.precedence = 2;
                break;
            }
            case "/": {
                this.type = 1;
                this.operator = contents.charAt(0);
                this.precedence = 2;
                break;
            }
            case "%": {
                this.type = 1;
                this.operator = contents.charAt(0);
                this.precedence = 2;
                break;
            }
            case "^": {
                this.type = 1;
                this.operator = contents.charAt(0);
                this.precedence = 3;
                break;
            }
            case "(": {
                this.type = 2;
                break;
            }
            case ")": {
                this.type = 3;
                break;
            }
            default: {
                this.type = 0;
                try {
                    this.value = Double.parseDouble(contents);
                    break;
                }
                catch (Exception ex) {
                    this.type = -1;
                }
            }
        }
    }

    int getType() {
        return this.type;
    }

    double getValue() {
        return this.value;
    }

    int getPrecedence() {
        return this.precedence;
    }

    SenScriptToken operation(SensorNode sensor, double arg1, double arg2) {
        double result = 0.0;
        switch (this.operator) {
            case '+': {
                result = Double.parseDouble(sensor.getScript().getVariableValue("" + arg1)) + Double.parseDouble(sensor.getScript().getVariableValue("" + arg2));
                break;
            }
            case '-': {
                result = Double.parseDouble(sensor.getScript().getVariableValue("" + arg1)) - Double.parseDouble(sensor.getScript().getVariableValue("" + arg2));
                break;
            }
            case '*': {
                System.out.println(arg1);
                System.out.println(arg2);
                System.out.println(sensor.getScript().getVariableValue("" + arg1));
                System.out.println(sensor.getScript().getVariableValue("" + arg2));
                result = Double.parseDouble(sensor.getScript().getVariableValue("" + arg1)) * Double.parseDouble(sensor.getScript().getVariableValue("" + arg2));
                break;
            }
            case '/': {
                result = Double.parseDouble(sensor.getScript().getVariableValue("" + arg1)) / Double.parseDouble(sensor.getScript().getVariableValue("" + arg2));
                break;
            }
            case '%': {
                result = Double.parseDouble(sensor.getScript().getVariableValue("" + arg1)) % Double.parseDouble(sensor.getScript().getVariableValue("" + arg2));
                break;
            }
            case '^': {
                result = Math.pow(Double.parseDouble(sensor.getScript().getVariableValue("" + arg1)), Double.parseDouble(sensor.getScript().getVariableValue("" + arg2)));
            }
        }
        return new SenScriptToken(result);
    }
}

