/*
 * Decompiled with CFR 0.152.
 */
package senscript_functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddFullParentheses {
    private static final Map<String, Integer> OPERATOR_PRECEDENCE = new HashMap<String, Integer>();

    public static String addParentheses(String expression) {
        List<Token> tokens = AddFullParentheses.tokenize(expression);
        List<Token> postfix = AddFullParentheses.toPostfix(tokens);
        ExpressionNode root = AddFullParentheses.buildExpressionTree(postfix);
        return root.toParenthesizedString();
    }

    private static List<Token> tokenize(String expression) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        String operatorPattern = "\\|\\||&&|[&|]";
        String operandPattern = "[^&|()\\s]+(?:\\s*[=<>!]+\\s*[^&|()\\s]+)*";
        Pattern pattern = Pattern.compile("(" + operatorPattern + ")|(" + operandPattern + ")");
        Matcher matcher = pattern.matcher(expression.replaceAll("\\s+", " ").trim());
        while (matcher.find()) {
            String match = matcher.group().trim();
            if (match.matches(operatorPattern)) {
                tokens.add(new Token(match, true));
                continue;
            }
            if (match.isEmpty()) continue;
            tokens.add(new Token(match, false));
        }
        return tokens;
    }

    private static List<Token> toPostfix(List<Token> tokens) {
        ArrayList<Token> output = new ArrayList<Token>();
        Stack<Token> operatorStack = new Stack<Token>();
        for (Token token : tokens) {
            if (!token.isOperator) {
                output.add(token);
                continue;
            }
            while (!operatorStack.isEmpty() && ((Token)operatorStack.peek()).isOperator && OPERATOR_PRECEDENCE.get(((Token)operatorStack.peek()).value) >= OPERATOR_PRECEDENCE.get(token.value)) {
                output.add((Token)operatorStack.pop());
            }
            operatorStack.push(token);
        }
        while (!operatorStack.isEmpty()) {
            output.add((Token)operatorStack.pop());
        }
        return output;
    }

    private static ExpressionNode buildExpressionTree(List<Token> postfix) {
        Stack<ExpressionNode> stack = new Stack<ExpressionNode>();
        for (Token token : postfix) {
            if (!token.isOperator) {
                stack.push(new ExpressionNode(token.value));
                continue;
            }
            ExpressionNode right = (ExpressionNode)stack.pop();
            ExpressionNode left = (ExpressionNode)stack.pop();
            stack.push(new ExpressionNode(token.value, left, right));
        }
        return (ExpressionNode)stack.pop();
    }

    public static void main(String[] args2) {
        String[] testExpressions;
        String expression1 = "a1==0&b<=4|| (cad==a1 && de==4) |efle>=4";
        System.out.println("Expression originale: " + expression1);
        System.out.println("Avec parenth\u00e8ses: " + AddFullParentheses.addParentheses(expression1));
        System.out.println("R\u00e9sultat attendu: (((a1==0) & (b<=4)) || (((cad==a1) && (de==4)) | (efle>=4)))");
        System.out.println();
        for (String expr : testExpressions = new String[]{"a==b&c==d||e>=f", "x>0&&y<10|z==5", "a&b|c&d", "p||q&&r|s", "a1==0", "x>5&y<=10"}) {
            System.out.println("Expression: " + expr);
            System.out.println("Parenth\u00e9s\u00e9e: " + AddFullParentheses.addParentheses(expr));
            System.out.println();
        }
    }

    static {
        OPERATOR_PRECEDENCE.put("|", 1);
        OPERATOR_PRECEDENCE.put("||", 2);
        OPERATOR_PRECEDENCE.put("&", 3);
        OPERATOR_PRECEDENCE.put("&&", 4);
    }

    static class ExpressionNode {
        String operator;
        String operand;
        ExpressionNode left;
        ExpressionNode right;

        ExpressionNode(String operand) {
            this.operand = operand;
        }

        ExpressionNode(String operator, ExpressionNode left, ExpressionNode right) {
            this.operator = operator;
            this.left = left;
            this.right = right;
        }

        public String toParenthesizedString() {
            if (this.operand != null) {
                if (this.operand.contains("==") || this.operand.contains("!=") || this.operand.contains("<=") || this.operand.contains(">=") || this.operand.contains("<") || this.operand.contains(">")) {
                    return "(" + this.operand + ")";
                }
                return this.operand;
            }
            return "(" + this.left.toParenthesizedString() + " " + this.operator + " " + this.right.toParenthesizedString() + ")";
        }
    }

    static class Token {
        String value;
        boolean isOperator;

        Token(String value, boolean isOperator) {
            this.value = value;
            this.isOperator = isOperator;
        }

        public String toString() {
            return this.value;
        }
    }
}

