/*
 * Decompiled with CFR 0.152.
 */
package sensorunit;

import device.Device;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import map.MapLayer;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import sensorunit.SensorUnit;
import utilities.MapCalc;
import utilities.UColor;

public class StdSensorUnit
extends SensorUnit {
    protected double deg = 0.209333;

    public StdSensorUnit(double longitude, double latitude, double elevation, Device node) {
        super(longitude, latitude, elevation, node);
        this.radius = 10.0;
        this.n = 30;
        this.deg = 0.209333;
        this.calculateSensingArea();
    }

    public StdSensorUnit(double longitude, double latitude, double elevation, double radius, Device node) {
        this(longitude, latitude, elevation, node);
        this.radius = radius;
        this.calculateSensingArea();
    }

    @Override
    public void calculateSensingArea() {
        int rayon = MapCalc.radiusInPixels(this.radius);
        double r2 = 0.0;
        double r3 = 0.0;
        double i = 0.0;
        for (int k = 0; k < this.n; ++k) {
            r2 = (double)rayon * Math.cos(i);
            r3 = (double)rayon * Math.sin(i);
            this.polyX[k] = (int)(this.longitude + r2);
            this.polyY[k] = (int)(this.latitude + r3);
            i += this.deg;
        }
    }

    @Override
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setPosition(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    @Override
    public boolean detect(Device device) {
        if (device.getRadius() > 0.0) {
            Polygon poly = new Polygon(this.polyX, this.polyY, this.n);
            GeoPosition gp = new GeoPosition(device.getLatitude(), device.getLongitude());
            Point2D p1 = MapLayer.mapViewer.getTileFactory().geoToPixel(gp, MapLayer.mapViewer.getZoom());
            return poly.contains(p1);
        }
        return false;
    }

    @Override
    public void draw(Graphics g, int mode, boolean detection, boolean buildingDetection) {
        this.calculateSensingArea();
        if (!detection) {
            g.setColor(UColor.WHITE_LLLTRANSPARENT);
        } else {
            g.setColor(UColor.YELLOW_SENSOR_TR);
        }
        if (mode == 0) {
            g.fillPolygon(this.polyX, this.polyY, this.n);
        }
        g.setColor(UColor.BLACK_TTTRANSPARENT);
        g.drawPolygon(this.polyX, this.polyY, this.n);
    }

    @Override
    public void incRadius(int u) {
        this.radius += (double)u;
    }

    @Override
    public void setNode(Device node) {
        this.node = node;
    }

    @Override
    public StdSensorUnit clone() throws CloneNotSupportedException {
        StdSensorUnit newSU = (StdSensorUnit)super.clone();
        return newSU;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    @Override
    public double getElevation() {
        return this.elevation;
    }

    @Override
    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    @Override
    public double getESensing() {
        return this.eSensing;
    }

    @Override
    public void setESensing(double eSensing) {
        this.eSensing = eSensing;
    }

    @Override
    public double getCoverage() {
        return 0.0;
    }

    @Override
    public double getDirection() {
        return 0.0;
    }
}

