/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import cupcarbon.CupCarbonApp;
import device.Device;
import device.DeviceList;
import device.MapObject;
import device.MessageEventList;
import device.MultiChannels;
import device.SensorNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import map.MapLayer;
import project.Project;
import simulation.SimLog;
import simulation.Simulation;
import simulation.SimulationInputs;

public class WisenSimulation
implements Runnable {
    public static double time = 0.0;
    public static double sTime = 0.0;
    public static double resultsWritingTime = 0.0;
    private boolean mobilityAndEvents = false;
    public static boolean showInConsole = true;
    private boolean generateResults = true;
    public static SimLog simLog;
    private boolean stopCondition = false;

    public void simulate() {
        if (this.ready()) {
            this.start_simulation();
        } else {
            Platform.runLater(new Runnable(){

                @Override
                public void run() {
                    Alert alert = new Alert(Alert.AlertType.WARNING);
                    alert.setTitle("Warning");
                    alert.setHeaderText(null);
                    alert.setContentText("Not Ready to simulate!");
                    alert.showAndWait();
                }
            });
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void start_simulation() {
        DeviceList.initAll();
        resultsWritingTime = 0.0;
        simLog = new SimLog();
        this.mobilityAndEvents = SimulationInputs.mobilityAndEvents;
        System.out.println("Mobility: " + this.mobilityAndEvents);
        this.generateResults = SimulationInputs.displayResults;
        System.out.println("Generate Restul File: " + this.generateResults);
        showInConsole = SimulationInputs.showInConsole;
        System.out.println("Initialization ... ");
        simLog.add("===========================");
        simLog.add("Initialization");
        MultiChannels.init();
        MessageEventList.numberOfSentMessages = 0.0;
        MessageEventList.numberOfReceivedMessages = 0.0;
        MessageEventList.numberOfAckMessages = 0.0;
        MessageEventList.numberOfLostMessages = 0.0;
        MessageEventList.numberOfSentMessages_b = 0.0;
        MessageEventList.numberOfReceivedMessages_b = 0.0;
        MessageEventList.numberOfAckMessages_b = 0.0;
        MessageEventList.numberOfLostMessages_b = 0.0;
        for (Device device : DeviceList.devices) {
            device.initForSimulation();
            if (!this.mobilityAndEvents) continue;
            if (!device.getGPSFileName().equals("")) {
                device.setEvent2(device.getNextTime());
            } else {
                device.setEvent2(Double.MAX_VALUE);
            }
            if (!device.getNatEventFileName().equals("")) {
                device.setEvent3(device.getNextValueTime());
                continue;
            }
            device.setEvent3(Double.MAX_VALUE);
        }
        for (SensorNode sensor : DeviceList.sensors) {
            sensor.initForSimulation();
            if (SimulationInputs.clockDrift) {
                sensor.drift();
            }
            if (!this.mobilityAndEvents) continue;
            if (!sensor.getGPSFileName().equals("")) {
                sensor.setEvent2(sensor.getNextTime());
                continue;
            }
            sensor.setEvent2(Double.MAX_VALUE);
        }
        System.out.println("End of Initialization.");
        long startTime = System.currentTimeMillis();
        System.out.println("Start Simulation ... ");
        MapLayer.repaint();
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(Project.getProjectResultPath() + File.separator + "wisen_simulation.csv"));
            if (this.generateResults) {
                ps.print("Time (Sec);");
                for (SensorNode sensor : DeviceList.sensors) {
                    ps.print("S" + sensor.getId() + ";");
                }
                ps.println();
            }
            boolean moving = false;
            Object fMessage = "";
            simLog.add("======================================================");
            simLog.add("START SIMULATION");
            simLog.add("======================================================");
            this.stopCondition = false;
            double min = 0.0;
            boolean allDeadSensors = false;
            double timeEvt = 1.0;
            double previousTime = time = 0.0;
            Platform.runLater(() -> CupCarbonApp.cupCarbonController.simulationTimeLabel.setText("RT"));
            while (time <= SimulationInputs.simulationTime) {
                Object device2;
                Simulation.setSimulating(true);
                if (min == Double.MAX_VALUE) {
                    System.out.println("Infinite WAITs!");
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            WisenSimulation.updateButtons();
                            Simulation.setSimulating(false);
                            Alert alert = new Alert(Alert.AlertType.INFORMATION);
                            alert.setTitle("Simulation");
                            alert.setHeaderText(null);
                            alert.setContentText("Infinite WAITs! [time = " + String.format("%4.4f", sTime) + "]");
                            alert.showAndWait();
                        }
                    });
                    break;
                }
                if (this.stopCondition) {
                    System.out.println("Simulation stopped!");
                    break;
                }
                if (allDeadSensors) {
                    System.out.println("Dead Sensors!");
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            WisenSimulation.updateButtons();
                            Simulation.setSimulating(false);
                            Alert alert = new Alert(Alert.AlertType.INFORMATION);
                            alert.setTitle("Simulation");
                            alert.setHeaderText(null);
                            alert.setContentText("Dead Sensors! [time = " + String.format("%4.4f", sTime) + "]");
                            alert.showAndWait();
                        }
                    });
                    break;
                }
                WisenSimulation.consolPrint(time + " : ");
                simLog.add("");
                simLog.add("----------------------------------------------------------------------------");
                simLog.add("Time : " + time);
                simLog.add("Min (milliseconds) : " + min);
                WisenSimulation.consolPrintln("--------------------------------------");
                WisenSimulation.consolPrint("" + time);
                if (!((String)fMessage).replace("\n", "").equals("")) {
                    simLog.add((String)fMessage);
                }
                fMessage = "";
                WisenSimulation.consolPrintln(" + " + min + " = " + time);
                MultiChannels.goToTheNextTime(min);
                MultiChannels.receivedMessages();
                min = Double.MAX_VALUE;
                for (SensorNode sensor : DeviceList.sensors) {
                    if (sensor.isDead()) continue;
                    WisenSimulation.consolPrint(String.valueOf(sensor) + " [" + sensor.getScript().getCurrent().toString() + "] - ");
                    int state = sensor.execute();
                    if (state == 1) {
                        CupCarbonApp.cupCarbonController.displayShortErrMessage("Infinite loop on S" + sensor.getId());
                        break;
                    }
                    if (min > sensor.getEvent()) {
                        min = sensor.getEvent();
                    }
                    if (!(min > sensor.getLocEventTime())) continue;
                    min = sensor.getLocEventTime();
                }
                WisenSimulation.consolPrintln("");
                double minmv = Double.MAX_VALUE;
                if (this.mobilityAndEvents) {
                    for (SensorNode sensor : DeviceList.sensors) {
                        if (sensor.isDead()) continue;
                        if (sensor.getEvent2() == 0.0) {
                            simLog.add(sensor.getIdFL() + sensor.getId() + " SENSOR MOVING");
                            if (!sensor.getGPSFileName().equals("")) {
                                sensor.moveToNext(true, 0);
                                sensor.setEvent2(sensor.getNextTime());
                            }
                        }
                        if (!(minmv > sensor.getEvent2())) continue;
                        minmv = sensor.getEvent2();
                    }
                    for (Object device2 : DeviceList.devices) {
                        if (((Device)device2).isDead()) continue;
                        if (((Device)device2).getEvent2() == 0.0) {
                            simLog.add(((MapObject)device2).getIdFL() + ((MapObject)device2).getId() + " DEVICE MOVING");
                            if (!((Device)device2).getGPSFileName().equals("")) {
                                ((Device)device2).moveToNext(true, 0);
                                ((Device)device2).setEvent2(((Device)device2).getNextTime());
                            }
                        }
                        if (((Device)device2).getEvent3() == 0.0) {
                            simLog.add(((MapObject)device2).getIdFL() + ((MapObject)device2).getId() + " VALUE GENERATION");
                            if (!((Device)device2).getNatEventFileName().equals("")) {
                                ((Device)device2).generateNextValue();
                                ((Device)device2).setEvent3(((Device)device2).getNextValueTime());
                            }
                        }
                        if (minmv > ((Device)device2).getEvent2()) {
                            minmv = ((Device)device2).getEvent2();
                        }
                        if (!(minmv > ((Device)device2).getEvent3())) continue;
                        minmv = ((Device)device2).getEvent3();
                    }
                }
                WisenSimulation.consolPrintln("");
                boolean waitArrow = false;
                if (min > MultiChannels.getMin()) {
                    min = MultiChannels.getMin();
                    waitArrow = true;
                }
                if (this.mobilityAndEvents) {
                    moving = false;
                    if (minmv < min) {
                        min = minmv;
                        moving = true;
                    }
                }
                WisenSimulation.consolPrintln("");
                if (min > 0.0 || moving) {
                    if (this.generateResults && resultsWritingTime <= time) {
                        ps.print(time + ";");
                        for (SensorNode sensor : DeviceList.sensors) {
                            ps.print(sensor.getBatteryLevel() + ";");
                            WisenSimulation.consolPrint(sensor.getBatteryLevel() + " | ");
                        }
                        ps.println();
                        if (resultsWritingTime <= time) {
                            resultsWritingTime += SimulationInputs.resultsWritingPeriod;
                        }
                    }
                    WisenSimulation.consolPrintln("");
                }
                if (SimulationInputs.clockDrift && timeEvt <= time) {
                    timeEvt += 3600.0;
                    for (SensorNode sensor : DeviceList.sensors) {
                        if (sensor.isDead()) continue;
                        int i = 0;
                        while ((double)i < min) {
                            sensor.drift();
                            ++i;
                        }
                    }
                }
                allDeadSensors = true;
                for (SensorNode sensor : DeviceList.sensors) {
                    if (sensor.isDead()) continue;
                    WisenSimulation.consolPrint(sensor.getEvent() + " : ");
                    sensor.gotoTheNextEvent(min);
                    sensor.goToNextLocEvent(min);
                    sensor.executeLocEvent();
                    if (sensor.getEvent() == 0.0) {
                        fMessage = (String)fMessage + sensor.getScript().getCurrent().finishMessage() + "\n";
                        sensor.gotoTheNextInstruction();
                    }
                    WisenSimulation.consolPrint(sensor.getEvent() + " | ");
                    if (sensor.isDead()) continue;
                    allDeadSensors = false;
                }
                for (SensorNode sensor : DeviceList.sensors) {
                    if (!this.mobilityAndEvents) continue;
                    sensor.setEvent2(sensor.getEvent2() - min);
                }
                device2 = DeviceList.devices.iterator();
                while (device2.hasNext()) {
                    Device device3 = device2.next();
                    if (!this.mobilityAndEvents) continue;
                    device3.setEvent2(device3.getEvent2() - min);
                    device3.setEvent3(device3.getEvent3() - min);
                }
                if ((time += min) < SimulationInputs.simulationTime) {
                    sTime = time;
                }
                WisenSimulation.consolPrintln("");
                WisenSimulation.consolPrintln("------------------------------------------");
                try {
                    CupCarbonApp.cupCarbonController.progress.setProgress(time * 1.0 / SimulationInputs.simulationTime);
                }
                catch (Exception e) {
                    Simulation.setSimulating(false);
                    System.err.println("[CUPCARBO:Simulation] Simulation Progress: " + time * 1.0 / SimulationInputs.simulationTime);
                }
                MapLayer.repaint();
                if (waitArrow && SimulationInputs.arrowsDelay > 0) {
                    Thread.sleep(SimulationInputs.arrowsDelay);
                } else {
                    int d = (int)((double)SimulationInputs.visualDelay * (time - previousTime));
                    if (time < SimulationInputs.simulationTime) {
                        Thread.sleep(d);
                    } else {
                        Simulation.setSimulating(false);
                        System.out.println("Infinite Times!");
                    }
                }
                previousTime = time;
                ps.flush();
            }
            try {
                CupCarbonApp.cupCarbonController.progress.setProgress(0.0);
            }
            catch (Exception e) {
                Simulation.setSimulating(false);
                System.err.println("[CUPCARBO:Simulation] Simulation Progress: 0");
            }
            simLog.close();
            ps.close();
            MultiChannels.init();
            Simulation.setSimulating(false);
            WisenSimulation.updateButtons();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        MapLayer.repaint();
        long endTime = System.currentTimeMillis();
        System.out.println();
        System.out.println("End of Simulation.");
        System.out.println((double)(endTime - startTime) / 1000.0 + " sec");
        Simulation.setSimulating(false);
        Platform.runLater(() -> CupCarbonApp.cupCarbonController.simulationTimeLabel.setText(String.format("RT = %4.4f s", (double)(endTime - startTime) / 1000.0)));
        for (SensorNode sensorNode : DeviceList.sensors) {
            sensorNode.toOri();
            sensorNode.stopAgentSimulation();
        }
        for (Device device : DeviceList.devices) {
            device.toOri();
            device.stopAgentSimulation();
        }
        if (DeviceList.propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
        System.out.println(String.format("Time: %4.4f s", sTime));
        System.out.println("Number of SENT messages: " + MessageEventList.numberOfSentMessages + " [" + MessageEventList.numberOfSentMessages_b + " Bytes]");
        System.out.println("Number of RECEIVED messages: " + MessageEventList.numberOfReceivedMessages + " [" + MessageEventList.numberOfReceivedMessages_b + "  Bytes]");
        System.out.println("Number of SENT & RECEIVED messages: " + (MessageEventList.numberOfReceivedMessages + MessageEventList.numberOfSentMessages) + " [" + (MessageEventList.numberOfReceivedMessages_b + MessageEventList.numberOfSentMessages_b) + "  Bytes]");
        System.out.println("Number of ACK messages: " + MessageEventList.numberOfAckMessages + " [" + MessageEventList.numberOfAckMessages_b + "  Bytes]");
        System.out.println("Number of LOST messages: " + MessageEventList.numberOfLostMessages + " [" + MessageEventList.numberOfLostMessages_b + "  Bytes]");
        System.out.println("Number of Marked Sensors: " + DeviceList.getNumberOfMarkedSensors());
        CupCarbonApp.cupCarbonController.displayShortGoodMessage("End of Simulation");
    }

    @Override
    public void run() {
        this.simulate();
    }

    public static void consolPrint(String txt) {
        if (showInConsole) {
            System.out.print(txt);
        }
    }

    public static void consolPrintln(String txt) {
        if (showInConsole) {
            System.out.println(txt);
        }
    }

    public void stopSimulation() {
        WisenSimulation.updateButtons();
        MultiChannels.init();
        Simulation.setSimulating(false);
        this.stopCondition = true;
        MapLayer.repaint();
    }

    public static void check() {
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.getScriptFileName().equals("")) continue;
            Platform.runLater(new Runnable(){

                @Override
                public void run() {
                    WisenSimulation.updateButtons();
                    Alert alert = new Alert(Alert.AlertType.WARNING);
                    alert.setTitle("Warning");
                    alert.setHeaderText(null);
                    alert.setContentText("Not Ready to simulate!");
                    alert.showAndWait();
                }
            });
            return;
        }
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                WisenSimulation.updateButtons();
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("Valid");
                alert.setHeaderText(null);
                alert.setContentText("Ready to simulate!");
                alert.showAndWait();
            }
        });
    }

    public boolean ready() {
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.getScriptFileName().equals("")) continue;
            return false;
        }
        return true;
    }

    public static void updateButtons() {
        Platform.runLater(() -> {
            CupCarbonApp.cupCarbonController.runSimulationButton.setDisable(false);
            CupCarbonApp.cupCarbonController.qRunSimulationButton.setDisable(false);
            CupCarbonApp.cupCarbonController.updateLabeLInfos();
        });
    }
}

