/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import device.DeviceList;
import device.SensorNode;
import java.awt.Point;
import java.awt.geom.Point2D;
import map.MapLayer;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class MapCalc {
    public static Point2D geoToPixelMap(double latitude, double longitude) {
        return MapLayer.mapViewer.getTileFactory().geoToPixel(new GeoPosition(latitude, longitude), MapLayer.mapViewer.getZoom());
    }

    public static GeoPosition pixelMapToGeo(int x, int y) {
        return MapLayer.mapViewer.getTileFactory().pixelToGeo(new Point(x, y), MapLayer.mapViewer.getZoom());
    }

    public static Point2D pixelPanelToPixelMap(int x, int y) {
        return MapLayer.mapViewer.getTileFactory().geoToPixel(MapLayer.mapViewer.convertPointToGeoPosition(new Point(x, y)), MapLayer.mapViewer.getZoom());
    }

    public static int[] geoToPixelMapA(double latitude, double longitude) {
        Point2D p = MapCalc.geoToPixelMap(latitude, longitude);
        int[] v = new int[]{(int)p.getX(), (int)p.getY()};
        return v;
    }

    public static double distanceInPixels(double x1, double y1, double x2, double y2) {
        Point2D p1 = MapCalc.geoToPixelMap(x1, y1);
        Point2D p2 = MapCalc.geoToPixelMap(x2, y2);
        return p1.distance(p2);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double earth_radius = 6378137.0;
        double rlo1 = Math.toRadians(x1);
        double rla1 = Math.toRadians(y1);
        double rlo2 = Math.toRadians(x2);
        double rla2 = Math.toRadians(y2);
        double dla = (rla2 - rla1) / 2.0;
        double dlo = (rlo2 - rlo1) / 2.0;
        double a = Math.sin(dla) * Math.sin(dla) + Math.cos(rla1) * Math.cos(rla2) * (Math.sin(dlo) * Math.sin(dlo));
        double d = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return earth_radius * d;
    }

    public static int radiusInPixels(double radius) {
        GeoPosition p1 = new GeoPosition(36.0, 40.0);
        Point2D pt1 = MapLayer.mapViewer.getTileFactory().geoToPixel(p1, MapLayer.mapViewer.getZoom());
        int v1 = (int)pt1.getX();
        GeoPosition p2 = new GeoPosition(36.0, 40.0011125);
        Point2D pt2 = MapLayer.mapViewer.getTileFactory().geoToPixel(p2, MapLayer.mapViewer.getZoom());
        int v2 = (int)pt2.getX();
        int rp = (int)(radius * (double)(v2 - v1) / 100.0);
        return rp;
    }

    public static int numberOfSensorsInArea(SensorNode sensorNode, int radius) {
        int n = 0;
        for (SensorNode otherSensor : DeviceList.sensors) {
            if (!(sensorNode.distance(otherSensor) <= (double)radius) || sensorNode == otherSensor) continue;
            ++n;
        }
        return n;
    }
}

