/*
 * Decompiled with CFR 0.152.
 */
package abcd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Duration;
import project.Project;

public class SenScriptEditorFX
extends Application {
    private TextArea codeArea;
    private TextArea errorArea;
    private Label statusLabel;
    private File currentFile = null;
    private Timeline autoSaveTimer;
    private Stage primaryStage;
    private boolean hasUnsavedChanges = false;
    private final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("ATCH", "ATID", "ATPL", "ATMY", "ATNID", "ATND", "ATGET", "RADIO", "SEND", "READ", "PICK", "RECEIVE", "WAIT", "BUFFER", "CBUFFER", "AREADSENSOR", "DREADSENSOR", "BATTERY", "SETBATTERY", "KILL", "SET", "INC", "DEC", "AND", "OR", "XOR", "NOT", "BAND", "BOR", "BXOR", "BNOT", "MATH", "MAX", "MIN", "SMAX", "SMIN", "RAND", "REANDB", "RGAUSS", "CONC", "CHARAT", "LENGTH", "DATA", "RDATA", "NTH", "HASH", "INT", "SADD", "VEC", "VGET", "VSET", "TAB", "TSET", "VDATA", "MOVE", "RMOVE", "ROTATE", "ROUTE", "GETPOS", "GETPOS2", "GETINFO", "DISTANCE", "ANGLE", "ANGLE2", "IF", "ELSE", "END", "WHILE", "FOR", "LOOP", "GOTO", "PRINT", "CPRINT", "PRINTFILE", "MARK", "LED", "EDGE", "DELAY", "TIME", "SIMULATION", "STOP", "SCRIPT", "RSCRIPT"));
    private final Set<String> MATH_FUNCTIONS = new HashSet<String>(Arrays.asList("sqrt", "sin", "cos", "tan", "asin", "acos", "atan", "abs", "pow", "log", "log10", "exp"));
    private final Set<String> OPERATORS = new HashSet<String>(Arrays.asList("==", "!=", "<", ">", "<=", ">=", "+", "-", "*", "/", "%", "=", "&", "|", "^", "~"));

    @Override
    public void start(Stage stage) {
        this.primaryStage = stage;
        this.initializeScriptsDirectory();
        BorderPane root = new BorderPane();
        MenuBar menuBar = this.createMenuBar();
        ToolBar toolBar = this.createToolBar();
        SplitPane mainContent = this.createMainContent();
        this.statusLabel = new Label("Ready - SenScript Editor");
        this.statusLabel.setPadding(new Insets(5.0));
        this.statusLabel.setStyle("-fx-background-color: #f0f0f0; -fx-border-color: #cccccc; -fx-border-width: 1 0 0 0;");
        VBox topContainer = new VBox(menuBar, toolBar);
        root.setTop(topContainer);
        root.setCenter(mainContent);
        root.setBottom(this.statusLabel);
        Scene scene = new Scene(root, 1000.0, 700.0);
        scene.getStylesheets().add(this.getClass().getResource("senscript-editor.css").toExternalForm());
        stage.setTitle("SenScript Editor - CupCarbon Scripting Language (JavaFX)");
        stage.setScene(scene);
        stage.setOnCloseRequest(e -> {
            if (this.hasUnsavedChanges) {
                e.consume();
                this.handleExit();
            }
        });
        this.setupEventHandlers();
        this.setupAutoSave();
        this.loadSampleCode();
        stage.show();
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu("File");
        MenuItem newItem = new MenuItem("New");
        MenuItem openItem = new MenuItem("Open");
        MenuItem saveItem = new MenuItem("Save");
        MenuItem saveAsItem = new MenuItem("Save As");
        MenuItem exitItem = new MenuItem("Exit");
        newItem.setAccelerator(new KeyCodeCombination(KeyCode.N, KeyCombination.CONTROL_DOWN));
        openItem.setAccelerator(new KeyCodeCombination(KeyCode.O, KeyCombination.CONTROL_DOWN));
        saveItem.setAccelerator(new KeyCodeCombination(KeyCode.S, KeyCombination.CONTROL_DOWN));
        saveAsItem.setAccelerator(new KeyCodeCombination(KeyCode.S, KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN));
        newItem.setOnAction(e -> this.newFile());
        openItem.setOnAction(e -> this.openFile());
        saveItem.setOnAction(e -> this.saveFile());
        saveAsItem.setOnAction(e -> this.saveFileAs());
        exitItem.setOnAction(e -> this.handleExit());
        fileMenu.getItems().addAll((MenuItem[])new MenuItem[]{newItem, openItem, new SeparatorMenuItem(), saveItem, saveAsItem, new SeparatorMenuItem(), exitItem});
        Menu editMenu = new Menu("Edit");
        MenuItem validateItem = new MenuItem("Validate Script");
        MenuItem findItem = new MenuItem("Find");
        validateItem.setAccelerator(new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]));
        findItem.setAccelerator(new KeyCodeCombination(KeyCode.F, KeyCombination.CONTROL_DOWN));
        validateItem.setOnAction(e -> this.validateScript());
        findItem.setOnAction(e -> this.showFindDialog());
        editMenu.getItems().addAll((MenuItem[])new MenuItem[]{validateItem, findItem});
        Menu viewMenu = new Menu("View");
        CheckMenuItem lineNumbersItem = new CheckMenuItem("Show Line Numbers");
        CheckMenuItem wordWrapItem = new CheckMenuItem("Word Wrap");
        lineNumbersItem.setSelected(true);
        lineNumbersItem.setOnAction(e -> this.toggleLineNumbers(lineNumbersItem.isSelected()));
        wordWrapItem.setOnAction(e -> this.codeArea.setWrapText(wordWrapItem.isSelected()));
        viewMenu.getItems().addAll((MenuItem[])new MenuItem[]{lineNumbersItem, wordWrapItem});
        menuBar.getMenus().addAll((Menu[])new Menu[]{fileMenu, editMenu, viewMenu});
        return menuBar;
    }

    private ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar();
        Button newBtn = new Button("New");
        Button openBtn = new Button("Open");
        Button saveBtn = new Button("Save");
        Button validateBtn = new Button("Validate");
        Button runBtn = new Button("Run");
        newBtn.setStyle("-fx-font-weight: bold;");
        openBtn.setStyle("-fx-font-weight: bold;");
        saveBtn.setStyle("-fx-font-weight: bold;");
        validateBtn.setStyle("-fx-background-color: #4CAF50; -fx-text-fill: white;");
        runBtn.setStyle("-fx-background-color: #2196F3; -fx-text-fill: white;");
        newBtn.setOnAction(e -> this.newFile());
        openBtn.setOnAction(e -> this.openFile());
        saveBtn.setOnAction(e -> this.saveFile());
        validateBtn.setOnAction(e -> this.validateScript());
        runBtn.setOnAction(e -> this.runScript());
        toolBar.getItems().addAll((Node[])new Node[]{newBtn, openBtn, saveBtn, new Separator(), validateBtn, runBtn});
        return toolBar;
    }

    private SplitPane createMainContent() {
        SplitPane splitPane = new SplitPane();
        splitPane.setOrientation(Orientation.VERTICAL);
        VBox editorContainer = new VBox();
        HBox editorWithNumbers = new HBox();
        this.codeArea = new TextArea();
        this.codeArea.setFont(Font.font("Consolas", 14.0));
        this.codeArea.setStyle("-fx-background-color: #ffffff; -fx-text-fill: #000000;");
        this.codeArea.setPrefRowCount(25);
        VBox.setVgrow(this.codeArea, Priority.ALWAYS);
        editorContainer.getChildren().add(this.codeArea);
        VBox errorContainer = new VBox();
        Label errorTitle = new Label("Errors and Warnings");
        errorTitle.setStyle("-fx-font-weight: bold; -fx-padding: 5;");
        this.errorArea = new TextArea();
        this.errorArea.setEditable(false);
        this.errorArea.setFont(Font.font("Consolas", 12.0));
        this.errorArea.setStyle("-fx-background-color: #fff5f5; -fx-text-fill: #d32f2f;");
        this.errorArea.setPrefRowCount(8);
        errorContainer.getChildren().addAll((Node[])new Node[]{errorTitle, this.errorArea});
        splitPane.getItems().addAll((Node[])new Node[]{editorContainer, errorContainer});
        splitPane.setDividerPositions(0.7);
        return splitPane;
    }

    private void setupEventHandlers() {
        this.codeArea.textProperty().addListener((obs, oldText, newText) -> {
            this.hasUnsavedChanges = true;
            this.updateTitle();
            if (this.autoSaveTimer != null) {
                this.autoSaveTimer.stop();
            }
            Timeline delayedValidation = new Timeline(new KeyFrame(Duration.millis(500.0), e -> {
                this.validateScript();
                this.applySyntaxHighlighting();
            }, new KeyValue[0]));
            delayedValidation.play();
        });
    }

    private void setupAutoSave() {
        this.autoSaveTimer = new Timeline(new KeyFrame(Duration.seconds(30.0), e -> {
            if (this.currentFile != null && this.hasUnsavedChanges && !this.codeArea.getText().trim().isEmpty()) {
                this.autoSaveCurrentFile();
            }
        }, new KeyValue[0]));
        this.autoSaveTimer.setCycleCount(-1);
        this.autoSaveTimer.play();
    }

    private void loadSampleCode() {
        String sampleCode = "";
        this.codeArea.setText(sampleCode);
        this.hasUnsavedChanges = false;
        this.updateTitle();
    }

    private void initializeScriptsDirectory() {
        block3: {
            try {
                boolean created;
                File scriptsDir = new File(Project.getProjectScriptPath());
                if (!scriptsDir.exists() && !(created = scriptsDir.mkdirs())) {
                    this.showErrorDialog("Directory Error", "Failed to create SenScripts directory.\nCheck writing permissions.");
                }
            }
            catch (Exception e) {
                File scriptsDir = new File(System.getProperty("user.home"), "SenScripts");
                if (scriptsDir.exists()) break block3;
                scriptsDir.mkdirs();
            }
        }
    }

    private void newFile() {
        if (this.hasUnsavedChanges && !this.confirmUnsavedChanges()) {
            return;
        }
        this.codeArea.clear();
        this.currentFile = null;
        this.hasUnsavedChanges = false;
        this.updateTitle();
        this.updateStatus("New file created");
    }

    private void openFile() {
        if (this.hasUnsavedChanges && !this.confirmUnsavedChanges()) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open SenScript File");
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("SenScript files (*.csc)", "*.csc"));
        try {
            File scriptsDir = new File(Project.getProjectScriptPath());
            if (scriptsDir.exists()) {
                fileChooser.setInitialDirectory(scriptsDir);
            }
        }
        catch (Exception e) {
            fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        File file = fileChooser.showOpenDialog(this.primaryStage);
        if (file != null) {
            try {
                String content = Files.readString(file.toPath());
                this.codeArea.setText(content);
                this.currentFile = file;
                this.hasUnsavedChanges = false;
                this.updateTitle();
                this.updateStatus("Opened: " + file.getName());
            }
            catch (IOException e) {
                this.showErrorDialog("Error opening file", e.getMessage());
            }
        }
    }

    private void saveFile() {
        if (this.currentFile != null) {
            try {
                Files.writeString(this.currentFile.toPath(), (CharSequence)this.codeArea.getText(), new OpenOption[0]);
                this.hasUnsavedChanges = false;
                this.updateTitle();
                this.updateStatus("Saved: " + this.currentFile.getName());
            }
            catch (IOException e) {
                this.showErrorDialog("Error saving file", e.getMessage());
            }
        } else {
            this.saveFileAs();
        }
    }

    private void saveFileAs() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save SenScript File");
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("SenScript files (*.csc)", "*.csc"));
        try {
            File scriptsDir = new File(Project.getProjectScriptPath());
            if (scriptsDir.exists()) {
                fileChooser.setInitialDirectory(scriptsDir);
            }
        }
        catch (Exception e) {
            fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        File file = fileChooser.showSaveDialog(this.primaryStage);
        if (file != null) {
            try {
                if (!file.getName().endsWith(".csc")) {
                    file = new File(file.getParentFile(), file.getName() + ".csc");
                }
                Files.writeString(file.toPath(), (CharSequence)this.codeArea.getText(), new OpenOption[0]);
                this.currentFile = file;
                this.hasUnsavedChanges = false;
                this.updateTitle();
                this.updateStatus("Saved: " + file.getName());
            }
            catch (IOException e) {
                this.showErrorDialog("Error saving file", e.getMessage());
            }
        }
    }

    private void autoSaveCurrentFile() {
        if (this.currentFile != null) {
            try {
                Files.writeString(this.currentFile.toPath(), (CharSequence)this.codeArea.getText(), new OpenOption[0]);
                this.updateStatus("Auto-saved: " + this.currentFile.getName());
            }
            catch (IOException e) {
                this.updateStatus("Auto-save failed: " + e.getMessage());
            }
        }
    }

    private void validateScript() {
        Task<Void> validationTask = new Task<Void>(){

            @Override
            protected Void call() throws Exception {
                String text = SenScriptEditorFX.this.codeArea.getText();
                ArrayList<String> errors = new ArrayList<String>();
                ArrayList<String> warnings = new ArrayList<String>();
                SenScriptEditorFX.this.validateSyntax(text, errors, warnings);
                Platform.runLater(() -> {
                    SenScriptEditorFX.this.errorArea.clear();
                    if (!errors.isEmpty()) {
                        SenScriptEditorFX.this.errorArea.appendText("ERRORS:\n");
                        for (String error : errors) {
                            SenScriptEditorFX.this.errorArea.appendText("  " + error + "\n");
                        }
                        SenScriptEditorFX.this.errorArea.appendText("\n");
                        SenScriptEditorFX.this.updateStatus("Script has " + errors.size() + " error(s)");
                    }
                    if (!warnings.isEmpty()) {
                        SenScriptEditorFX.this.errorArea.appendText("WARNINGS:\n");
                        for (String warning : warnings) {
                            SenScriptEditorFX.this.errorArea.appendText("  " + warning + "\n");
                        }
                        if (errors.isEmpty()) {
                            SenScriptEditorFX.this.updateStatus("Script has " + warnings.size() + " warning(s)");
                        }
                    }
                    if (errors.isEmpty() && warnings.isEmpty()) {
                        SenScriptEditorFX.this.errorArea.appendText("\u2713 Script syntax is valid!\n");
                        SenScriptEditorFX.this.updateStatus("Script is valid");
                    }
                });
                return null;
            }
        };
        new Thread(validationTask).start();
    }

    private void validateSyntax(String text, List<String> errors, List<String> warnings) {
        String[] lines = text.split("\n");
        Stack<String> controlStack = new Stack<String>();
        boolean inLoop = false;
        for (int i = 0; i < lines.length; ++i) {
            String[] tokens;
            String line = lines[i].trim();
            int lineNum = i + 1;
            if (line.isEmpty() || line.startsWith("//")) continue;
            if (line.toLowerCase().startsWith("if")) {
                controlStack.push("if");
                if (!line.contains("(") || !line.contains(")")) {
                    errors.add("Line " + lineNum + ": IF statement missing parentheses");
                }
            } else if (line.toLowerCase().startsWith("while")) {
                controlStack.push("while");
                if (!line.contains("(") || !line.contains(")")) {
                    errors.add("Line " + lineNum + ": WHILE statement missing parentheses");
                }
            } else if (line.toLowerCase().startsWith("for")) {
                controlStack.push("for");
            } else if (line.toLowerCase().equals("loop")) {
                if (inLoop) {
                    errors.add("Line " + lineNum + ": Multiple LOOP statements not allowed");
                }
                inLoop = true;
                controlStack.push("loop");
            } else if (line.toLowerCase().equals("else")) {
                if (controlStack.isEmpty() || !((String)controlStack.peek()).equals("if")) {
                    errors.add("Line " + lineNum + ": ELSE without matching IF");
                }
            } else if (line.toLowerCase().equals("end")) {
                if (controlStack.isEmpty()) {
                    errors.add("Line " + lineNum + ": END without matching control structure");
                } else {
                    String structure = (String)controlStack.pop();
                    if (structure.equals("loop")) {
                        inLoop = false;
                    }
                }
            }
            if ((tokens = line.split("\\s+")).length <= 0) continue;
            String command = tokens[0].toUpperCase();
            if (!(this.KEYWORDS.contains(command) || command.equals("ELSE") || command.equals("END") || line.contains(":") || command.matches("\\d+") || command.matches("[A-Za-z_][A-Za-z0-9_]*:?"))) {
                warnings.add("Line " + lineNum + ": Unknown command '" + command + "'");
            }
            this.validateSpecificCommands(command, tokens, lineNum, errors, warnings);
        }
        while (!controlStack.isEmpty()) {
            String unmatched = (String)controlStack.pop();
            errors.add("Unmatched " + unmatched.toUpperCase() + " statement");
        }
    }

    private void validateSpecificCommands(String command, String[] tokens, int lineNum, List<String> errors, List<String> warnings) {
        switch (command) {
            case "SEND": {
                if (tokens.length >= 2) break;
                errors.add("Line " + lineNum + ": SEND requires at least 1 parameter");
                break;
            }
            case "SET": {
                if (tokens.length >= 3) break;
                errors.add("Line " + lineNum + ": SET requires variable and value");
                break;
            }
            case "DELAY": {
                if (tokens.length < 2) {
                    errors.add("Line " + lineNum + ": DELAY requires time parameter");
                    break;
                }
                try {
                    Integer.parseInt(tokens[1]);
                }
                catch (NumberFormatException e) {
                    errors.add("Line " + lineNum + ": DELAY time must be a number");
                }
                break;
            }
            case "MATH": {
                if (tokens.length < 4) {
                    errors.add("Line " + lineNum + ": MATH requires function, result variable, and value");
                    break;
                }
                if (this.MATH_FUNCTIONS.contains(tokens[2])) break;
                warnings.add("Line " + lineNum + ": Unknown math function '" + tokens[2] + "'");
            }
        }
    }

    private void runScript() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Run Script");
        alert.setHeaderText("Script Execution");
        alert.setContentText("Script execution functionality would be implemented here.\nThis would integrate with the CupCarbon simulation engine.");
        alert.showAndWait();
    }

    private void showFindDialog() {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle("Find");
        dialog.setHeaderText("Find Text");
        dialog.setContentText("Enter text to find:");
        Optional result = dialog.showAndWait();
        result.ifPresent(searchText -> {
            String content = this.codeArea.getText();
            int index = content.indexOf((String)searchText);
            if (index != -1) {
                this.codeArea.selectRange(index, index + searchText.length());
                this.updateStatus("Found: " + searchText);
            } else {
                this.updateStatus("Not found: " + searchText);
            }
        });
    }

    private void toggleLineNumbers(boolean show) {
        this.updateStatus("Line numbers " + (show ? "enabled" : "disabled"));
    }

    private void applySyntaxHighlighting() {
        this.updateStatus("Syntax highlighting applied (requires RichTextFX for full implementation)");
    }

    private boolean confirmUnsavedChanges() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Unsaved Changes");
        alert.setHeaderText("You have unsaved changes");
        alert.setContentText("Do you want to save your changes before continuing?");
        ButtonType save = new ButtonType("Save");
        ButtonType dontSave = new ButtonType("Don't Save");
        ButtonType cancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{save, dontSave, cancel});
        Optional result = alert.showAndWait();
        if (result.isPresent()) {
            if (result.get() == save) {
                this.saveFile();
                return !this.hasUnsavedChanges;
            }
            if (result.get() == dontSave) {
                return true;
            }
        }
        return false;
    }

    private void handleExit() {
        if (this.hasUnsavedChanges && !this.confirmUnsavedChanges()) {
            return;
        }
        Platform.exit();
    }

    private void updateTitle() {
        Object title = "SenScript Editor - CupCarbon Scripting Language (JavaFX)";
        if (this.currentFile != null) {
            title = (String)title + " - " + this.currentFile.getName();
        }
        if (this.hasUnsavedChanges) {
            title = (String)title + " *";
        }
        this.primaryStage.setTitle((String)title);
    }

    private void updateStatus(String message) {
        this.statusLabel.setText(message);
    }

    private void showErrorDialog(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.showAndWait();
    }

    public static void main(String[] args2) {
        try {
            FileReader fr = new FileReader("senscript-editor.css");
            BufferedReader br = new BufferedReader(fr);
            String string = br.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

