/*
 * Decompiled with CFR 0.152.
 */
package arduino;

import arduino.BeginInstructions;
import arduino.Bracket;
import device.DeviceList;
import device.SensorNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import project.Project;
import senscript.Command;

public class Arduino {
    public static String r = "";
    public static ArrayList<String[]> xbeeList;
    public static Set<String> variables;

    public static void generateCode() {
        try {
            System.out.println("XBEE File OK");
            System.out.println(Project.projectPath + File.separator + "xbee" + File.separator + "xbee.txt");
            FileReader xbeeFile = new FileReader(Project.projectPath + File.separator + "xbee" + File.separator + "xbee.txt");
            BufferedReader br = new BufferedReader(xbeeFile);
            xbeeList = new ArrayList();
            Object row = new String[5];
            try {
                String string;
                while ((string = br.readLine()) != null) {
                    row = string.split(":");
                    xbeeList.add((String[])row);
                }
                br.close();
                xbeeFile.close();
                for (Object[] objectArray : xbeeList) {
                    System.out.println(Arrays.toString(objectArray));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e1) {
            System.out.println("No XBEE File");
            xbeeList = new ArrayList();
            String[] row = new String[]{"1", "GREEN", "A", "0X13A200", "0X40B5EF9E"};
            xbeeList.add(row);
            row = new String[]{"2", "YELLOW", "B", "0X13A200", "0X40B58284"};
            xbeeList.add(row);
            row = new String[]{"3", "RED", "C", "0X13A200", "0X40B5EFA6"};
            xbeeList.add(row);
            row = new String[]{"4", "BLUE", "D", "0X13A200", "0X40BEBA04"};
            xbeeList.add(row);
            row = new String[]{"5", "WHITE", "E", "0X13A200", "0x406E5E6F"};
            xbeeList.add(row);
            for (Object[] objectArray : xbeeList) {
                System.out.println(Arrays.toString(objectArray));
            }
        }
        variables = new HashSet<String>();
        File arduinoDir = new File(Project.projectPath + File.separator + "arduino" + File.separator);
        for (SensorNode sensor : DeviceList.sensors) {
            System.out.println("---------------------------------");
            System.out.println("Sensor: S" + sensor.getId());
            System.out.println("---------------------------------");
            sensor.loadScript();
            LinkedList<Command> linkedList = sensor.getScript().getCommands();
            Bracket.n = 0;
            r = "";
            r = r + "\n";
            r = r + "\tdelay(100);\n";
            r = r + "\tSerial.begin(38400);\n";
            r = r + "\txbee.setSerial(Serial);\n";
            r = r + "\tdelay(100);\n";
            r = r + "\tlcd.begin(16, 2);\n";
            r = r + "\tlcd.setCursor(0,0);\n";
            r = r + "\n";
            for (Command command : linkedList) {
                r = r + command.getArduinoForm() + "\n";
            }
            r = "void setup() {\n" + BeginInstructions.get() + r;
            r = "\nLiquidCrystal lcd(8, 9, 4, 5, 6, 7);\n\n" + r;
            r = "uint8_t* rdata;\n" + r;
            r = "uint8_t sdata[30] ;\n" + r;
            r = "XBeeAddress64 addr;\n" + r;
            r = "Tx64Request tx;\n" + r;
            r = "Rx64Response rx = Rx64Response() ;\n" + r;
            r = "XBee xbee = XBee();\n" + r;
            r = "#include <LiquidCrystal.h>\n\n" + r;
            r = "#include <XBee.h>\n" + r;
            r = r + "\n";
            for (int i = 0; i < Bracket.n; ++i) {
                r = r + "}\n";
            }
            r = r + "}\n";
            try {
                String fname = "arduino_" + sensor.getId();
                arduinoDir = new File(Project.projectPath + "/arduino/" + fname);
                arduinoDir.mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(Project.projectPath + File.separator + "arduino" + File.separator + fname + File.separator + fname + ".ino");
                PrintStream p = new PrintStream(fileOutputStream);
                p.print(r);
                p.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            System.out.println("Code Generation : Finish!");
        }
    }
}

