/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.compression.CompressedGeometryRetained;
import com.sun.j3d.utils.geometry.compression.GeneralizedVertexList;
import com.sun.j3d.utils.geometry.compression.GeometryDecompressor;
import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.PointArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class GeometryDecompressorShape3D
extends GeometryDecompressor {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    private static final boolean statistics = false;
    private static final boolean printInfo = false;
    private int bufferDataType;
    private int dataPresent;
    private GeneralizedVertexList vlist;
    private ArrayList shapes;
    private Color4f curColor;
    private Vector3f curNormal;
    private int origVertexCount;
    private int stripCount;
    private int vertexCount;
    private int triangleCount;
    private long startTime;
    private long endTime;
    private int triOutputType;
    private static final int TRI_SET = 0;
    private static final int TRI_STRIP_SET = 1;
    private static final int TRI_STRIP_AND_FAN_SET = 2;
    private static final int TRI_STRIP_AND_TRI_SET = 3;
    private static final int TYPE_POINT = 1;
    private static final int TYPE_LINE = 2;
    private static final int TYPE_TRIANGLE = 4;
    private static final int FRONTFACE_CCW = 1;

    GeometryDecompressorShape3D() {
    }

    Shape3D[] toTriangleArrays(CompressedGeometryRetained compressedGeometryRetained) {
        return this.decompress(compressedGeometryRetained, 0);
    }

    Shape3D[] toTriangleStripArrays(CompressedGeometryRetained compressedGeometryRetained) {
        return this.decompress(compressedGeometryRetained, 1);
    }

    Shape3D[] toStripAndFanArrays(CompressedGeometryRetained compressedGeometryRetained) {
        return this.decompress(compressedGeometryRetained, 2);
    }

    Shape3D[] toStripAndTriangleArrays(CompressedGeometryRetained compressedGeometryRetained) {
        return this.decompress(compressedGeometryRetained, 3);
    }

    private Shape3D[] decompress(CompressedGeometryRetained compressedGeometryRetained, int n) {
        if (!this.checkVersion(compressedGeometryRetained.majorVersionNumber, compressedGeometryRetained.minorVersionNumber)) {
            return null;
        }
        this.vlist = null;
        this.curColor = null;
        this.curNormal = null;
        this.bufferDataType = compressedGeometryRetained.bufferType;
        this.dataPresent = compressedGeometryRetained.bufferContents;
        this.triOutputType = n;
        this.shapes = new ArrayList();
        super.decompress(compressedGeometryRetained.offset, compressedGeometryRetained.size, compressedGeometryRetained.compressedGeometry);
        this.addShape3D();
        Shape3D[] shape3DArray = new Shape3D[this.shapes.size()];
        return this.shapes.toArray(shape3DArray);
    }

    void outputVertexFormat(boolean bl, boolean bl2, boolean bl3) {
        if (this.vlist != null) {
            this.addShape3D();
        }
        int n = 1;
        if (bl) {
            n |= 2;
        }
        if (bl2) {
            n = bl3 ? (n |= 0xC) : (n |= 4);
        }
        this.vlist = new GeneralizedVertexList(n, 1);
    }

    void outputVertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n) {
        if (this.curNormal != null) {
            vector3f = this.curNormal;
        }
        this.vlist.addVertex(point3f, vector3f, color4f, n);
    }

    void outputColor(Color4f color4f) {
        if (this.vlist.size() > 0) {
            this.addShape3D();
            this.vlist = new GeneralizedVertexList(this.vlist.vertexFormat, 1);
        }
        if (this.curColor == null) {
            this.curColor = new Color4f();
        }
        this.curColor.set(color4f);
    }

    void outputNormal(Vector3f vector3f) {
        if ((this.vlist.vertexFormat & 2) == 0) {
            if (this.vlist.size() > 0) {
                this.addShape3D();
            }
            this.vlist = new GeneralizedVertexList(this.vlist.vertexFormat | 2, 1);
        }
        if (this.curNormal == null) {
            this.curNormal = new Vector3f();
        }
        this.curNormal.set(vector3f);
    }

    private void addShape3D() {
        Material material = new Material();
        if (this.curColor != null) {
            if ((this.vlist.vertexFormat & 0xC) != 12) {
                material.setAmbientColor(this.curColor.x, this.curColor.y, this.curColor.z);
                material.setDiffuseColor(this.curColor.x, this.curColor.y, this.curColor.z);
            } else {
                material.setAmbientColor(this.curColor.x, this.curColor.y, this.curColor.z);
                material.setDiffuseColor(this.curColor.x, this.curColor.y, this.curColor.z, this.curColor.w);
            }
        }
        if ((this.vlist.vertexFormat & 2) == 0) {
            material.setLightingEnable(false);
        } else {
            material.setLightingEnable(true);
        }
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        block0 : switch (this.bufferDataType) {
            case 4: {
                switch (this.triOutputType) {
                    case 0: {
                        TriangleArray triangleArray = this.vlist.toTriangleArray();
                        if (triangleArray == null) break block0;
                        this.shapes.add(new Shape3D((Geometry)triangleArray, appearance));
                        break block0;
                    }
                    case 1: {
                        TriangleStripArray triangleStripArray = this.vlist.toTriangleStripArray();
                        if (triangleStripArray == null) break block0;
                        this.shapes.add(new Shape3D((Geometry)triangleStripArray, appearance));
                        break block0;
                    }
                    case 2: {
                        GeometryStripArray[] geometryStripArrayArray = this.vlist.toStripAndFanArrays();
                        if (geometryStripArrayArray[0] != null) {
                            this.shapes.add(new Shape3D((Geometry)geometryStripArrayArray[0], appearance));
                        }
                        if (geometryStripArrayArray[1] == null) break block0;
                        this.shapes.add(new Shape3D((Geometry)geometryStripArrayArray[1], appearance));
                        break block0;
                    }
                    case 3: {
                        GeometryArray[] geometryArrayArray = this.vlist.toStripAndTriangleArrays();
                        if (geometryArrayArray[0] != null) {
                            this.shapes.add(new Shape3D((Geometry)geometryArrayArray[0], appearance));
                        }
                        if (geometryArrayArray[1] == null) break block0;
                        this.shapes.add(new Shape3D((Geometry)geometryArrayArray[1], appearance));
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryDecompressorShape3D0"));
                    }
                }
            }
            case 2: {
                LineStripArray lineStripArray = this.vlist.toLineStripArray();
                if (lineStripArray == null) break;
                this.shapes.add(new Shape3D((Geometry)lineStripArray, appearance));
                break;
            }
            case 1: {
                PointArray pointArray = this.vlist.toPointArray();
                if (pointArray == null) break;
                this.shapes.add(new Shape3D((Geometry)pointArray, appearance));
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryDecompressorShape3D1"));
            }
        }
    }

    private void beginPrint() {
        System.out.println("\nGeometryDecompressorShape3D");
        switch (this.bufferDataType) {
            case 4: {
                System.out.println(" buffer TYPE_TRIANGLE");
                break;
            }
            case 2: {
                System.out.println(" buffer TYPE_LINE");
                break;
            }
            case 1: {
                System.out.println(" buffer TYPE_POINT");
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryDecompressorShape3D1"));
            }
        }
        System.out.print(" buffer data present: coords");
        if ((this.dataPresent & 1) != 0) {
            System.out.print(" normals");
        }
        if ((this.dataPresent & 2) != 0) {
            System.out.print(" colors");
        }
        if ((this.dataPresent & 4) != 0) {
            System.out.print(" alpha");
        }
        System.out.println();
        this.stripCount = 0;
        this.vertexCount = 0;
        this.triangleCount = 0;
        this.origVertexCount = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void endPrint() {
        this.endTime = System.currentTimeMillis();
    }

    private void printBench() {
        float f = (float)(this.endTime - this.startTime) / 1000.0f;
        System.out.println(" decompression + strip conversion took " + f + " sec.");
        switch (this.bufferDataType) {
            case 1: {
                System.out.println(" points decompressed: " + this.vertexCount + "\n" + " net decompression rate: " + (float)this.vertexCount / f + " points/sec.\n");
                break;
            }
            case 2: {
                System.out.println(" lines decompressed: " + (this.vertexCount - this.stripCount) + "\n" + " net decompression rate: " + (float)(this.vertexCount - this.stripCount) / f + " lines/sec.\n");
                break;
            }
            case 4: {
                System.out.println(" triangles decompressed: " + (this.vertexCount - 2 * this.stripCount) + "\n" + " net decompression rate: " + (float)(this.vertexCount - 2 * this.stripCount) / f + " triangles/sec.\n");
            }
        }
    }

    private void printStats() {
        boolean bl;
        switch (this.triOutputType) {
            case 0: {
                System.out.println(" using individual triangle output");
                break;
            }
            case 1: {
                System.out.println(" using strip output");
                break;
            }
            case 2: {
                System.out.println(" using strips and fans for output");
                break;
            }
            case 3: {
                System.out.println(" using strips and triangles for output");
            }
        }
        System.out.print(" number of Shape3D objects: " + this.shapes.size() + "\n number of Shape3D decompressed vertices: ");
        if (this.triOutputType == 0 || this.bufferDataType == 1) {
            System.out.println(this.vertexCount);
        } else if (this.triOutputType == 3) {
            System.out.println(this.vertexCount + this.triangleCount * 3 + "\n number of strips: " + this.stripCount + "\n number of individual triangles: " + this.triangleCount);
            if (this.stripCount > 0) {
                System.out.println(" vertices/strip: " + (float)this.vertexCount / (float)this.stripCount + "\n triangles represented in strips: " + (this.vertexCount - 2 * this.stripCount));
            }
        } else {
            System.out.println(this.vertexCount + "\n number of strips: " + this.stripCount);
            if (this.stripCount > 0) {
                System.out.println(" vertices/strip: " + (float)this.vertexCount / (float)this.stripCount);
            }
        }
        System.out.print(" vertex data present in last Shape3D: coords");
        if ((this.vlist.vertexFormat & 2) != 0) {
            System.out.print(" normals");
        }
        boolean bl2 = (this.vlist.vertexFormat & 0xC) == 12;
        boolean bl3 = bl = !bl2 && (this.vlist.vertexFormat & 4) == 4;
        if (bl || bl2) {
            System.out.print(" colors");
            if (bl2) {
                System.out.print(" alpha");
            }
        }
        System.out.println();
    }
}

