/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon;

import action.CupActionBlock;
import action.CupActionModifSensorScriptFile;
import action.CupActionStack;
import cupcarbon.CupCarbonApp;
import cupcarbon.CupCarbonController;
import device.DeviceList;
import device.SensorNode;
import java.io.File;
import javafx.embed.swing.SwingNode;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import map.MapLayer;
import project.Project;

public class CupCarbonContextMenu {
    public static boolean drag = false;

    public static void create(final SwingNode sn, final CupCarbonController controller) {
        final ContextMenu contextMenu = new ContextMenu();
        MenuItem item1 = new MenuItem("Add a Sensor Node");
        item1.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                controller.addSensor();
            }
        });
        MenuItem item2 = new MenuItem("Add a Marker");
        item2.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                controller.addMarker();
            }
        });
        MenuItem item3 = new MenuItem("Add a Base Station");
        item3.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                controller.addBaseStation();
            }
        });
        MenuItem item4 = new MenuItem("Add a Mobile");
        item4.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                controller.addMobile();
            }
        });
        MenuItem item5 = new MenuItem("Route from Markers");
        item5.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                controller.routeFromMarkers();
            }
        });
        MenuItem item6 = new MenuItem("SensScript Editor");
        item6.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                controller.openSenScriptWindow();
            }
        });
        MenuItem item7 = new MenuItem("Select All Sensors");
        item7.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                controller.selectAllSensors();
            }
        });
        SeparatorMenuItem menuSep1 = new SeparatorMenuItem();
        SeparatorMenuItem menuSep2 = new SeparatorMenuItem();
        SeparatorMenuItem menuSep3 = new SeparatorMenuItem();
        Menu assignScriptMenu = new Menu("Assign Scripts");
        String[] ls = CupCarbonContextMenu.getScriptFileNames();
        if (ls != null) {
            MenuItem tmpItem = new MenuItem("");
            tmpItem.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent event) {
                    CupCarbonContextMenu.scriptFileApply("");
                    CupCarbonApp.cupCarbonController.getNodeInformations();
                }
            });
            assignScriptMenu.getItems().add(tmpItem);
            for (final String s : ls) {
                tmpItem = new MenuItem(s);
                tmpItem.setOnAction(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent event) {
                        CupCarbonContextMenu.scriptFileApply(s);
                        CupCarbonApp.cupCarbonController.getNodeInformations();
                    }
                });
                assignScriptMenu.getItems().add(tmpItem);
            }
        }
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{item1, item7, menuSep1, assignScriptMenu, item6, menuSep3, item2, item5, menuSep2, item3, item4});
        sn.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.SECONDARY) {
                    drag = true;
                }
            }
        });
        sn.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent event) {
                if (!drag) {
                    if (event.getButton() == MouseButton.SECONDARY) {
                        if (MapLayer.lastKey == '\u0000') {
                            contextMenu.show(sn, event.getScreenX(), event.getScreenY());
                        }
                    } else {
                        contextMenu.hide();
                    }
                }
                drag = false;
                controller.updateLabeLInfos();
            }
        });
    }

    public static void scriptFileApply(String newScriptFileName) {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            String currentScriptFileName = sensor.getScriptFileName();
            CupActionModifSensorScriptFile action = new CupActionModifSensorScriptFile(sensor, currentScriptFileName, newScriptFileName);
            block.addAction(action);
        }
        CupActionStack.add(block);
        CupActionStack.execute();
        MapLayer.repaint();
    }

    public static String[] getScriptFileNames() {
        File scriptFiles = new File(Project.getProjectScriptPath());
        String[] list = scriptFiles.list();
        if (list != null) {
            Object rList = "";
            for (String s : list) {
                if (s.startsWith(".")) continue;
                rList = (String)rList + s + " ";
            }
            return ((String)rList).split(" ");
        }
        return null;
    }
}

