/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon;

import cupcarbon.CupCarbonApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Random;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import project.Project;

public class NaturalEventGeneratorController
implements Initializable {
    @FXML
    private TextArea zone;
    @FXML
    private ComboBox<String> txtLoadFileName;
    @FXML
    private TextField txtFileName;
    @FXML
    private TextField meanField;
    @FXML
    private TextField stdField;
    @FXML
    private TextField sizeField;
    @FXML
    private TextField periodField;

    @FXML
    public void load() {
        if (this.txtLoadFileName.getSelectionModel().getSelectedIndex() > 0) {
            this.txtFileName.setText(((String)this.txtLoadFileName.getSelectionModel().getSelectedItem()).toString());
            this.zone.setText("");
            try {
                FileInputStream in = new FileInputStream(new File(Project.getNatEventFileFromName(((String)this.txtLoadFileName.getSelectionModel().getSelectedItem()).toString())));
                byte[] bytes = new byte[in.available()];
                in.read(bytes);
                this.zone.setText(new String(bytes));
                in.close();
            }
            catch (Exception exception) {}
        } else {
            this.zone.setText("");
            this.txtFileName.setText("");
        }
    }

    @FXML
    public void save() {
        if (!this.txtFileName.getText().equals("")) {
            try {
                String fileName = this.txtFileName.getText();
                fileName = fileName.trim();
                fileName = fileName.replaceAll(" ", "");
                PrintStream ps = new PrintStream(new FileOutputStream(Project.getNatEventFileFromName(Project.getNatEventFileExtension(fileName))));
                ps.print(this.zone.getText());
                ps.close();
                this.zone.setText("");
                this.txtFileName.setText("");
                File scriptFiles = new File(Project.getProjectNatEventPath());
                String[] c = scriptFiles.list();
                this.txtLoadFileName.getItems().removeAll((Collection<?>)this.txtLoadFileName.getItems());
                this.txtLoadFileName.getItems().add("New scenario ...");
                for (int i = 0; i < c.length; ++i) {
                    this.txtLoadFileName.getItems().add(c[i]);
                }
                CupCarbonApp.cupCarbonController.initScriptGpsEventComboBoxes();
                System.out.println("Natural Event File saved.");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.initComboBox();
    }

    public void initComboBox() {
        File scriptFiles = new File(Project.getProjectNatEventPath());
        String[] c = scriptFiles.list();
        this.txtLoadFileName.getItems().removeAll((Collection<?>)this.txtLoadFileName.getItems());
        this.txtLoadFileName.getItems().add("New script ...");
        if (scriptFiles.isDirectory() && c != null) {
            for (int i = 0; i < c.length; ++i) {
                this.txtLoadFileName.getItems().add(c[i]);
            }
        }
    }

    @FXML
    public void generate() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                Random random = new Random();
                NaturalEventGeneratorController.this.zone.setText("time value\n");
                double period = Double.parseDouble(NaturalEventGeneratorController.this.periodField.getText());
                double mean = Double.parseDouble(NaturalEventGeneratorController.this.meanField.getText());
                double std = Double.parseDouble(NaturalEventGeneratorController.this.stdField.getText());
                double v = random.nextGaussian() * std + mean;
                NaturalEventGeneratorController.this.zone.setText("0 " + v + "\n");
                for (int i = 1; i < Integer.parseInt(NaturalEventGeneratorController.this.sizeField.getText()); ++i) {
                    v = random.nextGaussian() * std + mean;
                    NaturalEventGeneratorController.this.zone.setText(NaturalEventGeneratorController.this.zone.getText() + period + " " + v + "\n");
                }
            }
        });
    }
}

