/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon;

import cupcarbon.CupCarbonApp;
import cupcarbon_script.CupCarbonFileNames;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import project.Project;

public class ProgramWindowController
implements Initializable {
    @FXML
    private TextArea zone;
    @FXML
    private ComboBox<String> txtLoadFileName;
    @FXML
    private TextField txtFileName;

    public void loadFile(String fileName) {
        try {
            String line;
            this.zone.clear();
            FileReader fis = new FileReader(fileName);
            BufferedReader br = new BufferedReader(fis);
            Object codeEx = "";
            while ((line = br.readLine()) != null) {
                codeEx = (String)codeEx + line + "\n";
            }
            br.close();
            this.zone.replaceSelection((String)codeEx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    private void pubCB() {
        this.loadFile(CupCarbonFileNames.pub);
    }

    @FXML
    private void subCB() {
        this.loadFile(CupCarbonFileNames.sub);
    }

    @FXML
    private void jspubCB() {
        this.loadFile(CupCarbonFileNames.jspub);
    }

    @FXML
    private void jssubCB() {
        this.loadFile(CupCarbonFileNames.jssub);
    }

    @FXML
    private void jsblink() {
        this.loadFile(CupCarbonFileNames.jsblink);
    }

    @FXML
    private void printhw() {
        this.loadFile(CupCarbonFileNames.printhw);
    }

    @FXML
    private void printhw2() {
        this.loadFile(CupCarbonFileNames.printhw2);
    }

    @FXML
    private void printinfo() {
        this.loadFile(CupCarbonFileNames.printinfo);
    }

    @FXML
    private void move() {
        this.loadFile(CupCarbonFileNames.move);
    }

    @FXML
    private void blink() {
        this.loadFile(CupCarbonFileNames.blink);
    }

    @FXML
    private void jlblink() {
        this.loadFile(CupCarbonFileNames.julia_blink);
    }

    @FXML
    public void load() {
        if (this.txtLoadFileName.getSelectionModel().getSelectedIndex() > 0) {
            this.txtFileName.setText((String)this.txtLoadFileName.getSelectionModel().getSelectedItem());
            this.zone.setText("");
            try {
                FileInputStream in = new FileInputStream(Project.getPythonFileFromName((String)this.txtLoadFileName.getSelectionModel().getSelectedItem()));
                byte[] bytes = new byte[in.available()];
                in.read(bytes);
                this.zone.setText(new String(bytes));
                in.close();
            }
            catch (Exception exception) {}
        } else {
            this.txtFileName.setText("");
            this.zone.setText("");
            this.zone.requestFocus();
        }
    }

    @FXML
    public void save() {
        if (this.txtFileName.getText().split("\\.").length > 1) {
            if (!this.txtFileName.getText().equals("")) {
                try {
                    String fileName = this.txtFileName.getText();
                    fileName = fileName.trim();
                    fileName = fileName.replaceAll(" ", "");
                    PrintStream ps = new PrintStream(new FileOutputStream(Project.getPythonFileFromName(Project.getPythonFileExtension(fileName))));
                    ps.print(this.zone.getText());
                    ps.close();
                    this.zone.setText("");
                    this.txtFileName.setText("");
                    File scriptFiles = new File(Project.getProjectScriptPath());
                    String[] c = scriptFiles.list();
                    this.txtLoadFileName.getItems().removeAll((Collection<?>)this.txtLoadFileName.getItems());
                    this.txtLoadFileName.getItems().add("New scenario ...");
                    for (int i = 0; i < c.length; ++i) {
                        this.txtLoadFileName.getItems().add(c[i]);
                    }
                    CupCarbonApp.cupCarbonController.initScriptGpsEventComboBoxes();
                    CupCarbonApp.cupCarbonController.createContextMenu();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Undefined extension");
            alert.setHeaderText(null);
            alert.setContentText("Add the extension!");
            alert.showAndWait();
        }
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.initComboBox();
        this.zone.clear();
    }

    public void initComboBox() {
        File scriptFiles = new File(Project.getProjectScriptPath());
        String[] c = scriptFiles.list();
        this.txtLoadFileName.getItems().removeAll((Collection<?>)this.txtLoadFileName.getItems());
        this.txtLoadFileName.getItems().add("New script ...");
        if (scriptFiles.isDirectory() && c != null) {
            for (int i = 0; i < c.length; ++i) {
                this.txtLoadFileName.getItems().add(c[i]);
            }
        }
    }
}

