/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import buildings.BuildingList;
import cupcarbon_script.CupCommand;
import cupcarbon_script.CupScript;
import device.DeviceList;
import map.WorldMap;

public class CupCommand_BUILDINGS
extends CupCommand {
    protected String option = "";

    public CupCommand_BUILDINGS(CupScript script, String option) {
        this.script = script;
        this.option = option;
    }

    @Override
    public String execute() {
        currentExecution = false;
        String rep = "";
        String sOption = this.script.getVariableValue(this.option);
        if (isExecuted) {
            switch (sOption) {
                case "load": {
                    BuildingList.loadFromOsm();
                    rep = " 000 The Buildings are have been loaded";
                    currentExecution = true;
                    break;
                }
                case "delete": {
                    DeviceList.deleteAllBuildings();
                    rep = " 000 All Buildings are Deleted";
                    currentExecution = true;
                    break;
                }
                case "select": {
                    WorldMap.setSelectionOfAllBuildings(true, true);
                    rep = " 000 All Buildings are Selected";
                    currentExecution = true;
                    break;
                }
                case "deselect": {
                    WorldMap.setSelectionOfAllBuildings(false, true);
                    rep = " 000 All Buildings are Deselected";
                    currentExecution = true;
                    break;
                }
                default: {
                    rep = "001 [ERROR]";
                    currentExecution = false;
                    break;
                }
            }
        } else {
            rep = "ERROR IN EXECUTING THE PREVIOUS STEP, THE SCRIPT WILL NOT CONTINUE TO EXECUTE";
            this.script.setBreaked(true);
        }
        System.out.println(rep);
        CupScript.slog.println(rep);
        isExecuted = currentExecution;
        return rep;
    }

    @Override
    public String toString() {
        return "BUILDINGS";
    }
}

