/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import buildings.BuildingList;
import cupcarbon_script.CupCommand;
import cupcarbon_script.CupScript;
import device.Device;
import device.DeviceList;
import device.SensorNode;
import map.MapLayer;
import map.NetworkParameters;

public class CupCommand_DISPLAY
extends CupCommand {
    protected String option = "";

    public CupCommand_DISPLAY(CupScript script, String option) {
        this.script = script;
        this.option = option;
    }

    @Override
    public String execute() {
        currentExecution = false;
        String rep = "";
        String sOption = this.script.getVariableValue(this.option);
        if (isExecuted) {
            switch (sOption) {
                case "details": {
                    NetworkParameters.displayDetails = !NetworkParameters.displayDetails;
                    MapLayer.repaint();
                    rep = "000 The Details have been Shown";
                    currentExecution = true;
                    break;
                }
                case "rdistances": {
                    NetworkParameters.displayRLDistance = !NetworkParameters.displayRLDistance;
                    MapLayer.repaint();
                    rep = "000 The Distances have been Shown";
                    currentExecution = true;
                    break;
                }
                case "rmessages": {
                    NetworkParameters.displayRadioMessages = !NetworkParameters.displayRadioMessages;
                    MapLayer.repaint();
                    rep = "000 The Distances have been Shown";
                    currentExecution = true;
                    break;
                }
                case "mdistances": {
                    NetworkParameters.displayMarkerDistance = !NetworkParameters.displayMarkerDistance;
                    MapLayer.repaint();
                    rep = "000 The Distances have been Shown";
                    currentExecution = true;
                    break;
                }
                case "links": {
                    NetworkParameters.drawRadioLinks = !NetworkParameters.drawRadioLinks;
                    MapLayer.repaint();
                    rep = "000 The Links have been Shown";
                    currentExecution = true;
                    break;
                }
                case "narrows": {
                    NetworkParameters.drawSensorArrows = !NetworkParameters.drawSensorArrows;
                    MapLayer.repaint();
                    rep = "000 The Netowrks Arrows have been Shown";
                    currentExecution = true;
                    break;
                }
                case "marrows": {
                    NetworkParameters.drawMarkerArrows = !NetworkParameters.drawMarkerArrows;
                    MapLayer.repaint();
                    rep = "000 The Markes Arrows have been Shown";
                    currentExecution = true;
                    break;
                }
                case "nodes": {
                    for (SensorNode sensorNode : DeviceList.sensors) {
                        sensorNode.setHide(1);
                    }
                    for (Device device : DeviceList.devices) {
                        device.setHide(1);
                    }
                    NetworkParameters.drawRadioLinks = false;
                    MapLayer.repaint();
                    rep = "000 The nodes Only will be Shown";
                    currentExecution = true;
                    break;
                }
                case "buildings": {
                    BuildingList.showHideBuildings();
                    MapLayer.repaint();
                    rep = "000 The Buildings have been Shown";
                    currentExecution = true;
                    break;
                }
                default: {
                    rep = "001 [ERROR]";
                    currentExecution = false;
                    break;
                }
            }
        } else {
            rep = "ERROR IN EXECUTING THE PREVIOUS STEP, THE SCRIPT WILL NOT CONTINUE TO EXECUTE";
            this.script.setBreaked(true);
        }
        System.out.println(rep);
        CupScript.slog.println(rep);
        isExecuted = currentExecution;
        return rep;
    }

    @Override
    public String toString() {
        return "DISPLAY";
    }
}

