/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon_script.CupCommand;
import cupcarbon_script.CupScript;
import device.Device;
import device.DeviceList;
import device.SensorNode;
import java.util.ArrayList;
import java.util.List;

public class CupCommand_DUPLICATE
extends CupCommand {
    protected List<String> objects;
    protected String option = "";

    public CupCommand_DUPLICATE(CupScript script, String option, List<String> objects) {
        this.script = script;
        this.objects = objects;
        this.option = option;
    }

    public CupCommand_DUPLICATE(CupScript script, String option) {
        this.script = script;
        this.option = option;
    }

    @Override
    public String execute() {
        currentExecution = false;
        Object rep = "";
        String sOption = this.script.getVariableValue(this.option);
        ArrayList<String> sObjects = new ArrayList<String>();
        if (this.objects != null) {
            for (int i = 0; i < this.objects.size(); ++i) {
                sObjects.add(this.script.getVariableValue(this.objects.get(i)));
            }
        }
        if (isExecuted) {
            switch (sOption) {
                case "selected": {
                    ArrayList<SensorNode> addedSensors = new ArrayList<SensorNode>();
                    for (SensorNode sensor : DeviceList.sensors) {
                        if (!sensor.isSelected()) continue;
                        addedSensors.add(sensor);
                    }
                    for (SensorNode duplicatedSensor : addedSensors) {
                        DeviceList.add(duplicatedSensor.duplicateWithShift(2.0E-4, 2.0E-4, 0.0));
                    }
                    ArrayList<Device> addedDevices = new ArrayList<Device>();
                    for (Device device : DeviceList.devices) {
                        if (!device.isSelected()) continue;
                        addedDevices.add(device);
                    }
                    for (Device duplicatedDevice : addedDevices) {
                        DeviceList.add(duplicatedDevice.duplicateWithShift(2.0E-4, 2.0E-4, 0.0));
                    }
                    rep = (String)rep + " 000 The Seleted Objects: have been Duplicated";
                    currentExecution = true;
                    break;
                }
                case "devices": {
                    for (int i = 0; i < sObjects.size(); ++i) {
                        if (DeviceList.getNodeByName((String)sObjects.get(i)).getType() == 2 || DeviceList.getNodeByName((String)sObjects.get(i)).getType() == 6) {
                            DeviceList.add(DeviceList.getNodeByName((String)sObjects.get(i)).duplicateWithShift(2.0E-4, 2.0E-4, 0.0));
                        } else {
                            DeviceList.add((SensorNode)DeviceList.getNodeByName((String)sObjects.get(i)).duplicateWithShift(2.0E-4, 2.0E-4, 0.0));
                        }
                        rep = (String)rep + " 000 The Device: " + (String)sObjects.get(i) + " has been Duplicated";
                    }
                    currentExecution = true;
                    break;
                }
                default: {
                    rep = "001 [ERROR] option error: " + sOption;
                    currentExecution = false;
                    break;
                }
            }
        } else {
            rep = "ERROR IN EXECUTING THE PREVIOUS STEP, THE SCRIPT WILL NOT CONTINUE TO EXECUTE";
            this.script.setBreaked(true);
        }
        System.out.println((String)rep);
        CupScript.slog.println((String)rep);
        isExecuted = currentExecution;
        return rep;
    }

    @Override
    public String toString() {
        return "DUPLICATE";
    }
}

