/*
 * Decompiled with CFR 0.152.
 */
package device;

import device.DeviceList;
import device.IoTNode;
import device.SensorNode;
import device.StdSensorNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import map.MapLayer;
import project.Project;

public abstract class IoTNodeCom
extends StdSensorNode {
    String idFL = "IOT";
    String name = "";
    String mmsi = "";
    String imo = "";
    String shipType = "";
    String timeStamp = "";
    String destination = "";
    String speed = "";
    String course = "";

    public IoTNodeCom(double x, double y, double z, double radius, double radioRadius, double suRadius, int id) {
        super(x, y, z, radius, radioRadius, suRadius, id);
    }

    public IoTNodeCom(String id, String x, String y, String z, String radius, String radioRadius, String suRadius, String gpsFileName, String scriptFileName) {
        super(id, x, y, z, radius, radioRadius, suRadius, gpsFileName, scriptFileName);
    }

    @Override
    public String getIdFL() {
        return this.idFL;
    }

    public void setIdFL(String idFL) {
        this.idFL = idFL;
    }

    @Override
    public void save(String ref) {
        String fileName = Project.getProjectNodePath();
        try {
            PrintStream fos = new PrintStream(new FileOutputStream(fileName + File.separator + this.startingName() + "_" + ref));
            fos.println("List of parameters");
            fos.println("------------------------------------------");
            fos.println("device_type:" + this.getType());
            fos.println("device_id:" + this.getId());
            fos.println("device_longitude:" + this.getLongitude());
            fos.println("device_latitude:" + this.getLatitude());
            fos.println("device_elevation:" + this.getElevation());
            fos.println("device_radius:" + this.getRadius());
            fos.println("device_hide:" + this.getHide());
            fos.println("device_draw_battery:" + this.getDrawBatteryLevel());
            fos.println("device_sensor_unit_radius:" + this.getSensorUnitRadius());
            fos.println("device_pic:" + this.getPic());
            if (!this.getGPSFileName().equals("")) {
                fos.println("device_gps_file_name:" + this.getGPSFileName());
            }
            if (!this.getScriptFileName().equals("")) {
                fos.println("device_script_file_name:" + this.getScriptFileName());
            }
            if (!this.name.isEmpty()) {
                fos.println("name:" + this.name);
            }
            if (!this.mmsi.isEmpty()) {
                fos.println("mmsi:" + this.mmsi);
            }
            if (!this.imo.isEmpty()) {
                fos.println("imo:" + this.imo);
            }
            if (!this.speed.isEmpty()) {
                fos.println("speed:" + this.speed);
            }
            if (!this.shipType.isEmpty()) {
                fos.println("shiptype:" + this.shipType);
            }
            if (!this.timeStamp.isEmpty()) {
                fos.println("timeStamp:" + this.timeStamp);
            }
            if (!this.destination.isEmpty()) {
                fos.println("destination:" + this.destination);
            }
            if (!this.course.isEmpty()) {
                fos.println("course:" + this.course);
            }
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.saveRadioModule(Project.getProjectRadioPath() + File.separator + this.startingName() + "_" + ref);
    }

    @Override
    public SensorNode createNewWithTheSameType() {
        return new IoTNode(this.longitude, this.latitude, this.elevation, this.radius, 0.0, this.sensorUnit.getRadius(), DeviceList.number++, 0);
    }

    public int id() {
        return this.id;
    }

    public void addToSenders(final IoTNode node) {
        new Thread(new Runnable(){
            final /* synthetic */ IoTNodeCom this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.senders.add(node);
                MapLayer.repaint();
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.this$0.senders.remove(node);
                MapLayer.repaint();
            }
        }).start();
    }

    @Override
    public String getName() {
        if (this.name.isEmpty()) {
            return this.getIdFL() + this.id;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMmsi() {
        return this.mmsi;
    }

    public void setMmsi(String mmsi) {
        this.mmsi = mmsi;
    }

    public String getImo() {
        return this.imo;
    }

    public void setImo(String imo) {
        this.imo = imo;
    }

    public void setShipType(String shipType) {
        this.shipType = shipType;
    }

    public String getShipType() {
        return this.shipType;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getSpeed() {
        return this.speed;
    }

    public void setSpeed(String speed) {
        this.speed = speed;
    }

    public String getCourse() {
        return this.course;
    }

    public void setCourse(String course) {
        this.course = course;
    }
}

