/*
 * Decompiled with CFR 0.152.
 */
package device;

import device.DeviceList;
import device.StdSensorNode;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.jdesktop.swingx.JXMapViewer;

public class NetworkLoader
extends Thread {
    private JXMapViewer mapViewer;

    public NetworkLoader(JXMapViewer mapViewer) {
        this.mapViewer = mapViewer;
    }

    @Override
    public void run() {
        try {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            FileInputStream fis = new FileInputStream("sensors.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            for (int i = 0; i < 1000; ++i) {
                String[] ps;
                String s = br.readLine();
                String[][] info = new String[7][2];
                info[0][0] = "Sensor Type : ";
                info[1][0] = "";
                info[2][0] = "";
                info[3][0] = "Battery : ";
                info[4][0] = "Name : ";
                info[5][0] = "Date : ";
                info[6][0] = "Time : ";
                info[0][1] = "";
                info[1][1] = "";
                info[2][1] = "";
                info[3][1] = "";
                info[4][1] = "";
                info[5][1] = "";
                info[6][1] = "";
                s = s.substring(1, s.length() - 1);
                for (String cs : ps = s.split(",")) {
                    if (cs.endsWith("}")) {
                        cs = cs.substring(0, cs.length() - 1);
                    }
                    if (cs.startsWith("\"values\":{\"")) {
                        cs = cs.substring(10);
                    }
                    String[] ics = cs.split(":");
                    ics[0] = ics[0].substring(1, ics[0].length() - 1);
                    ics[1] = ics[1].substring(1, ics[1].length() - 1);
                    if (ics[0].equals("Lattitude")) {
                        x = Double.parseDouble(ics[1]);
                    }
                    if (ics[0].equals("Longitude")) {
                        y = Double.parseDouble(ics[1]);
                    }
                    if (ics[0].equals("Elevation")) {
                        z = Double.parseDouble(ics[1]);
                    }
                    if (ics[0].equals("Sensor_Type")) {
                        info[0][1] = ics[1];
                    }
                    if (ics[0].equals("Temperature")) {
                        info[1][0] = "Temperature : ";
                        info[1][1] = ics[1] + " C";
                    }
                    if (ics[0].equals("Status_Desc")) {
                        info[1][0] = "Status Desc : ";
                        info[1][1] = ics[1];
                    }
                    if (ics[0].equals("Co_Index")) {
                        info[2][0] = "CO Index : ";
                        info[2][1] = ics[1];
                    }
                    if (ics[0].equals("Light")) {
                        info[2][0] = "Light : ";
                        info[2][1] = ics[1] + " lux";
                    }
                    if (ics[0].equals("Noise")) {
                        info[2][0] = "Noise : ";
                        info[2][1] = ics[1] + " dB";
                    }
                    if (ics[0].equals("State")) {
                        info[2][0] = "State : ";
                        info[2][1] = ics[1];
                    }
                    if (ics[0].equals("Battery")) {
                        info[3][1] = ics[1] + " %";
                    }
                    if (ics[0].equals("Node")) {
                        info[4][1] = ics[1];
                    }
                    if (ics[0].equals("Date")) {
                        info[5][1] = ics[1];
                    }
                    if (!ics[0].equals("Time")) continue;
                    info[6][1] = ics[1];
                }
                DeviceList.add(new StdSensorNode(x, y, z, 0.0, 30.0, 10.0, info, -1));
                this.mapViewer.repaint();
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

