/*
 * Decompiled with CFR 0.152.
 */
package geo_objects;

import geo_objects.GeoZone;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import math.Angle;
import utilities.Geometry;

public class GeoZoneList {
    private LinkedList<GeoZone> zones = null;
    private double longitude;
    private double latitude;

    public GeoZoneList() {
        this.zones = new LinkedList();
    }

    public GeoZoneList(LinkedList<GeoZone> geoZoneList) {
        this.zones = geoZoneList;
    }

    public void add(GeoZone geoZone) {
        this.zones.add(geoZone);
    }

    public void draw(Graphics g) {
        for (GeoZone geoZone : this.zones) {
            geoZone.draw(g);
        }
    }

    public void init() {
        System.out.println("INIT GZ");
        for (GeoZone geoZone : this.zones) {
            this.delete(geoZone);
        }
        this.zones = new LinkedList();
    }

    public void delete(GeoZone geoZone) {
        geoZone = null;
        this.zones.remove(geoZone);
    }

    public boolean intersect(Polygon p) {
        for (GeoZone geoZone : this.zones) {
            if (!geoZone.intersect(p)) continue;
            return true;
        }
        return false;
    }

    public LinkedList<GeoZone> getGeoZoneList() {
        return this.zones;
    }

    public boolean contains(Point2D p) {
        for (GeoZone geoZone : this.zones) {
            if (!geoZone.contains(p)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(double px, double py) {
        for (GeoZone geoZone : this.zones) {
            if (!geoZone.contains(px, py)) continue;
            return true;
        }
        return false;
    }

    public void reduce(double xref, double yref, double zm) {
        for (GeoZone geo : this.zones) {
            geo.translate(xref, yref, zm);
        }
    }

    public int size() {
        return this.zones.size();
    }

    public boolean isEmpty() {
        return this.zones.size() == 0;
    }

    public void display() {
        for (GeoZone gz : this.zones) {
            gz.display();
            System.out.println();
        }
    }

    public void toOneGeoZone() {
        int n = this.zones.size();
        GeoZone geoc = new GeoZone(n);
        GeoZone geo = new GeoZone(2 * n);
        int idx1 = 0;
        int idx2 = 0;
        for (GeoZone gz : this.zones) {
            int[] v = Geometry.getCentre(gz.getICoordX(1), gz.getICoordY(1), 0, gz.getICoordX(2), gz.getICoordY(2), 0);
            geoc.setInt(v[0], v[1], idx1++);
            geo.setInt(gz.getICoordX(1), gz.getICoordY(1), idx2++);
            geo.setInt(gz.getICoordX(2), gz.getICoordY(2), idx2++);
        }
        geo.setCxCy(this.longitude, this.latitude);
        int x = geo.getCx();
        int y = geo.getCy();
        for (int i = 0; i < geoc.size() - 1; ++i) {
            double a = Angle.getAngle(x - 100, y, x, y, geoc.getICoordX(i), geoc.getICoordY(i));
            for (int j = i + 1; j < geoc.size(); ++j) {
                double na = Angle.getAngle(x - 100, y, x, y, geoc.getICoordX(j), geoc.getICoordY(j));
                if (!(na < a)) continue;
                a = na;
                int s1 = geoc.getICoordX(i);
                int s2 = geoc.getICoordY(i);
                geoc.setICoordX(i, geoc.getICoordX(j));
                geoc.setICoordY(i, geoc.getICoordY(j));
                geoc.setICoordX(j, s1);
                geoc.setICoordY(j, s2);
                s1 = geo.getICoordX(i * 2);
                s2 = geo.getICoordY(i * 2);
                geo.setICoordX(i * 2, geo.getICoordX(j * 2));
                geo.setICoordY(i * 2, geo.getICoordY(j * 2));
                geo.setICoordX(j * 2, s1);
                geo.setICoordY(j * 2, s2);
                s1 = geo.getICoordX(i * 2 + 1);
                s2 = geo.getICoordY(i * 2 + 1);
                geo.setICoordX(i * 2 + 1, geo.getICoordX(j * 2 + 1));
                geo.setICoordY(i * 2 + 1, geo.getICoordY(j * 2 + 1));
                geo.setICoordX(j * 2 + 1, s1);
                geo.setICoordY(j * 2 + 1, s2);
            }
        }
        geo.computeGeoCoords();
        this.zones = new LinkedList();
        this.zones.add(geo);
    }

    public void setSelected(boolean b) {
        for (GeoZone gz : this.zones) {
            gz.setSelected(b);
        }
    }

    public void computeIntCoords() {
        for (GeoZone gz : this.zones) {
            gz.computeIntCoords();
        }
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }
}

