/*
 * Decompiled with CFR 0.152.
 */
package jsonlib;

import java.math.BigDecimal;
import java.math.BigInteger;

class NumberConversionUtil {
    NumberConversionUtil() {
    }

    static Number stringToNumber(String input) throws NumberFormatException {
        char initial;
        Object val = input;
        if (((String)val).startsWith(".")) {
            val = "0" + (String)val;
        }
        if (((String)val).startsWith("-.")) {
            val = "-0." + ((String)val).substring(2);
        }
        if ((initial = ((String)val).charAt(0)) >= '0' && initial <= '9' || initial == '-') {
            BigInteger bi;
            if (NumberConversionUtil.isDecimalNotation((String)val)) {
                try {
                    BigDecimal bd = new BigDecimal((String)val);
                    if (initial == '-' && BigDecimal.ZERO.compareTo(bd) == 0) {
                        return -0.0;
                    }
                    return bd;
                }
                catch (NumberFormatException retryAsDouble) {
                    try {
                        Double d = Double.valueOf((String)val);
                        if (d.isNaN() || d.isInfinite()) {
                            throw new NumberFormatException("val [" + input + "] is not a valid number.");
                        }
                        return d;
                    }
                    catch (NumberFormatException ignore) {
                        throw new NumberFormatException("val [" + input + "] is not a valid number.");
                    }
                }
            }
            val = NumberConversionUtil.removeLeadingZerosOfNumber(input);
            initial = ((String)val).charAt(0);
            if (initial == '0' && ((String)val).length() > 1) {
                at1 = ((String)val).charAt(1);
                if (at1 >= '0' && at1 <= '9') {
                    throw new NumberFormatException("val [" + input + "] is not a valid number.");
                }
            } else if (initial == '-' && ((String)val).length() > 2) {
                at1 = ((String)val).charAt(1);
                char at2 = ((String)val).charAt(2);
                if (at1 == '0' && at2 >= '0' && at2 <= '9') {
                    throw new NumberFormatException("val [" + input + "] is not a valid number.");
                }
            }
            if ((bi = new BigInteger((String)val)).bitLength() <= 31) {
                return bi.intValue();
            }
            if (bi.bitLength() <= 63) {
                return bi.longValue();
            }
            return bi;
        }
        throw new NumberFormatException("val [" + input + "] is not a valid number.");
    }

    static boolean potentialNumber(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return NumberConversionUtil.potentialPositiveNumberStartingAtIndex(value, value.charAt(0) == '-' ? 1 : 0);
    }

    private static boolean isDecimalNotation(String val) {
        return val.indexOf(46) > -1 || val.indexOf(101) > -1 || val.indexOf(69) > -1 || "-0".equals(val);
    }

    private static boolean potentialPositiveNumberStartingAtIndex(String value, int index) {
        if (index >= value.length()) {
            return false;
        }
        return NumberConversionUtil.digitAtIndex(value, value.charAt(index) == '.' ? index + 1 : index);
    }

    private static boolean digitAtIndex(String value, int index) {
        if (index >= value.length()) {
            return false;
        }
        return value.charAt(index) >= '0' && value.charAt(index) <= '9';
    }

    private static String removeLeadingZerosOfNumber(String value) {
        int counter;
        if (value.equals("-")) {
            return value;
        }
        boolean negativeFirstChar = value.charAt(0) == '-';
        int n = counter = negativeFirstChar ? 1 : 0;
        while (counter < value.length()) {
            if (value.charAt(counter) != '0') {
                if (negativeFirstChar) {
                    return "-".concat(value.substring(counter));
                }
                return value.substring(counter);
            }
            ++counter;
        }
        if (negativeFirstChar) {
            return "-0";
        }
        return "0";
    }
}

