/*
 * Decompiled with CFR 0.152.
 */
package map;

import action.CupAction;
import action.CupActionAddBuilding;
import action.CupActionAddDevice;
import action.CupActionAddIoTNode;
import action.CupActionAddMarker;
import action.CupActionAddSensor;
import action.CupActionBlock;
import action.CupActionDeleteBuilding;
import action.CupActionDeleteDevice;
import action.CupActionDeleteMarker;
import action.CupActionDeleteSensor;
import action.CupActionMapObjectMove;
import action.CupActionModifDeviceRadius;
import action.CupActionModifDirectionalSensorUnitCoverage;
import action.CupActionModifDirectionalSensorUnitDirection;
import action.CupActionModifRadioRadius;
import action.CupActionModifSensorRadius;
import action.CupActionModifSensorUnitRadius;
import action.CupActionStack;
import buildings.Building;
import buildings.BuildingList;
import cupcarbon.CupCarbonApp;
import cupcarbon.CupCarbonIcons;
import device.BaseStation;
import device.Device;
import device.DeviceList;
import device.DirectionalSensorNode;
import device.IoTNode;
import device.MessageEventList;
import device.Mobile;
import device.NetworkLoader;
import device.SensorNode;
import device.StdSensorNode;
import geo_objects.GeoZoneList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.swing.ImageIcon;
import map.NetworkParameters;
import map.WorldMap;
import markers.Marker;
import markers.MarkerList;
import markers.Routes;
import natural_events.Gas;
import natural_events.Weather;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.painter.Painter;
import simulation.IoTChannel;
import simulation.Simulation;
import simulation.SimulationInputs;
import simulation.WisenSimulation;
import utilities.MapCalc;
import utilities.UColor;

public class MapLayer
implements Painter<Object>,
MouseListener,
MouseMotionListener,
KeyListener {
    public static HashMap<String, Image> listOfMarkTiles = new HashMap();
    public static JXMapViewer mapViewer = null;
    public static DeviceList nodeList = null;
    public static MarkerList markerList = null;
    public static BuildingList buildingList = null;
    public static GeoZoneList geoZoneList = null;
    public static int mX = 0;
    public static int mY = 0;
    public static char lastKey = '\u0000';
    public static int lastKeyCode = 0;
    public static boolean drawSelectionRectangle = false;
    public static int cadreX1 = 0;
    public static int cadreY1 = 0;
    public static int cadreX2 = 0;
    public static int cadreY2 = 0;
    public static int selectType = 1;
    public static boolean altDown = false;
    public static boolean shiftDown = false;
    public static boolean cmdDown = false;
    public static boolean ctrlDown = false;
    public static boolean mousePressed = false;
    public static String projectPath = "";
    public static String projectName = "";
    public static boolean dark = false;
    public static boolean blockBuildings = false;
    private boolean startSelection = false;
    public static boolean magnetic = false;
    public static int magnetic_step = 16;
    public static boolean multipleSelection = false;
    public static boolean button3Clicked = false;
    public static boolean showInfos = true;
    public static boolean iotSimulation = false;
    public static boolean wsnSimulation = false;
    public static boolean showBakhground = true;
    public static int bg_transparency = 255;
    private int cx;
    private int cy;
    public static int numberOfInsideAndSelected = 0;
    public static Image image_logo = new ImageIcon(CupCarbonIcons.class.getResource("cupcarbon_logo3.png")).getImage();
    public static Image imageLogoBottomRight = new ImageIcon(CupCarbonIcons.class.getResource("cupcarbon_klines_p.png")).getImage();
    public static Image parkingImg = new ImageIcon(CupCarbonIcons.class.getResource("parking.jpg")).getImage();
    public static int fontSize = 10;
    public static Font font = new Font("arial", 0, 10);
    private int expanded = 0;
    private boolean dragging = false;
    public int _cadreX1 = 0;
    public int _cadreY1 = 0;
    public int _cadreX2 = 0;
    public int _cadreY2 = 0;

    public MapLayer() {
    }

    public MapLayer(JXMapViewer mapViewer) {
        MapLayer.mapViewer = mapViewer;
        MapLayer.initLists();
        mapViewer.setOverlayPainter(this);
        mapViewer.addMouseListener(this);
        mapViewer.addMouseMotionListener(this);
        mapViewer.addKeyListener(this);
        MapLayer.repaint();
    }

    public static void initLists() {
        buildingList = new BuildingList();
        geoZoneList = new GeoZoneList();
        markerList = new MarkerList();
        nodeList = new DeviceList();
    }

    public boolean isstartSelection() {
        return this.startSelection;
    }

    public void setstartSelection(boolean startSelection) {
        this.startSelection = startSelection;
    }

    public static void updateFont() {
    }

    public static void setFontSize(int size) {
        fontSize = size;
        font = new Font("arial", 0, size);
    }

    @Override
    public void paint(Graphics2D g, Object arg1, int arg2, int arg3) {
        g.setFont(font);
        Rectangle rect = mapViewer.getViewportBounds();
        g.translate(-rect.x, -rect.y);
        if (showBakhground) {
            g.setColor(new Color(255, 255, 255, bg_transparency));
            g.fillRect((int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 - 20, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 - 20, mapViewer.getWidth() + 40, mapViewer.getHeight() + 40);
        }
        mapViewer.setCursor(new Cursor(0));
        boolean addThing = false;
        if (lastKey == '1') {
            mapViewer.setCursor(new Cursor(12));
            addThing = true;
        }
        if (lastKey == '2') {
            mapViewer.setCursor(new Cursor(12));
            addThing = true;
        }
        if (lastKey == '3') {
            mapViewer.setCursor(new Cursor(12));
            addThing = true;
        }
        if (lastKey == '4') {
            mapViewer.setCursor(new Cursor(12));
            addThing = true;
        }
        if (lastKey == '5') {
            mapViewer.setCursor(new Cursor(12));
            addThing = true;
        }
        if (lastKey == '6') {
            mapViewer.setCursor(new Cursor(12));
            addThing = true;
        }
        if (lastKey == '7') {
            if (DeviceList.weather == null) {
                mapViewer.setCursor(new Cursor(12));
                addThing = true;
            } else {
                lastKey = '\u0000';
            }
        }
        if (lastKey == '8') {
            mapViewer.setCursor(new Cursor(1));
            addThing = true;
        }
        if (lastKey == '9') {
            mapViewer.setCursor(new Cursor(12));
            addThing = true;
        }
        if (lastKey == '&') {
            mapViewer.setCursor(new Cursor(12));
            addThing = true;
        }
        if (magnetic && addThing) {
            g.drawLine(mX - 6, mY, mX + 6, mY);
            g.drawLine(mX, mY - 6, mX, mY + 6);
        }
        if (!shiftDown && !button3Clicked) {
            mapViewer.setPanEnabled(true);
        }
        if (buildingList != null) {
            buildingList.draw(g);
        }
        numberOfInsideAndSelected = 0;
        if (Routes.routes != null && Routes.routes.size() > 0 && NetworkParameters.displayAllRoutes) {
            Routes.draw(g);
        }
        markerList.draw(g);
        nodeList.drawMarkedEdges(g);
        nodeList.draw(g, 0, 0);
        nodeList.drawHulls(g);
        IoTChannel.draw(g);
        if (drawSelectionRectangle) {
            g.setStroke(new BasicStroke(0.5f));
            Point2D p1 = MapCalc.pixelPanelToPixelMap(cadreX1, cadreY1);
            Point2D p2 = MapCalc.pixelPanelToPixelMap(cadreX2, cadreY2);
            g.setColor(UColor.BLACK_TTTTRANSPARENT);
            if (dark) {
                g.setColor(UColor.WHITE_LLTRANSPARENT);
            }
            g.fillRect((int)p1.getX(), (int)p1.getY(), (int)(p2.getX() - p1.getX()), (int)(p2.getY() - p1.getY()));
            g.setColor(Color.LIGHT_GRAY);
            if (dark) {
                g.setColor(UColor.WHITE_LTRANSPARENT);
            }
            g.drawRect((int)p1.getX(), (int)p1.getY(), (int)(p2.getX() - p1.getX()), (int)(p2.getY() - p1.getY()));
        }
        g.setFont(new Font("courier", 1, 10));
        g.setColor(Color.DARK_GRAY);
        if (dark) {
            g.setColor(new Color(198, 232, 106));
        }
        if (Simulation.simulating) {
            g.setColor(Color.RED);
            g.setStroke(new BasicStroke(1.0f));
            g.drawRect((int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 2, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 2, mapViewer.getWidth() - 4, mapViewer.getHeight() - 4);
        }
        if (showInfos && wsnSimulation && !iotSimulation) {
            g.drawString(String.format("Time: %4.4f s", WisenSimulation.sTime), (int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 8, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 16);
            g.drawString("Number of SENT messages:" + MessageEventList.numberOfSentMessages + " [" + MessageEventList.numberOfSentMessages_b + "  Bytes]", (int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 8, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 26);
            g.drawString("Number of RECEIVED messages:" + MessageEventList.numberOfReceivedMessages + " [" + MessageEventList.numberOfReceivedMessages_b + "  Bytes]", (int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 8, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 36);
            g.drawString("Number of SENT & RECEIVED messages:" + (MessageEventList.numberOfSentMessages + MessageEventList.numberOfReceivedMessages) + " [" + (MessageEventList.numberOfReceivedMessages_b + MessageEventList.numberOfSentMessages_b) + "  Bytes]", (int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 8, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 46);
            g.drawString("Number of ACK messages:" + MessageEventList.numberOfAckMessages + " [" + MessageEventList.numberOfAckMessages_b + "  Bytes]", (int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 8, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 56);
            g.drawString("Number of LOST messages:" + MessageEventList.numberOfLostMessages + " [" + MessageEventList.numberOfLostMessages_b + "  Bytes]", (int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 8, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 66);
            if (DeviceList.weather != null) {
                g.drawString("Temperature: " + String.format("%2.2f", DeviceList.weather.getValue()), (int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 8, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 66);
            }
            g.drawString(BuildingList.locked ? "[L]" : "", (int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 8, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 76);
        }
        if (!wsnSimulation) {
            g.drawString(String.format("IoT Simulation running %4.0f s", WisenSimulation.sTime), (int)mapViewer.getCenter().getX() - mapViewer.getWidth() / 2 + 8, (int)mapViewer.getCenter().getY() - mapViewer.getHeight() / 2 + 16);
        }
        g.drawImage(imageLogoBottomRight, (int)mapViewer.getCenter().getX() + mapViewer.getWidth() / 2 - 160, (int)mapViewer.getCenter().getY() + mapViewer.getHeight() / 2 - 50, null);
        g.dispose();
    }

    public static DeviceList getDeviceList() {
        return nodeList;
    }

    public void simulate() {
        nodeList.simulate();
    }

    public void simulateAll() {
        nodeList.simulateAll();
    }

    public void simulateSensors() {
        nodeList.simulateSensors();
    }

    public void simulateMobiles() {
        nodeList.simulateMobiles();
    }

    public static void addAction(CupAction action) {
        CupActionBlock block = new CupActionBlock();
        block.addAction(action);
        CupActionStack.add(block);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        CupAction action;
        if (e.getButton() == 3 && lastKey != '\u0000') {
            DeviceList.deselectAll();
            lastKey = '\u0000';
        }
        Point p = new Point(this.cx, this.cy);
        GeoPosition gp = mapViewer.convertPointToGeoPosition(p);
        if (lastKey == '1') {
            StdSensorNode sn = new StdSensorNode(gp.getLongitude(), gp.getLatitude(), 0.0, 0.0, 100.0, 20.0, -1);
            CupActionAddSensor action2 = new CupActionAddSensor(sn);
            MapLayer.addAction(action2);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        if (lastKey == '2') {
            action = new CupActionAddDevice(new Gas(gp.getLongitude(), gp.getLatitude(), 0.0, 10.0, -1));
            MapLayer.addAction(action);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        if (lastKey == '3') {
            action = new CupActionAddIoTNode(new IoTNode(gp.getLongitude(), gp.getLatitude(), 0.0, 0.0, 100.0, 20.0, -1, 16));
            MapLayer.addAction(action);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        if (lastKey == '4') {
            action = new CupActionAddSensor(new DirectionalSensorNode(gp.getLongitude(), gp.getLatitude(), 0.0, 0.0, 100.0, 60.0, -1, 0.1, 5.0, 12));
            MapLayer.addAction(action);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        if (lastKey == '5') {
            action = new CupActionAddSensor(new BaseStation(gp.getLongitude(), gp.getLatitude(), 0.0, 0.0, 100.0, 20.0, -1));
            MapLayer.addAction(action);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        if (lastKey == '6') {
            action = new CupActionAddDevice(new Mobile(gp.getLongitude(), gp.getLatitude(), 0.0, 8.0, -1));
            MapLayer.addAction(action);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        if (lastKey == '7' && DeviceList.weather == null) {
            action = new CupActionAddDevice(new Weather(gp.getLongitude(), gp.getLatitude(), 0.0, 8.0, -1));
            MapLayer.addAction(action);
            CupActionStack.execute();
            lastKey = '\u0000';
            MapLayer.repaint();
        }
        if (lastKey == '8') {
            action = new CupActionAddMarker(new Marker(gp.getLongitude(), gp.getLatitude(), 0.0, 4.0));
            MapLayer.addAction(action);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        if (lastKey == '9') {
            action = new CupActionAddIoTNode(new IoTNode(gp.getLongitude(), gp.getLatitude(), 0.0, 0.0, 100.0, 20.0, -1, 0));
            MapLayer.addAction(action);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        block0: for (SensorNode sensor : DeviceList.sensors) {
            if (e.getClickCount() == 1 && sensor.isSelected() && Simulation.simulating) {
                if (sensor.isMarked()) {
                    sensor.unmark();
                } else {
                    sensor.mark();
                }
                sensor.setAction();
            }
            if (e.getClickCount() != 2) continue;
            MarkerList.insertMarkers();
            if (sensor.isSelected() && !Simulation.simulating) {
                if (this.expanded == 2) {
                    this.expanded = 0;
                }
                if (this.expanded == 1) {
                    ++this.expanded;
                    CupCarbonApp.cupCarbonController.radioParamPane.setExpanded(true);
                    break;
                }
                if (this.expanded == 0) {
                    ++this.expanded;
                    CupCarbonApp.cupCarbonController.deviceParamPane.setExpanded(true);
                    break;
                }
            }
            for (Device device : DeviceList.devices) {
                if (!device.isSelected()) continue;
                if (this.expanded == 2) {
                    this.expanded = 0;
                }
                if (this.expanded == 1) {
                    ++this.expanded;
                    CupCarbonApp.cupCarbonController.deviceParamPane.setExpanded(true);
                    continue block0;
                }
                if (this.expanded != 0) continue;
                ++this.expanded;
                CupCarbonApp.cupCarbonController.deviceParamPane.setExpanded(true);
                continue block0;
            }
        }
        if (CupCarbonApp.cupCarbonController != null) {
            CupCarbonApp.cupCarbonController.updateObjectListView();
            CupCarbonApp.cupCarbonController.getNodeInformations();
            CupCarbonApp.cupCarbonController.getRadioInformations();
            CupCarbonApp.cupCarbonController.updateSelectionInListView();
        }
    }

    public static void addMarker(int index, Marker marker) {
        MarkerList.add(index, marker);
        MapLayer.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        mousePressed = true;
        if (shiftDown || e.getButton() == 3) {
            button3Clicked = true;
            mapViewer.setPanEnabled(false);
            this.startSelection = true;
            this._cadreX1 = e.getX();
            this._cadreY1 = e.getY();
        } else {
            int nbSelected = 0;
            for (SensorNode sensor : DeviceList.sensors) {
                if (!e.isControlDown() && numberOfInsideAndSelected == 0) {
                    sensor.setSelected(false);
                }
                if (e.getButton() != 1 || !sensor.isInside()) continue;
                if (e.isControlDown()) {
                    sensor.setSelected(!sensor.isSelected());
                    continue;
                }
                if (numberOfInsideAndSelected != 0 || nbSelected != 0) continue;
                sensor.setSelected(true);
                ++nbSelected;
            }
            for (Device device : DeviceList.devices) {
                if (!e.isControlDown() && numberOfInsideAndSelected == 0) {
                    device.setSelected(false);
                }
                if (e.getButton() != 1 || !device.isInside()) continue;
                if (e.isControlDown()) {
                    device.setSelected(!device.isSelected());
                    continue;
                }
                if (numberOfInsideAndSelected != 0 || nbSelected != 0) continue;
                device.setSelected(true);
                ++nbSelected;
            }
            for (Marker marker : MarkerList.markers) {
                if (!e.isControlDown() && numberOfInsideAndSelected == 0) {
                    marker.setSelected(false);
                }
                if (e.getButton() != 1 || !marker.isInside()) continue;
                if (e.isControlDown()) {
                    marker.setSelected(!marker.isSelected());
                    continue;
                }
                if (numberOfInsideAndSelected != 0 || nbSelected != 0) continue;
                marker.setSelected(true);
                ++nbSelected;
            }
            MapLayer.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.cx = e.getX();
        this.cy = e.getY();
        if (magnetic) {
            this.cx = this.cx - this.cx % magnetic_step - MapLayer.mapViewer.getViewportBounds().x % magnetic_step;
            this.cy = this.cy - this.cy % magnetic_step - MapLayer.mapViewer.getViewportBounds().y % magnetic_step;
        }
        if (magnetic) {
            Point2D pd = MapCalc.pixelPanelToPixelMap(this.cx, this.cy);
            mX = (int)pd.getX();
            mY = (int)pd.getY();
            MapLayer.repaint();
        }
        this.movingSensors(e.getX(), e.getY());
    }

    public void movingSensors(int x, int y) {
        boolean tmp_inside;
        boolean selection = false;
        for (SensorNode sensor : DeviceList.sensors) {
            sensor.calculateDxDy(this.cx, this.cy);
            tmp_inside = sensor.isInside();
            sensor.inside(x, y);
            if (sensor.isInside() == tmp_inside) continue;
            selection = true;
            MapLayer.repaint();
        }
        for (Device device : DeviceList.devices) {
            device.calculateDxDy(this.cx, this.cy);
            tmp_inside = device.isInside();
            device.inside(x, y);
            if (device.isInside() == tmp_inside) continue;
            selection = true;
            MapLayer.repaint();
        }
        for (Marker marker : MarkerList.markers) {
            marker.calculateDxDy(this.cx, this.cy);
            tmp_inside = marker.isInside();
            marker.inside(x, y);
            if (marker.isInside() == tmp_inside) continue;
            selection = true;
            MapLayer.repaint();
        }
        if (selection && CupCarbonApp.cupCarbonController != null) {
            CupCarbonApp.cupCarbonController.updateObjectListView();
            CupCarbonApp.cupCarbonController.getNodeInformations();
            CupCarbonApp.cupCarbonController.getRadioInformations();
            CupCarbonApp.cupCarbonController.updateSelectionInListView();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (shiftDown || e.getButton() == 3) {
            this._cadreX2 = e.getX();
            this._cadreY2 = e.getY();
            int mx1 = Math.min(this._cadreX1, this._cadreX2);
            int my1 = Math.min(this._cadreY1, this._cadreY2);
            int mx2 = Math.max(this._cadreX1, this._cadreX2);
            int my2 = Math.max(this._cadreY1, this._cadreY2);
            cadreX1 = mx1;
            cadreY1 = my1;
            cadreX2 = mx2;
            cadreY2 = my2;
            drawSelectionRectangle = true;
            MapLayer.repaint();
        } else if (e.getButton() == 1) {
            for (SensorNode sensor : DeviceList.sensors) {
                if (!sensor.isSelected()) continue;
                if (!this.dragging) {
                    sensor.calculateDxDy(e.getX(), e.getY());
                    sensor.setPrevLongitude(sensor.getLongitude());
                    sensor.setPrevLatitude(sensor.getLatitude());
                }
                this.cx = e.getX();
                this.cy = e.getY();
                if (Simulation.simulating) continue;
                sensor.moveTo(this.cx, this.cy, 0);
            }
            for (Device device : DeviceList.devices) {
                if (!device.isSelected()) continue;
                if (!this.dragging) {
                    device.calculateDxDy(e.getX(), e.getY());
                    device.setPrevLongitude(device.getLongitude());
                    device.setPrevLatitude(device.getLatitude());
                }
                this.cx = e.getX();
                this.cy = e.getY();
                device.moveTo(this.cx, this.cy, 0);
            }
            for (Marker marker : MarkerList.markers) {
                if (!marker.isSelected()) continue;
                if (!this.dragging) {
                    marker.calculateDxDy(e.getX(), e.getY());
                    marker.setPrevLongitude(marker.getLongitude());
                    marker.setPrevLatitude(marker.getLatitude());
                }
                this.cx = e.getX();
                this.cy = e.getY();
                marker.moveTo(this.cx, this.cy, 0);
            }
            this.dragging = true;
            if (DeviceList.propagationsCalculated) {
                DeviceList.calculatePropagations();
            }
        }
    }

    public void addActionAfterMoving() {
        if (this.dragging) {
            CupActionMapObjectMove action;
            if (CupCarbonApp.cupCarbonController != null) {
                CupCarbonApp.cupCarbonController.updateObjectListView();
                CupCarbonApp.cupCarbonController.getNodeInformations();
                CupCarbonApp.cupCarbonController.getRadioInformations();
                CupCarbonApp.cupCarbonController.updateSelectionInListView();
            }
            this.dragging = false;
            CupActionBlock block = new CupActionBlock();
            for (SensorNode sensor : DeviceList.sensors) {
                if (!sensor.isSelected()) continue;
                action = new CupActionMapObjectMove(sensor);
                block.addAction(action);
            }
            for (Device device : DeviceList.devices) {
                if (!device.isSelected()) continue;
                action = new CupActionMapObjectMove(device);
                block.addAction(action);
            }
            for (Marker marker : MarkerList.markers) {
                if (!marker.isSelected()) continue;
                action = new CupActionMapObjectMove(marker);
                block.addAction(action);
            }
            if (block.size() > 0) {
                CupActionStack.add(block);
                CupActionStack.execute();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.addActionAfterMoving();
        if (shiftDown || mousePressed && e.getButton() == 3) {
            mapViewer.setPanEnabled(true);
            button3Clicked = false;
            mousePressed = false;
            lastKeyCode = 0;
            this.startSelection = false;
            multipleSelection = true;
            if (drawSelectionRectangle) {
                nodeList.selectInsideRectangle(cadreX1, cadreY1, cadreX2, cadreY2);
                markerList.selectInsideRectangle(cadreX1, cadreY1, cadreX2, cadreY2);
                buildingList.selectInsideRectangle(cadreX1, cadreY1, cadreX2, cadreY2);
            }
            drawSelectionRectangle = false;
            MapLayer.repaint();
        }
        mousePressed = false;
    }

    public static boolean insideSelection(double x, double y, int cadreX1, int cadreY1, int cadreX2, int cadreY2) {
        GeoPosition gp1 = mapViewer.convertPointToGeoPosition(new Point(cadreX1, cadreY1));
        GeoPosition gp2 = mapViewer.convertPointToGeoPosition(new Point(cadreX2, cadreY2));
        return y < gp1.getLatitude() && x > gp1.getLongitude() && y > gp2.getLatitude() && x < gp2.getLongitude();
    }

    public void deleteIfSelected() {
        boolean exist = false;
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            exist = true;
            CupActionDeleteSensor action = new CupActionDeleteSensor(sensor);
            block.addAction(action);
        }
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            exist = true;
            CupActionDeleteDevice action = new CupActionDeleteDevice(device);
            block.addAction(action);
        }
        int index = 0;
        for (Marker marker : MarkerList.markers) {
            if (marker.isSelected()) {
                CupActionDeleteMarker action = new CupActionDeleteMarker(marker, index);
                block.addAction(action);
            }
            ++index;
        }
        for (Building building : BuildingList.buildings) {
            if (!building.isSelected() || building.isHide()) continue;
            CupActionDeleteBuilding action = new CupActionDeleteBuilding(building);
            block.addAction(action);
        }
        if (block.size() > 0) {
            CupActionStack.add(block);
            CupActionStack.execute();
        }
        if (exist) {
            DeviceList.initMarkedEdges();
        }
    }

    @Override
    public void keyPressed(KeyEvent key) {
        ctrlDown = key.isControlDown();
        cmdDown = key.isMetaDown();
        shiftDown = key.isShiftDown();
        altDown = key.isAltDown();
        lastKeyCode = key.getKeyCode();
        if (key.getKeyCode() == 68 && altDown) {
            boolean bl = showInfos = !showInfos;
        }
        if (key.getKeyCode() == 70 && altDown) {
            boolean bl = showBakhground = !showBakhground;
        }
        if (!(key.getKeyChar() != 'a' || ctrlDown || cmdDown || shiftDown || altDown)) {
            boolean bl = NetworkParameters.drawSensorArrows = !NetworkParameters.drawSensorArrows;
        }
        if (!(key.getKeyChar() != 'A' || ctrlDown || cmdDown || altDown)) {
            boolean bl = NetworkParameters.drawMarkerArrows = !NetworkParameters.drawMarkerArrows;
        }
        if (key.getKeyChar() == ' ') {
            CupCarbonApp.cupCarbonController.splitPaneShowHide();
        }
        if (key.getKeyCode() == 8 || key.getKeyCode() == 127) {
            this.deleteIfSelected();
            if (CupCarbonApp.cupCarbonController != null) {
                CupCarbonApp.cupCarbonController.updateObjectListView();
                CupCarbonApp.cupCarbonController.updateSelectionInListView();
            }
        }
        if (key.getKeyChar() == '\u0082') {
            boolean bl = NetworkParameters.drawSensorArrows = !NetworkParameters.drawSensorArrows;
        }
        if (key.getKeyChar() == 'd') {
            boolean bl = NetworkParameters.displayDetails = !NetworkParameters.displayDetails;
        }
        if (key.getKeyChar() == 'D') {
            boolean bl = NetworkParameters.displayPrintMessage = !NetworkParameters.displayPrintMessage;
        }
        if (key.getKeyChar() == 'R') {
            boolean bl = NetworkParameters.displayAllRoutes = !NetworkParameters.displayAllRoutes;
        }
        if (key.getKeyChar() == 'm') {
            boolean bl = NetworkParameters.displayRadioMessages = !NetworkParameters.displayRadioMessages;
        }
        if (key.getKeyCode() == 27) {
            this.addActionAfterMoving();
            for (SensorNode sensor : DeviceList.sensors) {
                sensor.initSelection();
            }
            for (Device device : DeviceList.devices) {
                device.initSelection();
            }
            for (Marker marker : MarkerList.markers) {
                marker.initSelection();
            }
            if (CupCarbonApp.cupCarbonController != null) {
                CupCarbonApp.cupCarbonController.updateObjectListView();
                CupCarbonApp.cupCarbonController.updateSelectionInListView();
            }
            lastKey = '\u0000';
        }
        MapLayer.repaint();
    }

    public static void escape() {
        mapViewer.setCursor(new Cursor(0));
        lastKey = '\u0000';
        MapLayer.repaint();
    }

    @Override
    public void keyReleased(KeyEvent key) {
        if (shiftDown && mousePressed) {
            drawSelectionRectangle = false;
            nodeList.selectInsideRectangle(cadreX1, cadreX2, cadreY1, cadreY2);
            markerList.selectInsideRectangle(cadreX1, cadreX2, cadreY1, cadreY2);
            buildingList.selectInsideRectangle(cadreX1, cadreY1, cadreX2, cadreY2);
            MapLayer.repaint();
        }
        altDown = false;
        shiftDown = false;
        ctrlDown = false;
        cmdDown = false;
    }

    public static void duplicate() {
        CupAction action;
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (!sensor.isSelected()) continue;
            action = magnetic ? new CupActionAddSensor(sensor.duplicate()) : new CupActionAddSensor(sensor.duplicateWithShift(2.0E-4, 2.0E-4, 0.0));
            block.addAction(action);
        }
        for (Device device : DeviceList.devices) {
            if (!device.isSelected()) continue;
            action = magnetic ? new CupActionAddDevice(device.duplicate()) : new CupActionAddDevice(device.duplicateWithShift(2.0E-4, 2.0E-4, 0.0));
            block.addAction(action);
        }
        if (block.size() > 0) {
            CupActionStack.add(block);
            CupActionStack.execute();
        }
    }

    public void keyTypedForDevices(KeyEvent key) {
        CupActionBlock block = new CupActionBlock();
        for (Device device : DeviceList.devices) {
            if (device.isSelected()) {
                CupAction action;
                if (key.getKeyChar() == 'h') {
                    device.incHide();
                }
                if (key.getKeyChar() == 'j') {
                    device.incPic();
                }
                if (key.getKeyChar() == 'J') {
                    device.decPic();
                }
                if (key.getKeyChar() == ';') {
                    action = new CupActionModifDeviceRadius(device, device.getRadius(), device.getRadius() + 5.0);
                    block.addAction(action);
                }
                if (key.getKeyChar() == ',' && device.getRadius() > 0.0) {
                    action = new CupActionModifDeviceRadius(device, device.getRadius(), device.getRadius() - 5.0);
                    block.addAction(action);
                }
                if (key.getKeyChar() == 'c' && !mousePressed) {
                    action = magnetic ? new CupActionAddDevice(device.duplicate()) : new CupActionAddDevice(device.duplicateWithShift(2.0E-4, 2.0E-4, 0.0));
                    block.addAction(action);
                }
                if (key.getKeyChar() == 'S') {
                    device.agentSimulation();
                }
            }
            if (key.getKeyChar() == 'q') {
                device.stopAgentSimulation();
            }
            if (key.getKeyChar() == 'i') {
                device.invSelection();
            }
            if (key.getKeyChar() != '1' && key.getKeyChar() != '2' && key.getKeyChar() != '3' && key.getKeyChar() != '4' && key.getKeyChar() != '5' && key.getKeyChar() != '6' && key.getKeyChar() != '7' && key.getKeyChar() != '8') continue;
            device.setSelected(false);
        }
        if (block.size() > 0) {
            CupActionStack.add(block);
            CupActionStack.execute();
        }
    }

    public void keyTypedForSensors(KeyEvent key) {
        CupActionBlock block = new CupActionBlock();
        for (SensorNode sensor : DeviceList.sensors) {
            if (sensor.isSelected()) {
                CupAction action;
                double v;
                CupActionModifSensorUnitRadius action2;
                int d;
                if (key.getKeyChar() == '(' || key.getKeyChar() == '[') {
                    d = 5;
                    if (key.getKeyChar() == '[') {
                        d = 1;
                    }
                    action2 = new CupActionModifSensorUnitRadius(sensor, sensor.getSensorUnitRadius(), sensor.getSensorUnitRadius() - (double)d);
                    block.addAction(action2);
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.getSensorInformations();
                    }
                }
                if (key.getKeyChar() == ')' || key.getKeyChar() == ']') {
                    d = 5;
                    if (key.getKeyChar() == ']') {
                        d = 1;
                    }
                    action2 = new CupActionModifSensorUnitRadius(sensor, sensor.getSensorUnitRadius(), sensor.getSensorUnitRadius() + (double)d);
                    block.addAction(action2);
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.getSensorInformations();
                    }
                }
                if ((key.getKeyChar() == '\u03c0' || key.getKeyChar() == 'p') && sensor.getType() == 5) {
                    double d2 = 0.1;
                    if (key.getKeyChar() == '\u03c0') {
                        d2 = 0.01;
                    }
                    if ((v = ((DirectionalSensorNode)sensor).getSensorUnitDirection() + d2) > 6.28) {
                        v = 0.0;
                    }
                    action = new CupActionModifDirectionalSensorUnitDirection(sensor, ((DirectionalSensorNode)sensor).getSensorUnitDirection(), v);
                    block.addAction(action);
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.getSensorInformations();
                    }
                }
                if ((key.getKeyChar() == '\u0153' || key.getKeyChar() == 'o') && sensor.getType() == 5) {
                    double d3 = 0.1;
                    if (key.getKeyChar() == '\u0153') {
                        d3 = 0.01;
                    }
                    if ((v = ((DirectionalSensorNode)sensor).getSensorUnitDirection() - d3) < 0.0) {
                        v = 6.28;
                    }
                    action = new CupActionModifDirectionalSensorUnitDirection(sensor, ((DirectionalSensorNode)sensor).getSensorUnitDirection(), v);
                    block.addAction(action);
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.getSensorInformations();
                    }
                }
                if ((key.getKeyChar() == '\u220f' || key.getKeyChar() == 'P') && sensor.getType() == 5) {
                    double d4 = 0.01;
                    if (key.getKeyChar() == '\u220f') {
                        d4 = 0.001;
                    }
                    if ((v = ((DirectionalSensorNode)sensor).getSensorUnitCoverage() + d4) > 0.628) {
                        v = 0.628;
                    }
                    action = new CupActionModifDirectionalSensorUnitCoverage(sensor, ((DirectionalSensorNode)sensor).getSensorUnitCoverage(), v);
                    block.addAction(action);
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.getSensorInformations();
                    }
                }
                if ((key.getKeyChar() == '\u0152' || key.getKeyChar() == 'O') && sensor.getType() == 5) {
                    double d5 = 0.01;
                    if (key.getKeyChar() == '\u0152') {
                        d5 = 0.001;
                    }
                    if ((v = ((DirectionalSensorNode)sensor).getSensorUnitCoverage() - d5) < 0.0) {
                        v = 0.0;
                    }
                    action = new CupActionModifDirectionalSensorUnitCoverage(sensor, ((DirectionalSensorNode)sensor).getSensorUnitCoverage(), v);
                    block.addAction(action);
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.getSensorInformations();
                    }
                }
                if (key.getKeyChar() == 'h') {
                    sensor.incHide();
                }
                if (key.getKeyChar() == 'j') {
                    sensor.incPic();
                }
                if (key.getKeyChar() == 'J') {
                    sensor.decPic();
                }
                if (key.getKeyChar() == ';') {
                    CupActionModifSensorRadius action3 = new CupActionModifSensorRadius(sensor, sensor.getRadius(), sensor.getRadius() + 5.0);
                    block.addAction(action3);
                }
                if (key.getKeyChar() == ',' && sensor.getRadius() > 0.0) {
                    CupActionModifSensorRadius action4 = new CupActionModifSensorRadius(sensor, sensor.getRadius(), sensor.getRadius() - 5.0);
                    block.addAction(action4);
                }
                if (key.getKeyChar() == 'c' && !mousePressed) {
                    CupActionAddSensor action5 = magnetic ? new CupActionAddSensor(sensor.duplicate()) : new CupActionAddSensor(sensor.duplicateWithShift(2.0E-4, 2.0E-4, 0.0));
                    block.addAction(action5);
                }
                if (key.getKeyChar() == 'b') {
                    sensor.invertDrawBatteryLevel();
                }
                if (key.getKeyChar() == 'B') {
                    boolean bl = blockBuildings = !blockBuildings;
                }
                if (key.getKeyChar() == 'k') {
                    if (sensor.getBatteryLevel() > 0.0) {
                        sensor.setBatteryLevel(0.0);
                    } else {
                        sensor.initBattery();
                    }
                }
                if (key.getKeyChar() == '+') {
                    CupActionModifRadioRadius action6 = new CupActionModifRadioRadius(sensor.getCurrentRadioModule(), sensor.getCurrentRadioModule().getRadioRangeRadius(), sensor.getCurrentRadioModule().getRadioRangeRadius() + 1.0);
                    block.addAction(action6);
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.getRadioInformations();
                    }
                }
                if (key.getKeyChar() == '-' && sensor.getCurrentRadioModule().getRadioRangeRadius() > 0.0) {
                    CupActionModifRadioRadius action7 = new CupActionModifRadioRadius(sensor.getCurrentRadioModule(), sensor.getCurrentRadioModule().getRadioRangeRadius(), sensor.getCurrentRadioModule().getRadioRangeRadius() - 1.0);
                    block.addAction(action7);
                    if (CupCarbonApp.cupCarbonController != null) {
                        CupCarbonApp.cupCarbonController.getRadioInformations();
                    }
                }
                if (key.getKeyChar() == 'S') {
                    sensor.agentSimulation();
                }
                if (key.getKeyChar() == 'e') {
                    sensor.setDisplaydRadius(!sensor.getDisplaydRadius());
                }
                if (key.getKeyChar() == 'r') {
                    sensor.setDisplaydInfos(!sensor.getDisplaydInfos());
                }
                if (key.getKeyChar() == '1' || key.getKeyChar() == '2' || key.getKeyChar() == '3' || key.getKeyChar() == '4' || key.getKeyChar() == '5' || key.getKeyChar() == '6' || key.getKeyChar() == '7' || key.getKeyChar() == '8') {
                    sensor.setSelected(false);
                }
            }
            if (key.getKeyChar() == 'i') {
                sensor.invSelection();
            }
            if (key.getKeyChar() != 'q') continue;
            sensor.stopAgentSimulation();
        }
        if (block.size() > 0) {
            CupActionStack.add(block);
            CupActionStack.execute();
        }
    }

    public void keyTypedForMarkers(KeyEvent key) {
        for (Marker marker : MarkerList.markers) {
            if (key.getKeyChar() == 'i') {
                marker.invSelection();
            }
            if (!marker.isSelected() || key.getKeyChar() != '1' && key.getKeyChar() != '2' && key.getKeyChar() != '3' && key.getKeyChar() != '4' && key.getKeyChar() != '5' && key.getKeyChar() != '6' && key.getKeyChar() != '7' && key.getKeyChar() != '8') continue;
            marker.setSelected(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent key) {
        boolean selected;
        lastKey = key.getKeyChar();
        if (lastKey == 'n') {
            boolean bl = NetworkParameters.drawScriptFileName = !NetworkParameters.drawScriptFileName;
        }
        if (lastKey == 'l') {
            boolean bl = NetworkParameters.drawRadioLinks = !NetworkParameters.drawRadioLinks;
        }
        if (lastKey == 'L') {
            boolean bl = BuildingList.locked = !BuildingList.locked;
        }
        if (lastKey == 'v' || lastKey == 'V') {
            MapLayer.nextLinkColor(lastKey);
        }
        if (lastKey == '\u00c6') {
            boolean bl = NetworkParameters.drawMarkerArrows = !NetworkParameters.drawMarkerArrows;
        }
        if (lastKey == 'w') {
            MapLayer.selectNodesMarkers();
        }
        if (lastKey == '>') {
            Device.moveSpeed += 5;
        }
        if (lastKey == '<' && (Device.moveSpeed -= 5) < 0) {
            Device.moveSpeed = 0;
        }
        if (lastKey == 'f') {
            DeviceList.selectOneFromSelected();
        }
        if (key.getKeyChar() == 'x') {
            boolean bl = NetworkParameters.displayRLDistance = !NetworkParameters.displayRLDistance;
        }
        if (key.getKeyChar() == 'X') {
            boolean bl = NetworkParameters.displayMarkerDistance = !NetworkParameters.displayMarkerDistance;
        }
        if (key.getKeyChar() == 't' && !(selected = MarkerList.transformMarkersToSensors())) {
            MapLayer.setFontSize(fontSize + 1);
        }
        if (key.getKeyChar() == 'T' && !(selected = MarkerList.transformMarkersToSensors())) {
            MapLayer.setFontSize(fontSize - 1);
        }
        if (key.getKeyChar() == 'u') {
            MarkerList.insertMarkers();
        }
        if (key.getKeyChar() == 'U') {
            MarkerList.selectNextMarkers();
        }
        if (key.getKeyChar() == ':') {
            int n = MarkerList.size();
            Building building = new Building(n);
            for (int i = 0; i < n; ++i) {
                building.set(MarkerList.get(i).getLongitude(), MarkerList.get(i).getLatitude(), i);
            }
            mapViewer.addMouseListener(building);
            mapViewer.addKeyListener(building);
            CupActionAddBuilding action = new CupActionAddBuilding(building);
            CupActionBlock block = new CupActionBlock();
            block.addAction(action);
            CupActionStack.add(block);
            CupActionStack.execute();
            MarkerList.selectAll();
        }
        this.keyTypedForSensors(key);
        this.keyTypedForDevices(key);
        this.keyTypedForMarkers(key);
        if (DeviceList.propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
        MapLayer.repaint();
    }

    public static void selectNodesMarkers() {
        if (selectType == 0) {
            numberOfInsideAndSelected = 0;
            selectType = 1;
            DeviceList.deselectAll();
            MarkerList.deselectAll();
        } else {
            if (selectType == 8) {
                selectType = 0;
                DeviceList.deselectAll();
                MarkerList.deselectAll();
                WorldMap.setSelectionOfAllMarkers(true, false);
                numberOfInsideAndSelected = MarkerList.markers.size();
            }
            if (selectType == 1) {
                selectType = 8;
                WorldMap.setSelectionOfAllNodes(true, 1, false);
                WorldMap.setSelectionOfAllNodes(true, 13, true);
                numberOfInsideAndSelected = DeviceList.sensors.size();
            }
        }
    }

    public static void nextLinkColor(char c) {
        if (c == 'v') {
            ++NetworkParameters.radioLinksColor;
        }
        if (c == 'V') {
            --NetworkParameters.radioLinksColor;
        }
        if (NetworkParameters.radioLinksColor > 5) {
            NetworkParameters.radioLinksColor = 0;
        }
        if (NetworkParameters.radioLinksColor < 0) {
            NetworkParameters.radioLinksColor = 5;
        }
    }

    public void addNodeInMap(char c) {
        lastKey = c;
        MapLayer.repaint();
    }

    public void loadCityNodes() {
        NetworkLoader nl = new NetworkLoader(mapViewer);
        nl.start();
    }

    public void setSelectionOfAllNodes(boolean selection, int type, boolean addSelection) {
        nodeList.setSelectionOfAllNodes(selection, type, addSelection);
    }

    public void setSelectionOfAllMobileNodes(boolean selection, int type, boolean addSelection) {
        nodeList.setSelectionOfAllMobileNodes(selection, type, addSelection);
    }

    public void invertSelection() {
        nodeList.invertSelection();
    }

    public void setSelectionOfAllMarkers(boolean selection, boolean addSelection) {
        markerList.setSelectionOfAllMarkers(selection, addSelection);
    }

    public void setSelectionOfAllBuildings(boolean selection, boolean addSelection) {
        buildingList.setSelectionOfAllBuildings(selection, selection);
    }

    public static void repaint() {
        if (mapViewer != null) {
            mapViewer.repaint();
        }
    }

    public static void drawDistance(double longitude1, double latitude1, double elevation1, double longitude2, double latitude2, double elevation2, Graphics g) {
        int[] coord = MapCalc.geoToPixelMapA(latitude1, longitude1);
        int lx1 = coord[0];
        int ly1 = coord[1];
        coord = MapCalc.geoToPixelMapA(latitude2, longitude2);
        int lx2 = coord[0];
        int ly2 = coord[1];
        g.setColor(new Color(103, 103, 103));
        if (dark) {
            g.setColor(Color.LIGHT_GRAY);
        }
        int d = (int)MapLayer.distance(longitude1, latitude1, longitude2, latitude2);
        g.drawString("" + d, (lx1 + lx2) / 2, (ly1 + ly2) / 2 + 10);
    }

    public static void drawMessage(int lx1, int lx2, int ly1, int ly2, String message, Graphics g) {
        g.setColor(Color.BLACK);
        if (dark) {
            g.setColor(new Color(243, 210, 29));
        }
        g.drawString(message, (lx1 + lx2) / 2, (ly1 + ly2) / 2 - 10);
    }

    public static void drawMessageAttempts(int lx1, int lx2, int ly1, int ly2, String message, Graphics g) {
        if (SimulationInputs.ack) {
            g.setColor(Color.BLACK);
            if (dark) {
                g.setColor(Color.YELLOW);
            }
            g.drawString("[" + message + "]", (lx1 + lx2) / 2 - 15, (ly1 + ly2) / 2 - 10);
        }
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return MapCalc.distance(x1, y1, x2, y2);
    }
}

