/*
 * Decompiled with CFR 0.152.
 */
package markers;

import action.CupActionAddSensor;
import action.CupActionBlock;
import action.CupActionDeleteMarker;
import action.CupActionInsertMarker;
import action.CupActionRouteFromMarkers;
import action.CupActionStack;
import cupcarbon.CupCarbonApp;
import device.DeviceList;
import device.IoTNode;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import jsonlib.JSONArray;
import jsonlib.JSONObject;
import map.MapLayer;
import map.NetworkParameters;
import markers.Marker;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import project.Project;
import solver.SolverProxyParams;
import utilities.MapCalc;
import utilities.UColor;

public class MarkerList {
    public static LinkedList<Marker> markers;
    public static int totalDistance;
    public static int totalDuration;

    public MarkerList() {
        markers = new LinkedList();
    }

    public static void reset() {
        if (markers != null) {
            markers.removeAll(markers);
        }
    }

    public static void save(String fileName) {
        try {
            PrintStream fos = new PrintStream(new FileOutputStream(fileName));
            fos.println("# CupCarbon v.Klines 7.2 (2025)");
            fos.println("# Markers");
            fos.println("# -----------------------");
            fos.println("# -----------------------");
            fos.println("# -----------------------");
            for (Marker marker : markers) {
                fos.print("00:00:00");
                fos.print(" " + marker.getLongitude());
                fos.print(" " + marker.getLatitude());
                fos.print(" " + marker.getElevation());
                fos.print(" " + marker.getRadius());
                fos.println();
            }
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void open(String fileName) {
        MarkerList.reset();
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] str = line.split(" ");
                MarkerList.addNodeByType(str[1], str[2], str[3], str[4]);
            }
            br.close();
            MapLayer.repaint();
        }
        catch (FileNotFoundException e) {
            System.out.println("[MarkerList] No Markers!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addNodeByType(String ... type) {
        MarkerList.add(new Marker(type[0], type[1], type[2], type[3]));
    }

    public static void add(Marker marker) {
        markers.add(marker);
    }

    public static void add(int index, Marker marker) {
        markers.add(index, marker);
    }

    public void draw(Graphics g2) {
        totalDistance = 0;
        totalDuration = 0;
        Graphics2D g = (Graphics2D)g2;
        try {
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            double alpha = 0.0;
            int lx1 = 0;
            int ly1 = 0;
            int lx2 = 0;
            int ly2 = 0;
            if (markers.size() > 0) {
                boolean first = true;
                for (Marker marker : markers) {
                    int[] coord;
                    if (marker.isInside() && marker.isSelected()) {
                        ++MapLayer.numberOfInsideAndSelected;
                    }
                    if (marker.isSelected() || marker.isInside()) {
                        MapLayer.mapViewer.setPanEnabled(false);
                    }
                    marker.draw(g);
                    if (first) {
                        first = false;
                        x1 = marker.getLongitude();
                        y1 = marker.getLatitude();
                        coord = MapCalc.geoToPixelMapA(y1, x1);
                        lx1 = coord[0];
                        ly1 = coord[1];
                        g.setColor(UColor.BLUE3);
                        g.fillOval(lx1 - 5, ly1 - 5, 10, 10);
                        g.setColor(UColor.BLUE1);
                        g.drawOval(lx1 - 5, ly1 - 5, 10, 10);
                        continue;
                    }
                    x2 = marker.getLongitude();
                    y2 = marker.getLatitude();
                    coord = MapCalc.geoToPixelMapA(y2, x2);
                    lx2 = coord[0];
                    ly2 = coord[1];
                    g.setStroke(new BasicStroke(3.0f));
                    g.setColor(UColor.BLUE2);
                    if (NetworkParameters.drawMarkerArrows) {
                        g.setColor(UColor.BLUE4);
                    }
                    if (MapLayer.dark && NetworkParameters.drawMarkerArrows) {
                        g.setColor(UColor.BLUE3);
                    }
                    g.drawLine(lx1, ly1, lx2, ly2);
                    if (NetworkParameters.drawMarkerArrows) {
                        g.setStroke(new BasicStroke(0.8f));
                        g.setColor(UColor.BLUE1);
                        g.drawLine(lx1, ly1, lx2, ly2);
                        dx = lx2 - lx1;
                        dy = ly2 - ly1;
                        alpha = Math.atan(dy / dx);
                        alpha = 180.0 * alpha / Math.PI;
                        if (dx >= 0.0 && dy >= 0.0 || dx >= 0.0 && dy <= 0.0) {
                            g.fillArc(lx2 - 12, ly2 - 12, 24, 24, 180 - (int)alpha - 12, 24);
                        } else {
                            g.fillArc(lx2 - 12, ly2 - 12, 24, 24, -((int)alpha) - 12, 24);
                        }
                    }
                    if (NetworkParameters.displayMarkerDistance) {
                        MapLayer.drawDistance(x1, y1, 0.0, x2, y2, 0.0, g);
                    }
                    totalDistance += (int)MapLayer.distance(x1, y1, x2, y2);
                    ++totalDuration;
                    x1 = marker.getLongitude();
                    y1 = marker.getLatitude();
                    coord = MapCalc.geoToPixelMapA(y1, x1);
                    lx1 = coord[0];
                    ly1 = coord[1];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Marker get(int idx) {
        return markers.get(idx);
    }

    public static int getIndex(Marker marker) {
        for (int i = 0; i < markers.size(); ++i) {
            if (markers.get(i) != marker) continue;
            return i;
        }
        return -1;
    }

    public static int size() {
        return markers.size();
    }

    public static void delete(int idx) {
        markers.remove(idx);
    }

    public static void saveGpsCoords(String fileName, String title, String from, String to, boolean loop, int delay, int nLoop, int attente) {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(Project.getGpsFileFromName(fileName)));
            ps.println(title);
            ps.println(from);
            ps.println(to);
            ps.println(loop);
            ps.println(nLoop);
            boolean first = true;
            double lo = 0.0;
            double la = 0.0;
            double el = 0.0;
            double ra = 0.0;
            for (Marker marker : markers) {
                if (first) {
                    first = false;
                    lo = marker.getLongitude();
                    la = marker.getLatitude();
                    el = marker.getElevation();
                    ra = marker.getRadius();
                    ps.println(attente + " " + marker.getLongitude() + " " + marker.getLatitude() + " " + marker.getElevation() + " " + marker.getRadius());
                    continue;
                }
                ps.println("1 " + marker.getLongitude() + " " + marker.getLatitude() + " " + marker.getElevation() + " " + marker.getRadius());
            }
            if (loop) {
                ps.println(delay + " " + lo + " " + la + " " + el + " " + ra);
            }
            ps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void selectInsideRectangle(int cadreX1, int cadreY1, int cadreX2, int cadreY2) {
        boolean selection = false;
        for (Marker marker : markers) {
            marker.setSelected(false);
            if (!MapLayer.insideSelection(marker.getLongitude(), marker.getLatitude(), cadreX1, cadreY1, cadreX2, cadreY2)) continue;
            marker.setSelected(true);
            selection = true;
        }
        if (selection && CupCarbonApp.cupCarbonController != null) {
            CupCarbonApp.cupCarbonController.updateObjectListView();
            CupCarbonApp.cupCarbonController.getNodeInformations();
            CupCarbonApp.cupCarbonController.getRadioInformations();
            CupCarbonApp.cupCarbonController.updateSelectionInListView();
        }
    }

    public void deleteIfSelected() {
        CupActionBlock block = new CupActionBlock();
        int index = 0;
        for (Marker marker : markers) {
            if (marker.isSelected()) {
                CupActionDeleteMarker action = new CupActionDeleteMarker(marker, index);
                block.addAction(action);
            }
            ++index;
        }
        if (block.size() > 0) {
            CupActionStack.add(block);
            CupActionStack.execute();
        }
    }

    public static void deleteAll() {
        markers.removeAll(markers);
    }

    public void setSelectionOfAllMarkers(boolean selection, boolean addSelect) {
        for (Marker marker : markers) {
            if (!addSelect) {
                marker.setSelected(false);
            }
            marker.setSelected(selection);
        }
        MapLayer.repaint();
    }

    public void invertSelection() {
        for (Marker mar : markers) {
            mar.invSelection();
        }
        MapLayer.repaint();
    }

    public static void generateOSMRouteFile() {
        String host1 = "https://api.geoapify.com/v1/routing?waypoints=";
        String host2 = "&mode=drive&apiKey=cbb9a1bc89344c4181cd87d37f9649a1";
        Object coords = "";
        int n1 = 0;
        int n2 = markers.size();
        if (n2 > 2) {
            n1 = n2 - 2;
        }
        for (int i = n1; i < n2; ++i) {
            if (i > n1) {
                coords = (String)coords + "%7C";
            }
            coords = (String)coords + markers.get(i).getLatitude() + "%2C" + markers.get(i).getLongitude();
        }
        String host = host1 + (String)coords + host2;
        System.out.println(host);
        MarkerList.gpxToMarkers(host);
    }

    public static void generateOSMRouteFile(int id1, int id2) {
        IoTNode iotn1 = DeviceList.getIoTNodeById(id1);
        IoTNode iotn2 = DeviceList.getIoTNodeById(id2);
        DeviceList.setCanMoveForAllIoTNodes(false);
        String host1 = "https://api.geoapify.com/v1/routing?waypoints=";
        String host2 = "&mode=drive&apiKey=cbb9a1bc89344c4181cd87d37f9649a1";
        Object coords = "";
        coords = (String)coords + iotn1.getLatitude() + "%2C" + iotn1.getLongitude();
        coords = (String)coords + "%7C";
        coords = (String)coords + iotn2.getLatitude() + "%2C" + iotn2.getLongitude();
        String host = host1 + (String)coords + host2;
        System.out.println(host);
        MarkerList.gpxToMarkers2(host);
        String fn = "id" + iotn1.getId() + "_tracking_route";
        MarkerList.saveGpsCoords(fn + ".gps", "tmproute", "bejaia", "aoukas", false, 0, 1, 0);
        iotn1.setRoute(fn);
        iotn1.setRouteIndex(0);
        iotn1.loadRouteFromFile();
        DeviceList.setCanMoveForAllIoTNodes(true);
    }

    public static void generateOSMRouteFile2() {
        Object host = "https://graphhopper.com/api/1/route?";
        int n1 = 0;
        int n2 = markers.size();
        if (n2 > 2) {
            n1 = n2 - 2;
        }
        for (int i = n1; i < n2; ++i) {
            host = (String)host + "point=" + markers.get(i).getLatitude() + "," + markers.get(i).getLongitude() + "&";
        }
        host = (String)host + "&vehicle=car&locale=de&key=4f886c6f-a01c-4069-ba46-0b40487923d3&type=gpx";
        try {
            File f = new File("gpx");
            try {
                f.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            URL url = new URL((String)host);
            URLConnection uc = null;
            if (SolverProxyParams.host.equals("") && SolverProxyParams.port.equals("")) {
                uc = url.openConnection();
            } else {
                InetSocketAddress sa = new InetSocketAddress(SolverProxyParams.host, Integer.parseInt(SolverProxyParams.port));
                Proxy proxy = new Proxy(Proxy.Type.HTTP, sa);
                uc = url.openConnection(proxy);
            }
            uc.setRequestProperty("User-Agent", "CupCarbon");
            InputStream in = uc.getInputStream();
            FileOutputStream file = new FileOutputStream("gpx/tmp.gpx");
            int l = 0;
            while ((l = in.read()) != -1) {
                file.write(l);
            }
            in.close();
            file.close();
            MarkerList.gpxToMarkers2();
        }
        catch (MalformedURLException e) {
            System.err.println("[CUPCARBON: MarkerList/generateOSMRouteFile] " + (String)host + " : URL problem.");
        }
        catch (IOException e) {
            System.err.println("[CUPCARBON: MarkerList/generateOSMRouteFile] ------ Connexion problem ! ------");
        }
    }

    public static void gpxToMarkers2(String host) {
        try {
            LinkedList<Marker> nMarkers = new LinkedList<Marker>();
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url(host).method("GET", null).build();
            Response response = client.newCall(request).execute();
            String s = response.body().string();
            JSONObject json = new JSONObject(s);
            JSONArray js = new JSONArray(json.getJSONArray("features")).getJSONObject(0).getJSONObject("geometry").getJSONArray("coordinates").getJSONArray(0);
            for (int i = 0; i < js.length(); ++i) {
                JSONArray jsonCoords = js.getJSONArray(i);
                nMarkers.add(new Marker(jsonCoords.getDouble(0), jsonCoords.getDouble(1), 0.0, 5.0));
            }
            CupActionBlock block = new CupActionBlock();
            CupActionRouteFromMarkers action = new CupActionRouteFromMarkers(markers, nMarkers);
            block.addAction(action);
            CupActionStack.add(block);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void gpxToMarkers(String host) {
        try {
            LinkedList<Marker> nMarkers = new LinkedList<Marker>(markers);
            nMarkers.removeLast();
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url(host).method("GET", null).build();
            Response response = client.newCall(request).execute();
            String s = response.body().string();
            JSONObject json = new JSONObject(s);
            JSONArray js = new JSONArray(json.getJSONArray("features")).getJSONObject(0).getJSONObject("geometry").getJSONArray("coordinates").getJSONArray(0);
            for (int i = 0; i < js.length(); ++i) {
                JSONArray jsonCoords = js.getJSONArray(i);
                nMarkers.add(new Marker(jsonCoords.getDouble(0), jsonCoords.getDouble(1), 0.0, 5.0));
            }
            CupActionBlock block = new CupActionBlock();
            CupActionRouteFromMarkers action = new CupActionRouteFromMarkers(markers, nMarkers);
            block.addAction(action);
            CupActionStack.add(block);
            CupActionStack.execute();
            MapLayer.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void gpxToMarkers2() {
        CupActionBlock block = new CupActionBlock();
        LinkedList<Marker> nMarkers = new LinkedList<Marker>(markers);
        nMarkers.removeLast();
        try {
            String s;
            BufferedReader br = new BufferedReader(new FileReader("gpx/tmp.gpx"));
            while (!br.readLine().startsWith("<trkpt")) {
            }
            while ((s = br.readLine()).startsWith("<trkpt")) {
                String[] st = s.split("\"");
                nMarkers.add(new Marker(Double.valueOf(st[3]), Double.valueOf(st[1]), 0.0, 5.0));
            }
            br.close();
            File f = new File("gpx/tmp.gpx");
            f.delete();
            f = new File("gpx");
            f.delete();
            CupActionRouteFromMarkers action = new CupActionRouteFromMarkers(markers, nMarkers);
            block.addAction(action);
            CupActionStack.add(block);
            CupActionStack.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void insertMarkers() {
        ArrayList<Integer> iList = new ArrayList<Integer>();
        for (int i = 0; i < markers.size() - 1; ++i) {
            if (!markers.get(i).isSelected()) continue;
            iList.add(i);
        }
        if (iList.size() > 0) {
            CupActionInsertMarker action = new CupActionInsertMarker(iList);
            CupActionBlock block = new CupActionBlock();
            block.addAction(action);
            CupActionStack.add(block);
            CupActionStack.execute();
        }
    }

    public static void selectNextMarkers() {
        for (int i = 0; i < markers.size(); ++i) {
            if (!markers.get(i).isSelected() || markers.get(i + 1).isSelected()) continue;
            markers.get(i + 1).setSelected(true);
            break;
        }
    }

    public static void insertMarkers2() {
        int n = markers.size() - 1;
        for (int i = 0; i < n; ++i) {
            if (!markers.get(i * 2 + 1).isSelected()) continue;
            MapLayer.addMarker(i * 2 + 1, Marker.getCentre(markers.get(i * 2), MarkerList.get(i * 2 + 1), true));
        }
    }

    public static boolean transformMarkersToSensors() {
        boolean markerSelected = false;
        if (markers.size() > 0) {
            CupActionBlock block = new CupActionBlock();
            for (int i = 0; i < markers.size(); ++i) {
                Marker marker = markers.get(i);
                if (!marker.isSelected()) continue;
                markerSelected = true;
                IoTNode ioTNode = new IoTNode(marker.getLongitude(), marker.getLatitude(), marker.getElevation(), 0.0, 100.0, 20.0, -1, 0);
                CupActionAddSensor action = new CupActionAddSensor(ioTNode);
                block.addAction(action);
            }
            if (block.size() > 0) {
                CupActionStack.add(block);
                CupActionStack.execute();
            }
        }
        return markerSelected;
    }

    public static void deselectAll() {
        for (Marker marker : markers) {
            marker.setSelected(false);
        }
    }

    public static void selectAll() {
        for (Marker marker : markers) {
            marker.setSelected(true);
        }
    }

    public static void delete(Marker marker) {
        Iterator iterator2 = markers.iterator();
        while (iterator2.hasNext()) {
            Marker tMarker = (Marker)iterator2.next();
            if (tMarker != marker) continue;
            iterator2.remove();
        }
        if (DeviceList.propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
    }
}

