/*
 * Decompiled with CFR 0.152.
 */
package radio_module;

import device.DeviceList;
import device.SensorNode;
import enegy_conso_model.EnergyConsumptionModel;
import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintStream;
import radio_module.RadioModule_Lora;
import radio_module.RadioModule_Wifi;
import radio_module.RadioModule_ZigBee;
import utilities.UColor;

public abstract class RadioModule {
    public static final String CLASSICAL_TX = "Classical (Tx)";
    public static final String CLASSICAL_RX = "Classical (Rx)";
    public static final String HEINZELMAN_TX = "Heinzelman (Tx)";
    public static final String HEINZELMAN_RX = "Heinzelman (Rx)";
    protected String name;
    protected int radioDataRate = 250000;
    protected double radioRangeRadius = 0.0;
    protected double radioRangeRadiusOri = 0.0;
    protected Color radioRangeColor1 = UColor.PURPLE_TTRANSPARENT;
    protected Color radioRangeColor2 = UColor.PURPLE_TRANSPARENT;
    protected double eTx = 5.92E-5;
    protected double eRx = 2.86E-5;
    protected double eSleep = 1.0E-7;
    protected double eListen = 1.0E-6;
    protected int my = 0;
    protected double pl = 100.0;
    protected int ch = 0;
    protected int nId = 13108;
    protected String radioConsoTxModel = "Classical (Tx)";
    protected String radioConsoRxModel = "Classical (Rx)";
    protected double timeToResend = 3.01;
    protected int numberOfSends = 3;
    protected int attempts = 0;
    protected double frequency = 2.4E9;
    protected double requiredQuality = -80.0;
    protected double transmitPower = 0.0;
    protected SensorNode sensorNode;
    public static final int NONE = 0;
    public static final int ZIGBEE_802_15_4 = 1;
    public static final int WIFI_802_11 = 2;
    public static final int LORA = 3;

    public static int getSubChannel(int std) {
        if (std == 0) {
            return 128;
        }
        if (std == 1) {
            return 128;
        }
        if (std == 2) {
            return 512;
        }
        if (std == 3) {
            return 1;
        }
        return -1;
    }

    public static int getDataRate(int std) {
        if (std == 0) {
            return 250000;
        }
        if (std == 1) {
            return 250000;
        }
        if (std == 2) {
            return 72000000;
        }
        if (std == 3) {
            return 30000;
        }
        return 128;
    }

    public static String getDataRate(String str) {
        if (str.equals("NONE")) {
            return "250000";
        }
        if (str.equals("802.15.4")) {
            return "250000";
        }
        if (str.equals("WIFI 802.11")) {
            return "72000000";
        }
        if (str.equals("LoRa")) {
            return "30000";
        }
        return "128";
    }

    public RadioModule(SensorNode sensorNode, String name) {
        this.sensorNode = sensorNode;
        this.name = name;
    }

    public abstract int getStandard();

    public int getRadioDataRate() {
        return this.radioDataRate;
    }

    public void setRadioDataRate(int radioDataRate) {
        this.radioDataRate = radioDataRate;
    }

    public abstract String getStandardName();

    public static int getStandardByName(String stdName) {
        if (stdName.equals("NONE")) {
            return 0;
        }
        if (stdName.equals("ZIGBEE")) {
            return 1;
        }
        if (stdName.equals("WIFI")) {
            return 2;
        }
        if (stdName.equals("LORA")) {
            return 3;
        }
        return -1;
    }

    public static String getNameByStandard(int std) {
        if (std == 0) {
            return "NONE";
        }
        if (std == 1) {
            return "ZIGBEE";
        }
        if (std == 2) {
            return "WIFI";
        }
        if (std == 3) {
            return "LORA";
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public void consume(int v) {
        this.sensorNode.getBattery().consume(v);
    }

    public void consumeTx(int numberOfBits) {
        if (this.radioConsoTxModel.equals(CLASSICAL_TX)) {
            this.sensorNode.getBattery().consume((double)numberOfBits / 8.0 * this.eTx * this.pl / 100.0);
            return;
        }
        if (this.radioConsoTxModel.equals(HEINZELMAN_TX)) {
            this.sensorNode.getBattery().consume(5.0E-8 * (double)numberOfBits + 1.0E-10 * (double)numberOfBits * (this.radioRangeRadius * this.pl / 100.0));
            return;
        }
        double v = EnergyConsumptionModel.evaluate("Consumption Model (TX)", this.getSensorNode().getId(), this.getName(), this.radioConsoTxModel, this.pl / 100.0, numberOfBits, this.eTx, this.radioRangeRadius);
        this.sensorNode.getBattery().consume(v);
    }

    public void consumeRx(int numberOfBits) {
        if (this.radioConsoRxModel.equals(CLASSICAL_RX)) {
            this.sensorNode.getBattery().consume((double)numberOfBits / 8.0 * this.eRx);
            return;
        }
        if (this.radioConsoRxModel.equals(HEINZELMAN_RX)) {
            this.sensorNode.getBattery().consume(5.0E-8 * (double)numberOfBits);
            return;
        }
        double v = EnergyConsumptionModel.evaluate("Consumption Model (RX)", this.getSensorNode().getId(), this.getName(), this.radioConsoRxModel, this.pl / 100.0, numberOfBits, this.eRx, this.radioRangeRadius);
        this.sensorNode.getBattery().consume(v);
    }

    public void setMy(int my) {
        this.my = my;
    }

    public void setPl(double pl) {
        this.pl = pl;
        this.getSensorNode().calculateRadioSpace();
    }

    public double getPl() {
        return this.pl;
    }

    public double getETx() {
        return this.eTx;
    }

    public void setETx(double eTx) {
        this.eTx = eTx;
    }

    public double getERx() {
        return this.eRx;
    }

    public void setERx(double eRx) {
        this.eRx = eRx;
    }

    public double getESleep() {
        return this.eSleep;
    }

    public void setESleep(double eSleep) {
        this.eSleep = eSleep;
    }

    public double getEListen() {
        return this.eListen;
    }

    public void setEListen(double eListen) {
        this.eListen = eListen;
    }

    public int getCh() {
        return this.ch;
    }

    public void setCh(int ch) {
        this.ch = ch;
    }

    public int getNId() {
        return this.nId;
    }

    public void setNId(int nId) {
        this.nId = nId;
    }

    public void drawRadioRadius(int x, int y, int r, Graphics g) {
        if (r > 0 && this.sensorNode.getDisplaydRadius()) {
            g.setColor(UColor.WHITE_TRANSPARENT);
            int lr1 = (int)((double)r * Math.cos(0.7853981633974483));
            g.drawLine(x, y, x + lr1, y - lr1);
            g.drawString(r + " m", x + lr1 / 2, (int)((double)y - (double)lr1 / 4.0));
        }
    }

    public double getRequiredQuality() {
        return this.requiredQuality;
    }

    public void setRequiredQuality(double requiredQuality) {
        this.requiredQuality = requiredQuality;
    }

    public int getMy() {
        return this.my;
    }

    public double getTimeToResend() {
        return this.timeToResend;
    }

    public void setTimeToResend(double timeToResend) {
        this.timeToResend = timeToResend;
    }

    public int getNumberOfSends() {
        return this.numberOfSends;
    }

    public void setNumberOfSends(int numberOfSends) {
        this.numberOfSends = numberOfSends;
    }

    public double getRadioRangeRadius() {
        return this.radioRangeRadius;
    }

    public void setRadioRangeRadius(double radioRangeRadius) {
        this.radioRangeRadius = radioRangeRadius;
        if (DeviceList.propagationsCalculated) {
            DeviceList.calculatePropagations();
        }
    }

    public double getRadioRangeRadiusOri() {
        return this.radioRangeRadiusOri;
    }

    public void setRadioRangeRadiusOri(double radioRangeRadiusOri) {
        this.radioRangeRadiusOri = radioRangeRadiusOri;
    }

    public Color getRadioRangeColor1() {
        return this.radioRangeColor1;
    }

    public Color getRadioRangeColor2() {
        return this.radioRangeColor2;
    }

    public void resizeRadioRangeRadius(int i) {
        this.radioRangeRadius += (double)i;
    }

    public void resizeRadioRangeRadiusOri(int i) {
        this.radioRangeRadius += (double)i;
    }

    public abstract void init();

    public abstract double getTransmitPower();

    public void setTransmitPower(double transmitPower) {
        this.transmitPower = transmitPower;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public abstract RadioModule duplicate(SensorNode var1);

    public SensorNode getSensorNode() {
        return this.sensorNode;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public void incAttempts() {
        ++this.attempts;
    }

    public static RadioModule newRadioModule(SensorNode sensor, String name, String sStandard) {
        int standard = RadioModule.getStandardByName(sStandard);
        return RadioModule.newRadioModule(sensor, name, standard);
    }

    public static RadioModule newRadioModule(SensorNode sensor, String name, int standard) {
        if (standard == 1) {
            return new RadioModule_ZigBee(sensor, name);
        }
        if (standard == 3) {
            return new RadioModule_Lora(sensor, name);
        }
        if (standard == 2) {
            return new RadioModule_Wifi(sensor, name);
        }
        return null;
    }

    public abstract void save(PrintStream var1, RadioModule var2);

    public int getSpreadingFactor() {
        return -1;
    }

    public int getCodeRate() {
        return -1;
    }

    public void setSpreadingFactor(int v) {
    }

    public void setCodeRate(int v) {
    }

    public void setRadioConsoTxModel(String model) {
        this.radioConsoTxModel = model;
    }

    public String getRadioConsoTxModel() {
        return this.radioConsoTxModel;
    }

    public void setRadioConsoRxModel(String model) {
        this.radioConsoRxModel = model;
    }

    public String getRadioConsoRxModel() {
        return this.radioConsoRxModel;
    }
}

