/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;
import senscript.Command;
import senscript.SenScript;
import senscript.SenScriptCondition;
import senscript.SenScriptCondition_GREATER;
import senscript.SenScriptCondition_LESS;
import simulation.WisenSimulation;

public class Command_FOR
extends Command {
    protected String arg1;
    protected String arg2;
    protected String sStep = "0";
    protected double step = 0.0;
    protected String left = "";
    protected String right;
    protected boolean trueCondition = true;
    protected boolean first = true;
    protected boolean exist = false;
    protected int index = -1;
    protected int endForIndex = -1;
    protected Command_FOR parent = null;
    private boolean firstVerif = true;

    public boolean isCondition() {
        return this.trueCondition;
    }

    public void setCondition(boolean isCondition) {
        this.trueCondition = isCondition;
    }

    public Command_FOR getParent() {
        return this.parent;
    }

    public void setParent(Command_FOR parent) {
        this.parent = parent;
    }

    public Command_FOR(SensorNode sensor, String arg1, String arg2, String arg3, String arg4) {
        this.sensor = sensor;
        this.trueCondition = true;
        this.first = true;
        this.exist = false;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.left = arg1;
        this.right = arg3;
        this.sStep = arg4;
    }

    public String getRight() {
        return this.right;
    }

    public String getLeft() {
        return this.left;
    }

    public double getStep() {
        return this.step;
    }

    @Override
    public double execute() {
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " FOR ");
        if (this.first) {
            this.step = Double.valueOf(this.sensor.getScript().getVariableValue(this.sStep));
            this.first = false;
            this.exist = this.sensor.getScript().variableExist(this.arg1);
            String arg = this.sensor.getScript().getVariableValue(this.arg2);
            this.sensor.getScript().addVariable(this.arg1, arg);
        }
        this.index = this.sensor.getScript().getIndex();
        SenScript script = this.sensor.getScript();
        String n = this.getRight();
        String variable = this.getLeft();
        String v1 = this.sensor.getScript().getVariableValue(variable);
        String v2 = this.sensor.getScript().getVariableValue("" + this.getStep());
        double z = 0.0;
        if (this.firstVerif) {
            this.firstVerif = false;
            z = Double.valueOf(v1);
        } else {
            z = Double.valueOf(v1) + Double.valueOf(v2);
        }
        this.sensor.getScript().addVariable(variable, "" + z);
        SenScriptCondition condition = null;
        condition = this.getStep() >= 0.0 ? new SenScriptCondition_LESS(this.sensor, variable, n) : new SenScriptCondition_GREATER(this.sensor, variable, n);
        this.trueCondition = condition.evaluate();
        if (!this.trueCondition) {
            script.setIndex(this.endForIndex);
            this.init();
        }
        return 0.0;
    }

    public boolean getTrueCondition() {
        return this.trueCondition;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getEndForIndex() {
        return this.endForIndex;
    }

    public void setEndForIndex(int endForIndex) {
        this.endForIndex = endForIndex;
    }

    public void removeVar() {
        this.sensor.getScript().removeVar(this.arg1);
    }

    public void init() {
        this.first = true;
        this.firstVerif = true;
        if (!this.exist) {
            String arg = this.sensor.getScript().getVariableValue(this.arg2);
            this.sensor.getScript().addVariable(this.arg1, arg);
            this.sensor.getScript().removeVar(this.arg1);
        }
    }

    @Override
    public String getArduinoForm() {
        String sarg2 = this.arg2 + ".toInt()";
        String sright = this.right + ".toInt()";
        String ssStep = this.sStep + ".toInt()";
        String s = "for(int " + this.arg1 + "=" + sarg2 + ";" + this.arg1 + "<" + sright + ";" + this.arg1 + "+=" + ssStep + ") {";
        return s;
    }

    @Override
    public String toString() {
        return "FOR";
    }
}

