/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import project.Project;
import senscript.Command;
import senscript.Command_FOR;
import senscript.Command_IF;
import senscript.Command_WHILE;
import senscript.SenScriptTabList;

public class SenScript {
    protected LinkedList<Command> commands = new LinkedList();
    protected SensorNode sensor = null;
    protected int index = 0;
    protected int loopIndex = 0;
    protected double event = Double.MAX_VALUE;
    protected boolean breaked = false;
    protected int level;
    protected SenScript parent;
    protected Command_IF currentIf = null;
    protected Command_WHILE currentWhile = null;
    protected Command_FOR currentFor = null;
    protected HashMap<String, String> variables;
    protected SenScriptTabList tables;
    protected Hashtable<String, Integer> labels;
    protected boolean waiting = false;
    protected PrintStream ps = null;

    public SenScript(SensorNode sensor) {
        this.sensor = sensor;
        this.index = 0;
        this.variables = new HashMap();
        this.tables = new SenScriptTabList();
        this.labels = new Hashtable();
    }

    public void add(Command command) {
        this.commands.add(command);
    }

    public void next() {
        if (!this.breaked) {
            ++this.index;
            if (this.index >= this.commands.size()) {
                this.index = this.loopIndex;
            }
        }
    }

    public void previous() {
        if (!this.breaked) {
            --this.index;
            if (this.index < 0) {
                this.index = 0;
            }
        }
    }

    public void init() {
        this.variables = new HashMap();
        this.sensor.initBuffer();
        this.tables = new SenScriptTabList();
        this.index = 0;
        this.waiting = false;
        this.loopIndex = 0;
        this.event = 2.147483646E9;
        this.breaked = false;
        this.level = 0;
        this.createFile();
    }

    public void init2() {
        this.commands = new LinkedList();
        this.currentIf = null;
        this.currentWhile = null;
        this.currentFor = null;
        this.index = 0;
        this.waiting = false;
        this.loopIndex = 0;
        this.event = 2.147483646E9;
        this.breaked = false;
        this.level = 0;
    }

    public void createFile() {
        String name = Project.getProjectResultPath() + File.separator + this.sensor.getName() + ".txt";
        File file = new File(name);
        if (file.exists()) {
            file.delete();
        }
    }

    public void printFile(String text) {
        String name = Project.getProjectResultPath() + File.separator + this.sensor.getName() + ".txt";
        File file = new File(name);
        if (!file.exists()) {
            try {
                FileOutputStream fos = new FileOutputStream(name);
                this.ps = new PrintStream(fos);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.ps.println(text);
        this.ps.flush();
    }

    public int size() {
        return this.commands.size();
    }

    public Command getCurrent() {
        return this.commands.get(this.index);
    }

    public String toString() {
        Object s = "";
        Iterator it = this.commands.iterator();
        while (it.hasNext()) {
            s = (String)s + String.valueOf(it.next()) + "\n";
        }
        return s;
    }

    public void executeCommand() {
        this.event = this.getCurrent().execute();
    }

    public double getEvent() {
        return this.event;
    }

    public void addVariable(String s1, String s2) {
        this.variables.put(s1, s2);
    }

    public void putVariable(String var, String s) {
        this.variables.put(var, s);
    }

    public String getVariableValue2(String arg) {
        if (arg.equals("\\")) {
            return "";
        }
        if (arg.equals("")) {
            return "";
        }
        if (arg.charAt(0) == '$') {
            return this.variables.get(arg.substring(1));
        }
        return arg;
    }

    public String getVariableValue(String arg) {
        if (arg.charAt(0) == '\"') {
            return arg.substring(1, arg.lastIndexOf(34));
        }
        if (arg.equals("\\")) {
            return "";
        }
        if (arg.equals("")) {
            return "";
        }
        if (arg.charAt(0) == '$') {
            return this.variables.get(arg.substring(1));
        }
        if (this.isNumeric(arg)) {
            return arg;
        }
        return this.variables.get(arg);
    }

    public boolean isNumeric(String arg) {
        try {
            Double.parseDouble(arg);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void variablesToValues(String[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            args2[i] = this.getVariableValue(args2[i]);
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setIndexToLoopIndex() {
        this.loopIndex = this.index;
    }

    public void setBreaked(boolean breaked) {
        this.breaked = breaked;
    }

    public void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLevel() {
        return this.level;
    }

    public SenScript getParent() {
        return this.parent;
    }

    public void setCurrentIf(Command_IF command) {
        this.currentIf = command;
        this.add(command);
    }

    public Command_IF getCurrentIf() {
        return this.currentIf;
    }

    public Command_IF removeCurrentIf() {
        this.currentIf = this.currentIf.getParent();
        return this.currentIf;
    }

    public Command_WHILE getCurrentWhile() {
        return this.currentWhile;
    }

    public void setCurrentWhile(Command_WHILE currentWhile) {
        this.currentWhile = currentWhile;
    }

    public Command_WHILE removeCurrentWhile() {
        this.currentWhile = this.currentWhile.getParent();
        return this.currentWhile;
    }

    public Command_FOR getCurrentFor() {
        return this.currentFor;
    }

    public void setCurrentFor(Command_FOR currentFor) {
        this.currentFor = currentFor;
    }

    public Command_FOR removeCurrentFor() {
        this.currentFor = this.currentFor.getParent();
        return this.currentFor;
    }

    public void putTable(String name, int heigth, int width) {
        this.tables.putTable(name, heigth, width);
    }

    public void putVector(String name, int heigth) {
        this.tables.putVector(name, heigth);
    }

    public String[][] getTable(String tabName) {
        return this.tables.getTable(tabName);
    }

    public String[] getVector(String tabName) {
        return this.tables.getVector(tabName);
    }

    public LinkedList<Command> getCommands() {
        return this.commands;
    }

    public boolean variableExist(String var) {
        return this.variables.containsKey(var);
    }

    public void removeVar(String var) {
        this.variables.remove(var);
    }

    public void displayVars() {
        System.out.println(this.variables);
    }

    public void addLabel(String label, int lineNumber) {
        this.labels.put(label, lineNumber);
    }

    public int getLineOfLabel(String label) {
        return this.labels.get(label);
    }
}

