/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import project.Project;

public class SenScriptEditor
extends JFrame {
    private JTextPane textPane;
    private JTextArea errorArea;
    private JLabel statusLabel;
    private StyledDocument doc;
    private boolean isValidating = false;
    private File currentFile = null;
    private Timer autoSaveTimer;
    private Style keywordStyle;
    private Style commentStyle;
    private Style stringStyle;
    private Style numberStyle;
    private Style operatorStyle;
    private Style normalStyle;
    private final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("ATCH", "ATID", "ATPL", "ATMY", "ATNID", "ATND", "ATGET", "RADIO", "SEND", "READ", "PICK", "RECEIVE", "WAIT", "BUFFER", "CBUFFER", "AREADSENSOR", "DREADSENSOR", "BATTERY", "SETBATTERY", "KILL", "SET", "INC", "DEC", "AND", "OR", "XOR", "NOT", "BAND", "BOR", "BXOR", "BNOT", "MATH", "MAX", "MIN", "SMAX", "SMIN", "RAND", "REANDB", "RGAUSS", "CONC", "CHARAT", "LENGTH", "DATA", "RDATA", "NTH", "HASH", "INT", "SADD", "VEC", "VGET", "VSET", "TAB", "TSET", "VDATA", "MOVE", "RMOVE", "ROTATE", "ROUTE", "GETPOS", "GETPOS2", "GETINFO", "DISTANCE", "ANGLE", "ANGLE2", "IF", "ELSE", "END", "WHILE", "FOR", "LOOP", "GOTO", "PRINT", "CPRINT", "PRINTFILE", "MARK", "LED", "EDGE", "DELAY", "TIME", "SIMULATION", "STOP", "SCRIPT", "RSCRIPT"));
    private final Set<String> MATH_FUNCTIONS = new HashSet<String>(Arrays.asList("sqrt", "sin", "cos", "tan", "asin", "acos", "atan", "abs", "pow", "log", "log10", "exp"));
    private final Set<String> OPERATORS = new HashSet<String>(Arrays.asList("==", "!=", "<", ">", "<=", ">=", "+", "-", "*", "/", "%", "=", "&", "|", "^", "~"));

    public SenScriptEditor() {
        this.initializeScriptsDirectory();
        this.initializeGUI();
        this.initializeStyles();
        this.setupDocumentListener();
        this.setupAutoSave();
    }

    private void initializeGUI() {
        this.setTitle("SenScript Editor - CupCarbon Scripting Language");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem newItem = new JMenuItem("New");
        JMenuItem openItem = new JMenuItem("Open");
        JMenuItem saveItem = new JMenuItem("Save");
        JMenuItem saveAsItem = new JMenuItem("Save As");
        newItem.addActionListener(e -> this.newFile());
        openItem.addActionListener(e -> this.openFile());
        saveItem.addActionListener(e -> this.saveFile());
        saveAsItem.addActionListener(e -> this.saveFileAs());
        fileMenu.add(newItem);
        fileMenu.add(openItem);
        fileMenu.addSeparator();
        fileMenu.add(saveItem);
        fileMenu.add(saveAsItem);
        JMenu editMenu = new JMenu("Edit");
        JMenuItem validateItem = new JMenuItem("Validate Script");
        validateItem.addActionListener(e -> this.validateScript());
        editMenu.add(validateItem);
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        this.setJMenuBar(menuBar);
        JToolBar toolBar = new JToolBar();
        JButton newBtn = new JButton("New");
        JButton openBtn = new JButton("Open");
        JButton saveBtn = new JButton("Save");
        JButton validateBtn = new JButton("Validate");
        newBtn.addActionListener(e -> this.newFile());
        openBtn.addActionListener(e -> this.openFile());
        saveBtn.addActionListener(e -> this.saveFile());
        validateBtn.addActionListener(e -> this.validateScript());
        toolBar.add(newBtn);
        toolBar.add(openBtn);
        toolBar.add(saveBtn);
        toolBar.addSeparator();
        toolBar.add(validateBtn);
        this.add((Component)toolBar, "North");
        JSplitPane mainSplit = new JSplitPane(0);
        this.textPane = new JTextPane();
        this.textPane.setFont(new Font("Monospaced", 0, 14));
        this.doc = this.textPane.getStyledDocument();
        JScrollPane editorScroll = new JScrollPane(this.textPane);
        editorScroll.setPreferredSize(new Dimension(800, 500));
        LineNumberPanel lineNumbers = new LineNumberPanel(this.textPane);
        editorScroll.setRowHeaderView(lineNumbers);
        mainSplit.setTopComponent(editorScroll);
        this.errorArea = new JTextArea(8, 80);
        this.errorArea.setEditable(false);
        this.errorArea.setBackground(new Color(255, 245, 245));
        this.errorArea.setFont(new Font("Monospaced", 0, 12));
        JScrollPane errorScroll = new JScrollPane(this.errorArea);
        errorScroll.setBorder(BorderFactory.createTitledBorder("Errors and Warnings"));
        mainSplit.setBottomComponent(errorScroll);
        mainSplit.setDividerLocation(500);
        this.add((Component)mainSplit, "Center");
        this.statusLabel = new JLabel("Ready - SenScript path");
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.statusLabel, "South");
        this.textPane.setText("// Sample SenScript code\n// Sensor monitoring with communication\n\nloop\n    areadsensor temp\n    if (temp > 30)\n        send \"ALERT:HOT\" *\n        led 1 1\n        mark 1\n    else\n        led 1 0\n        mark 0\n    end\n    delay 5000\nend\n");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initializeScriptsDirectory() {
        File scriptsDir = new File(Project.getProjectScriptPath());
        if (!scriptsDir.exists()) {
            boolean created = scriptsDir.mkdirs();
            if (created) {
                System.out.println("Created SenScripts directory");
            } else {
                System.err.println("Failed to create SenScripts directory");
                JOptionPane.showMessageDialog(this, "Impossible to create SenScript directory:\n\nCheck the writing permissions.", "Directory Error", 0);
            }
        }
    }

    private void setupAutoSave() {
        this.autoSaveTimer = new Timer(30000, e -> {
            if (this.currentFile != null && !this.textPane.getText().trim().isEmpty()) {
                this.autoSaveCurrentFile();
            }
        });
        this.autoSaveTimer.start();
    }

    public void autoSaveCurrentFile() {
        if (this.currentFile != null) {
            try {
                FileWriter scriptFiles = new FileWriter(Project.getProjectScriptPath());
                BufferedWriter writer = new BufferedWriter(scriptFiles);
                writer.write(this.textPane.getText());
                writer.close();
                this.statusLabel.setText("Auto-saved: " + this.currentFile.getName() + " - SenScript path");
            }
            catch (IOException e) {
                this.statusLabel.setText("Auto-save failed: " + e.getMessage());
            }
        }
    }

    private void initializeStyles() {
        this.keywordStyle = this.doc.addStyle("keyword", null);
        StyleConstants.setForeground(this.keywordStyle, new Color(0, 0, 255));
        StyleConstants.setBold(this.keywordStyle, true);
        this.commentStyle = this.doc.addStyle("comment", null);
        StyleConstants.setForeground(this.commentStyle, new Color(0, 128, 0));
        StyleConstants.setItalic(this.commentStyle, true);
        this.stringStyle = this.doc.addStyle("string", null);
        StyleConstants.setForeground(this.stringStyle, new Color(255, 0, 0));
        StyleConstants.setBold(this.stringStyle, true);
        this.numberStyle = this.doc.addStyle("number", null);
        StyleConstants.setForeground(this.numberStyle, new Color(255, 140, 0));
        this.operatorStyle = this.doc.addStyle("operator", null);
        StyleConstants.setForeground(this.operatorStyle, new Color(0, 0, 139));
        this.normalStyle = this.doc.addStyle("normal", null);
        StyleConstants.setForeground(this.normalStyle, Color.BLACK);
    }

    private void setupDocumentListener() {
        this.doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SenScriptEditor.this.highlightSyntax();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SenScriptEditor.this.highlightSyntax();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SenScriptEditor.this.highlightSyntax();
            }
        });
    }

    private void highlightSyntax() {
        if (this.isValidating) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            try {
                this.isValidating = true;
                String text = this.doc.getText(0, this.doc.getLength());
                this.doc.setCharacterAttributes(0, this.doc.getLength(), this.normalStyle, true);
                this.highlightComments(text);
                this.highlightStrings(text);
                this.highlightNumbers(text);
                this.highlightKeywords(text);
                this.highlightOperators(text);
                Timer timer = new Timer(500, e -> this.validateScript());
                timer.setRepeats(false);
                timer.start();
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
            finally {
                this.isValidating = false;
            }
        });
    }

    private void highlightComments(String text) throws BadLocationException {
        Pattern pattern = Pattern.compile("//.*");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            this.doc.setCharacterAttributes(matcher.start(), matcher.end() - matcher.start(), this.commentStyle, false);
        }
    }

    private void highlightStrings(String text) throws BadLocationException {
        Pattern pattern = Pattern.compile("\"([^\"\\\\]|\\\\.)*\"");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            this.doc.setCharacterAttributes(matcher.start(), matcher.end() - matcher.start(), this.stringStyle, false);
        }
    }

    private void highlightNumbers(String text) throws BadLocationException {
        Pattern pattern = Pattern.compile("\\b\\d+(\\.\\d+)?\\b");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            this.doc.setCharacterAttributes(matcher.start(), matcher.end() - matcher.start(), this.numberStyle, false);
        }
    }

    private void highlightKeywords(String text) throws BadLocationException {
        for (String keyword : this.KEYWORDS) {
            Pattern pattern = Pattern.compile("\\b" + keyword.toLowerCase() + "\\b", 2);
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                this.doc.setCharacterAttributes(matcher.start(), matcher.end() - matcher.start(), this.keywordStyle, false);
            }
        }
    }

    private void highlightOperators(String text) throws BadLocationException {
        for (String op : this.OPERATORS) {
            String escaped = Pattern.quote(op);
            Pattern pattern = Pattern.compile(escaped);
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                this.doc.setCharacterAttributes(matcher.start(), matcher.end() - matcher.start(), this.operatorStyle, false);
            }
        }
    }

    private void validateScript() {
        try {
            String text = this.doc.getText(0, this.doc.getLength());
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            this.validateSyntax(text, errors, warnings);
            this.errorArea.setText("");
            if (!errors.isEmpty()) {
                this.errorArea.append("ERRORS:\n");
                for (String error : errors) {
                    this.errorArea.append("  " + error + "\n");
                }
                this.errorArea.append("\n");
                this.statusLabel.setText("Script has " + errors.size() + " error(s)");
            }
            if (!warnings.isEmpty()) {
                this.errorArea.append("WARNINGS:\n");
                for (String warning : warnings) {
                    this.errorArea.append("  " + warning + "\n");
                }
                if (errors.isEmpty()) {
                    this.statusLabel.setText("Script has " + warnings.size() + " warning(s)");
                }
            }
            if (errors.isEmpty() && warnings.isEmpty()) {
                this.errorArea.append("\u2713 Script syntax is valid!\n");
                this.statusLabel.setText("Script is valid - SenScript path");
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void validateSyntax(String text, List<String> errors, List<String> warnings) {
        String[] lines = text.split("\n");
        Stack<String> controlStack = new Stack<String>();
        boolean inLoop = false;
        for (int i = 0; i < lines.length; ++i) {
            String[] tokens;
            String line = lines[i].trim();
            int lineNum = i + 1;
            if (line.isEmpty() || line.startsWith("//")) continue;
            if (line.toLowerCase().startsWith("if")) {
                controlStack.push("if");
                if (!line.contains("(") || !line.contains(")")) {
                    errors.add("Line " + lineNum + ": IF statement missing parentheses");
                }
            } else if (line.toLowerCase().startsWith("while")) {
                controlStack.push("while");
                if (!line.contains("(") || !line.contains(")")) {
                    errors.add("Line " + lineNum + ": WHILE statement missing parentheses");
                }
            } else if (line.toLowerCase().startsWith("for")) {
                controlStack.push("for");
            } else if (line.toLowerCase().equals("loop")) {
                if (inLoop) {
                    errors.add("Line " + lineNum + ": Multiple LOOP statements not allowed");
                }
                inLoop = true;
                controlStack.push("loop");
            } else if (line.toLowerCase().equals("else")) {
                if (controlStack.isEmpty() || !((String)controlStack.peek()).equals("if")) {
                    errors.add("Line " + lineNum + ": ELSE without matching IF");
                }
            } else if (line.toLowerCase().equals("end")) {
                if (controlStack.isEmpty()) {
                    errors.add("Line " + lineNum + ": END without matching control structure");
                } else {
                    String structure = (String)controlStack.pop();
                    if (structure.equals("loop")) {
                        inLoop = false;
                    }
                }
            }
            if ((tokens = line.split("\\s+")).length <= 0) continue;
            String command = tokens[0].toUpperCase();
            if (!(this.KEYWORDS.contains(command) || command.equals("ELSE") || command.equals("END") || line.contains(":") || command.matches("\\d+") || command.matches("[A-Za-z_][A-Za-z0-9_]*:?"))) {
                warnings.add("Line " + lineNum + ": Unknown command '" + command + "'");
            }
            this.validateSpecificCommands(command, tokens, lineNum, errors, warnings);
        }
        while (!controlStack.isEmpty()) {
            String unmatched = (String)controlStack.pop();
            errors.add("Unmatched " + unmatched.toUpperCase() + " statement");
        }
    }

    private void validateSpecificCommands(String command, String[] tokens, int lineNum, List<String> errors, List<String> warnings) {
        switch (command) {
            case "SEND": {
                if (tokens.length >= 2) break;
                errors.add("Line " + lineNum + ": SEND requires at least 1 parameter");
                break;
            }
            case "SET": {
                if (tokens.length >= 3) break;
                errors.add("Line " + lineNum + ": SET requires variable and value");
                break;
            }
            case "DELAY": {
                if (tokens.length < 2) {
                    errors.add("Line " + lineNum + ": DELAY requires time parameter");
                    break;
                }
                try {
                    Integer.parseInt(tokens[1]);
                }
                catch (NumberFormatException e) {
                    errors.add("Line " + lineNum + ": DELAY time must be a number");
                }
                break;
            }
            case "MATH": {
                if (tokens.length < 4) {
                    errors.add("Line " + lineNum + ": MATH requires function, result variable, and value");
                    break;
                }
                if (this.MATH_FUNCTIONS.contains(tokens[2])) break;
                warnings.add("Line " + lineNum + ": Unknown math function '" + tokens[2] + "'");
            }
        }
    }

    private void newFile() {
        if (this.currentFile != null && !this.textPane.getText().trim().isEmpty()) {
            this.autoSaveCurrentFile();
        }
        this.textPane.setText("");
        this.currentFile = null;
        this.statusLabel.setText("New file created - SenScript path");
    }

    private void openFile() {
        File scriptFiles = new File(Project.getProjectScriptPath());
        JFileChooser chooser = new JFileChooser(scriptFiles.getAbsolutePath());
        chooser.setFileFilter(new FileNameExtensionFilter("SenScript files (*.csc)", "csc"));
        if (chooser.showOpenDialog(this) == 0) {
            try {
                String line;
                if (this.currentFile != null && !this.textPane.getText().trim().isEmpty()) {
                    this.autoSaveCurrentFile();
                }
                File file = chooser.getSelectedFile();
                BufferedReader reader = new BufferedReader(new FileReader(file));
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                reader.close();
                this.textPane.setText(content.toString());
                this.currentFile = file;
                this.statusLabel.setText("Opened: " + file.getName() + " - SenScript path");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Error opening file: " + e.getMessage());
            }
        }
    }

    private void saveFile() {
        if (this.currentFile != null) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.currentFile));
                writer.write(this.textPane.getText());
                writer.close();
                this.statusLabel.setText("Saved: " + this.currentFile.getName() + " - SenScript path");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Error saving file: " + e.getMessage());
            }
        } else {
            this.saveFileAs();
        }
    }

    private void saveFileAs() {
        Object fileName = JOptionPane.showInputDialog(this, "Nom du fichier SenScript (sans extension):", "Nouveau fichier", 3);
        if (fileName != null && !((String)fileName).trim().isEmpty()) {
            try {
                int result;
                File file;
                fileName = ((String)fileName).trim().replaceAll("[\\\\/:*?\"<>|]", "_");
                if (!((String)fileName).endsWith(".csc")) {
                    fileName = (String)fileName + ".csc";
                }
                if ((file = new File(Project.getProjectScriptPath() + File.separator + (String)fileName)).exists() && (result = JOptionPane.showConfirmDialog(this, "Le fichier " + (String)fileName + " existe d\u00e9j\u00e0. Voulez-vous le remplacer?", "Fichier existant", 0)) != 0) {
                    return;
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(this.textPane.getText());
                writer.close();
                this.currentFile = file;
                this.statusLabel.setText("Saved: " + file.getName() + " - SenScript path");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Error saving file: " + e.getMessage());
            }
        }
    }

    class LineNumberPanel
    extends JPanel {
        private JTextPane textPane;

        public LineNumberPanel(JTextPane textPane) {
            this.textPane = textPane;
            this.setPreferredSize(new Dimension(50, 0));
            this.setBackground(new Color(240, 240, 240));
            this.setFont(new Font("Monospaced", 0, 12));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            FontMetrics fm = g.getFontMetrics();
            int lineHeight = fm.getHeight();
            int lines = this.textPane.getText().split("\n").length;
            g.setColor(Color.GRAY);
            for (int i = 1; i <= lines; ++i) {
                String lineNum = String.valueOf(i);
                int x = this.getWidth() - fm.stringWidth(lineNum) - 5;
                int y = i * lineHeight - 2;
                g.drawString(lineNum, x, y);
            }
        }
    }
}

