/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import device.DeviceList;
import device.IoTNode;
import device.SensorNode;
import java.util.ArrayList;
import map.MapLayer;
import simulation.Simulation;
import simulation.WisenSimulation;

public class IoTSimulation
implements Runnable {
    public static ArrayList<Process> processes = new ArrayList();

    public boolean ready() {
        for (SensorNode iotNode : DeviceList.sensors) {
            if (iotNode.getType() != 13 || !iotNode.getScriptFileName().equals("")) continue;
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        MapLayer.iotSimulation = true;
        if (!MapLayer.wsnSimulation) {
            new Thread(() -> {
                while (MapLayer.iotSimulation) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    WisenSimulation.sTime += 1.0;
                    MapLayer.repaint();
                }
            }).start();
        }
        System.out.println("IoT Simulation Mode");
        DeviceList.initAll();
        for (SensorNode sensor : DeviceList.sensors) {
            if (sensor.getType() != 13) continue;
            if (!sensor.getRoute().isEmpty()) {
                System.out.println(sensor.getRoute());
            }
            sensor.initForSimulation();
        }
        Simulation.setSimulating(true);
        System.out.println("Starting IoT Simulation ...");
        for (SensorNode iotNode : DeviceList.sensors) {
            if (iotNode.getType() != 13) continue;
            new Thread(() -> {
                iotNode.runIoTScript();
                ((IoTNode)iotNode).runGPS();
            }).start();
        }
    }

    public static void initAllProcesses() {
        for (Process process : processes) {
            process.destroy();
            System.out.println(process);
        }
        processes.clear();
    }
}

