/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import cupcarbon.CupCarbonApp;
import device.DeviceList;
import device.IoTNode;
import device.SensorNode;
import java.io.PrintStream;
import map.MapLayer;
import markers.MarkerList;
import simulation.IoTChannel;
import simulation.IoTMessage;

public class ProgramToCupCarbonFunction {
    public static void exec(String instruction, IoTNode iotNode, PrintStream output) {
        double ratio;
        String[] t;
        String command;
        if (((String)instruction).split(" ").length == 2 && ((String)instruction).split(" ")[0].equals("send")) {
            instruction = (String)instruction + " *";
        }
        if ((command = (t = ((String)instruction).split(" "))[0]).equals("speed")) {
            if (t.length == 2) {
                ratio = Double.parseDouble(t[1]);
                iotNode.setSpeedRatio(ratio);
            }
            if (t.length == 3) {
                ratio = Double.parseDouble(t[2]);
                System.out.println("SPEED " + ratio);
                DeviceList.getIoTNodeById(Integer.valueOf(t[1])).setSpeedRatio(ratio);
            }
        }
        if (command.equals("rudder_angle")) {
            if (t.length == 2) {
                ratio = Double.parseDouble(t[1]);
                iotNode.setRouteDy(ratio);
            }
            if (t.length == 3) {
                ratio = Double.parseDouble(t[2]);
                DeviceList.getIoTNodeById(Integer.valueOf(t[1])).setRouteDy(ratio);
            }
        }
        if (command.equals("visible")) {
            if (t[1].equals("1")) {
                iotNode.setVisible(true);
            }
            if (t[1].equals("0")) {
                iotNode.setVisible(false);
            }
        }
        if (command.equals("mark")) {
            if (t.length == 1) {
                iotNode.mark();
            }
            if (t.length == 2) {
                DeviceList.getIoTNodeById(Integer.valueOf(t[1])).mark();
            }
        }
        if (command.equals("unmark")) {
            if (t.length == 1) {
                iotNode.unmark();
            }
            if (t.length == 2) {
                DeviceList.getIoTNodeById(Integer.valueOf(t[1])).unmark();
            }
        }
        if (command.equals("moveto")) {
            if (t.length == 3) {
                iotNode.setCanMove(false);
                iotNode.gpsMoveTo(Double.parseDouble(t[1]), Double.parseDouble(t[2]), 0.0);
                MapLayer.repaint();
            }
            if (t.length == 4) {
                iotNode.setCanMove(false);
                iotNode.gpsMoveTo(Double.parseDouble(t[1]), Double.parseDouble(t[2]), Double.parseDouble(t[3]));
                MapLayer.repaint();
            }
            if (t.length == 5) {
                DeviceList.getIoTNodeById(Integer.valueOf(t[4])).gpsMoveTo(Double.parseDouble(t[1]), Double.parseDouble(t[2]), Double.parseDouble(t[3]));
                MapLayer.repaint();
            }
        }
        if (command.equals("ismarked")) {
            if (t.length == 1) {
                output.println(iotNode.isMarked() ? "1" : "0");
                output.flush();
            }
            if (t.length == 2) {
                String v = DeviceList.getIoTNodeById(Integer.valueOf(t[1])).isMarked() ? "1" : "0";
                output.println(v);
                output.flush();
            }
        }
        if (command.equals("print")) {
            iotNode.setMessage(((String)instruction).substring(6));
            MapLayer.repaint();
        }
        if (command.equals("pic")) {
            int v = Integer.parseInt(t[1]);
            iotNode.setPic(v);
            MapLayer.repaint();
        }
        if (command.equals("routewait")) {
            iotNode.routeWait(t[1]);
        }
        if (command.equals("routestop")) {
            if (t.length == 1) {
                iotNode.routeStop();
            } else {
                iotNode.routeStop(t[1]);
            }
        }
        if (command.equals("routego")) {
            if (t.length == 1) {
                iotNode.routeGo();
            } else {
                int id = Integer.parseInt(t[1]);
                iotNode.routeGo(id);
            }
        }
        if (command.equals("alert")) {
            String s = ((String)instruction).substring(6);
            CupCarbonApp.cupCarbonController.displayShortErrMessage(s);
            MapLayer.repaint();
        }
        if (command.equals("message")) {
            String s = ((String)instruction).substring(8);
            CupCarbonApp.cupCarbonController.displayShortGoodMessage(s);
            MapLayer.repaint();
        }
        if (command.equals("getid")) {
            output.println(iotNode.getId());
            output.flush();
        }
        if (command.equals("getname")) {
            output.println(iotNode.getName());
            output.flush();
        }
        if (command.equals("getx")) {
            output.println(iotNode.getLongitude());
            output.flush();
        }
        if (command.equals("gety")) {
            output.println(iotNode.getLatitude());
            output.flush();
        }
        if (command.equals("getxy")) {
            output.println(iotNode.getLongitude() + " " + iotNode.getLatitude());
            output.flush();
        }
        if (command.equals("send")) {
            String idDStr = t[2];
            String message = t[1];
            if (idDStr.equals("*")) {
                for (SensorNode neg : iotNode.getNeighbors()) {
                    DeviceList.getIoTNodeById(neg.getId()).addIoTMessage(message);
                    ProgramToCupCarbonFunction.ioTMessageToDisplay(iotNode.getId(), neg.getId(), message);
                }
            } else {
                int idR = Integer.valueOf(idDStr);
                DeviceList.getIoTNodeById(idR).addIoTMessage(message);
                ProgramToCupCarbonFunction.ioTMessageToDisplay(iotNode.getId(), idR, message);
            }
        }
        if (command.equals("read")) {
            String message = iotNode.removeIoTMessage();
            output.println(message);
            output.flush();
        }
        if (command.equals("dsensor")) {
            output.println(iotNode.isSensorDetecting() ? "1" : "0");
            output.flush();
        }
        if (command.equals("getmessage")) {
            String message = iotNode.getMessage();
            output.println(message);
            output.flush();
        }
        if (command.equals("getaction")) {
            boolean action = iotNode.getAction();
            output.println(action ? "1" : "0");
            output.flush();
        }
        if (command.equals("route")) {
            int id1 = Integer.parseInt(t[1]);
            int id2 = Integer.parseInt(t[2]);
            MarkerList.generateOSMRouteFile(id1, id2);
        }
    }

    public static void ioTMessageToDisplay(int idS, int idR, String message) {
        new Thread(() -> {
            try {
                IoTMessage ioTMessage = new IoTMessage(idS, idR, message);
                IoTChannel.add(ioTMessage);
                MapLayer.repaint();
                Thread.sleep(200L);
                IoTChannel.remove(ioTMessage);
                MapLayer.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
    }
}

