/*
 * Decompiled with CFR 0.152.
 */
package solver;

import device.DeviceList;
import device.DeviceWithRadio;
import java.util.LinkedList;
import map.MapLayer;

public class NetworkCenter
extends Thread {
    private LinkedList<Double> degList;

    @Override
    public void run() {
        DeviceWithRadio n2;
        DeviceWithRadio n1;
        this.degList = new LinkedList();
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            DeviceList.sensors.get(i).setValue(0.0);
            DeviceList.sensors.get(i).setMarked(false);
        }
        MapLayer.repaint();
        double sum = 0.0;
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            sum = 0.0;
            n1 = DeviceList.sensors.get(i);
            for (int j = 0; j < DeviceList.sensors.size(); ++j) {
                n2 = DeviceList.sensors.get(j);
                if (i != j && n1.radioDetect(n2)) {
                    sum += 1.0;
                }
                DeviceList.sensors.get(i).setValue(sum);
                this.degList.add(sum);
            }
        }
        double max = 0.0;
        int imax = 0;
        double div = 0.0;
        for (int iter = 0; iter < 5; ++iter) {
            int i;
            for (i = 0; i < DeviceList.sensors.size(); ++i) {
                sum = 0.0;
                n1 = DeviceList.sensors.get(i);
                for (int j = 0; j < DeviceList.sensors.size(); ++j) {
                    n2 = DeviceList.sensors.get(j);
                    if (!n1.radioDetect(n2)) continue;
                    sum += DeviceList.sensors.get(j).getValue();
                }
                this.degList.set(i, sum);
            }
            for (i = 0; i < DeviceList.sensors.size(); ++i) {
                DeviceList.sensors.get(i).setValue(this.degList.get(i));
            }
            max = 0.0;
            for (i = 0; i < DeviceList.sensors.size(); ++i) {
                if (!(DeviceList.sensors.get(i).getValue() > max)) continue;
                max = DeviceList.sensors.get(i).getValue();
                imax = i;
            }
            for (i = 0; i < DeviceList.sensors.size(); ++i) {
                div = 1.0;
                DeviceList.sensors.get(i).setValue(DeviceList.sensors.get(i).getValue() / div);
            }
        }
        System.out.println("--------------");
        System.out.println(max);
        System.out.println(imax);
        DeviceList.sensors.get(imax).setMarked(true);
        MapLayer.repaint();
        System.out.println("--------------");
    }
}

