/*
 * Decompiled with CFR 0.152.
 */
package visibility;

import buildings.Building;
import buildings.BuildingList;
import device.SensorNode;
import geo_objects.GeoZone;
import geo_objects.GeoZoneList;
import java.util.ArrayList;
import java.util.LinkedList;
import map.MapLayer;
import math.Angle;

public class VisibilityZones2
extends Thread {
    private SensorNode sensorNode;

    public VisibilityZones2(SensorNode sensorNode) {
        this.sensorNode = sensorNode;
    }

    @Override
    public void run() {
        ArrayList<double[]> visibilityPointList = new ArrayList<double[]>();
        int nPoint = 20;
        GeoZone zoneOfInterest = new GeoZone(nPoint);
        double step = Math.PI * 2 / (double)nPoint;
        double deg = 0.0;
        for (int i = 0; i < nPoint; ++i) {
            zoneOfInterest.set(this.sensorNode.getLatitude() + 0.001 * Math.cos(deg), this.sensorNode.getLongitude() + 0.0015 * Math.sin(deg), 0.0, i);
            deg += step;
        }
        LinkedList<Building> buildings = new LinkedList<Building>();
        for (Building building : BuildingList.buildings) {
            if (!building.intersect(zoneOfInterest)) continue;
            buildings.add(building);
        }
        for (int k = 0; k < nPoint; ++k) {
            boolean intersection = false;
            for (Building building : buildings) {
                if (!building.intersect(zoneOfInterest) || !building.intersect(this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), zoneOfInterest.getXCoord(k), zoneOfInterest.getYCoord(k))) continue;
                intersection = true;
                break;
            }
            if (intersection) continue;
            visibilityPointList.add(new double[]{zoneOfInterest.getXCoord(k), zoneOfInterest.getYCoord(k)});
        }
        for (Building building : buildings) {
            for (int i = 0; i < building.getNPoints(); ++i) {
                double[] t = new double[]{building.getYCoords(i), building.getXCoords(i)};
                boolean intersection = false;
                for (Building building2 : buildings) {
                    if (!building2.intersect(this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), t[0], t[1])) continue;
                    intersection = true;
                    break;
                }
                if (intersection) continue;
                visibilityPointList.add(t);
            }
        }
        for (int i = 0; i < visibilityPointList.size() - 1; ++i) {
            for (int j = i + 1; j < visibilityPointList.size(); ++j) {
                double a2;
                double a1 = Angle.getAngle(this.sensorNode.getLongitude() - 100.0, this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), this.sensorNode.getLatitude(), ((double[])visibilityPointList.get(i))[1], ((double[])visibilityPointList.get(i))[0]);
                if (!(a1 > (a2 = Angle.getAngle(this.sensorNode.getLongitude() - 100.0, this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), this.sensorNode.getLatitude(), ((double[])visibilityPointList.get(j))[1], ((double[])visibilityPointList.get(j))[0])))) continue;
                double px = ((double[])visibilityPointList.get(i))[0];
                double py = ((double[])visibilityPointList.get(i))[1];
                ((double[])visibilityPointList.get((int)i))[0] = ((double[])visibilityPointList.get(j))[0];
                ((double[])visibilityPointList.get((int)i))[1] = ((double[])visibilityPointList.get(j))[1];
                ((double[])visibilityPointList.get((int)j))[0] = px;
                ((double[])visibilityPointList.get((int)j))[1] = py;
            }
        }
        int n = visibilityPointList.size();
        GeoZoneList geoZoneList = new GeoZoneList();
        for (int i = 0; i < n - 1; ++i) {
            GeoZone zone = new GeoZone(3);
            zone.setCxCy(this.sensorNode.getLongitude(), this.sensorNode.getLatitude());
            zone.set(this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), 0.0, 0);
            zone.set(((double[])visibilityPointList.get(i))[0], ((double[])visibilityPointList.get(i))[1], 0.0, 1);
            zone.set(((double[])visibilityPointList.get(i + 1))[0], ((double[])visibilityPointList.get(i + 1))[1], 0.0, 2);
            geoZoneList.add(zone);
        }
        GeoZone zone = new GeoZone(3);
        zone.setCxCy(this.sensorNode.getLongitude(), this.sensorNode.getLatitude());
        zone.set(this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), 0.0, 0);
        zone.set(((double[])visibilityPointList.get(n - 1))[0], ((double[])visibilityPointList.get(n - 1))[1], 0.0, 1);
        zone.set(((double[])visibilityPointList.get(0))[0], ((double[])visibilityPointList.get(0))[1], 0.0, 2);
        geoZoneList.add(zone);
        this.sensorNode.setGeoZoneList(geoZoneList);
        MapLayer.repaint();
    }
}

