/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.coretext;

import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.DisposerRecord;
import com.sun.javafx.font.FontFallbackInfo;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.MacFontFinder;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.coretext.CGAffineTransform;
import com.sun.javafx.font.coretext.CGRect;
import com.sun.javafx.font.coretext.CGSize;
import com.sun.javafx.font.coretext.CTFactory;
import com.sun.javafx.font.coretext.CTFontStrike;
import com.sun.javafx.font.coretext.OS;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;
import java.lang.ref.Reference;

class CTFontFile
extends PrismFontFile {
    private long cgFontRef = 0L;
    private static final CGAffineTransform tx = new CGAffineTransform();
    private long ctFontRef = 0L;

    CTFontFile(String string, String string2, int n, long l) throws Exception {
        super(string, string2, n, false, false, false, false);
        if (l == 0L) {
            throw new InternalError("Zero fontref");
        }
        this.ctFontRef = l;
        Disposer.addRecord(this, new SelfDisposerRecord(this.ctFontRef));
    }

    CTFontFile(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        super(string, string2, n, bl, bl2, bl3, bl4);
        String string3;
        if (string != null && (string3 = this.getFamilyName()).equals("System Font")) {
            this.fullName = string;
        }
        if (bl2) {
            this.cgFontRef = this.createCGFontForEmbeddedFont();
            Disposer.addRecord(this, new SelfDisposerRecord(this.cgFontRef));
        } else {
            this.cgFontRef = 0L;
        }
    }

    @Override
    public boolean isBold() {
        return this.fullName.equals("System Font Bold") || super.isBold();
    }

    public static boolean registerFont(String string) {
        if (string == null) {
            return false;
        }
        long l = OS.kCFAllocatorDefault();
        boolean bl = false;
        long l2 = OS.CFStringCreate(string);
        if (l2 != 0L) {
            int n = 0;
            long l3 = OS.CFURLCreateWithFileSystemPath(l, l2, n, false);
            if (l3 != 0L) {
                int n2 = 1;
                bl = OS.CTFontManagerRegisterFontsForURL(l3, n2, 0L);
                OS.CFRelease(l3);
            }
            OS.CFRelease(l2);
        }
        return bl;
    }

    private long createCGFontForEmbeddedFont() {
        long l = 0L;
        long l2 = OS.CFStringCreate(this.getFileName());
        if (l2 != 0L) {
            long l3 = OS.CFURLCreateWithFileSystemPath(OS.kCFAllocatorDefault(), l2, 0L, false);
            if (l3 != 0L) {
                long l4 = OS.CGDataProviderCreateWithURL(l3);
                if (l4 != 0L) {
                    l = OS.CGFontCreateWithDataProvider(l4);
                    OS.CFRelease(l4);
                }
                OS.CFRelease(l3);
            }
            OS.CFRelease(l2);
        }
        return l;
    }

    long getCGFontRef() {
        return this.cgFontRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CGRect getBBox(int n, float f) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f, BaseTransform.IDENTITY_TRANSFORM);
        try {
            long l = cTFontStrike.getFontRef();
            if (l == 0L) {
                CGRect cGRect = null;
                return cGRect;
            }
            long l2 = OS.CTFontCreatePathForGlyph(l, (short)n, tx);
            if (l2 == 0L) {
                CGRect cGRect = null;
                return cGRect;
            }
            CGRect cGRect = OS.CGPathGetPathBoundingBox(l2);
            OS.CGPathRelease(l2);
            CGRect cGRect2 = cGRect;
            return cGRect2;
        }
        finally {
            Reference.reachabilityFence(cTFontStrike);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path2D getGlyphOutline(int n, float f) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f, BaseTransform.IDENTITY_TRANSFORM);
        try {
            long l = cTFontStrike.getFontRef();
            if (l == 0L) {
                Path2D path2D = null;
                return path2D;
            }
            long l2 = OS.CTFontCreatePathForGlyph(l, (short)n, tx);
            if (l2 == 0L) {
                Path2D path2D = null;
                return path2D;
            }
            Path2D path2D = OS.CGPathApply(l2);
            OS.CGPathRelease(l2);
            Path2D path2D2 = path2D;
            return path2D2;
        }
        finally {
            Reference.reachabilityFence(cTFontStrike);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected float getAdvanceFromPlatform(int n, float f) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f, BaseTransform.IDENTITY_TRANSFORM);
        try {
            long l = cTFontStrike.getFontRef();
            int n2 = 0;
            CGSize cGSize = new CGSize();
            float f2 = (float)OS.CTFontGetAdvancesForGlyphs(l, n2, (short)n, cGSize);
            return f2;
        }
        finally {
            Reference.reachabilityFence(cTFontStrike);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int[] createGlyphBoundingBox(int n) {
        float f = 12.0f;
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f, BaseTransform.IDENTITY_TRANSFORM);
        try {
            long l;
            long l2 = cTFontStrike.getFontRef();
            if (l2 == 0L) {
                int[] nArray = null;
                return nArray;
            }
            int[] nArray = new int[4];
            if (!this.isCFF()) {
                if (this.isColorGlyph(n)) {
                    CGRect cGRect = OS.CTFontGetBoundingRectForGlyphs(l2, (short)n);
                    float f2 = (float)this.getUnitsPerEm() / f;
                    nArray[0] = (int)Math.round(cGRect.origin.x * (double)f2);
                    nArray[1] = (int)Math.round(cGRect.origin.y * (double)f2);
                    nArray[2] = (int)Math.round((cGRect.origin.x + cGRect.size.width) * (double)f2);
                    nArray[3] = (int)Math.round((cGRect.origin.y + cGRect.size.height) * (double)f2);
                    int[] nArray2 = nArray;
                    return nArray2;
                }
                short s = this.getIndexToLocFormat();
                if (OS.CTFontGetBoundingRectForGlyphUsingTables(l2, (short)n, s, nArray)) {
                    int[] nArray3 = nArray;
                    return nArray3;
                }
            }
            if ((l = OS.CTFontCreatePathForGlyph(l2, (short)n, null)) == 0L) {
                int[] nArray4 = null;
                return nArray4;
            }
            CGRect cGRect = OS.CGPathGetPathBoundingBox(l);
            OS.CGPathRelease(l);
            float f3 = (float)this.getUnitsPerEm() / f;
            nArray[0] = (int)Math.round(cGRect.origin.x * (double)f3);
            nArray[1] = (int)Math.round(cGRect.origin.y * (double)f3);
            nArray[2] = (int)Math.round((cGRect.origin.x + cGRect.size.width) * (double)f3);
            nArray[3] = (int)Math.round((cGRect.origin.y + cGRect.size.height) * (double)f3);
            int[] nArray5 = nArray;
            return nArray5;
        }
        finally {
            Reference.reachabilityFence(cTFontStrike);
        }
    }

    @Override
    protected PrismFontStrike<CTFontFile> createStrike(float f, BaseTransform baseTransform, int n, FontStrikeDesc fontStrikeDesc) {
        return new CTFontStrike(this, f, baseTransform, n, fontStrikeDesc);
    }

    long getFontRef(float f, CGAffineTransform cGAffineTransform) {
        long l = 0L;
        if (this.isEmbeddedFont()) {
            if (this.cgFontRef != 0L) {
                l = OS.CTFontCreateWithGraphicsFont(this.cgFontRef, f, cGAffineTransform, 0L);
            }
        } else if (this.ctFontRef != 0L) {
            l = OS.CTFontCreateCopyWithAttributes(this.ctFontRef, f, cGAffineTransform, 0L);
        } else {
            String string = this.getPSName();
            if (string.startsWith(".")) {
                boolean bl = this.getFullName().indexOf("Bold") > 0;
                l = OS.CTFontCreateUIFontForLanguage(f, cGAffineTransform, bl);
            } else {
                long l2 = OS.CFStringCreate(string);
                if (l2 != 0L) {
                    l = OS.CTFontCreateWithName(l2, f, cGAffineTransform);
                    OS.CFRelease(l2);
                }
            }
        }
        return l;
    }

    void getCascadingInfo(FontFallbackInfo fontFallbackInfo) {
        CTFactory cTFactory = (CTFactory)PrismFontFactory.getFontFactory();
        long l = this.getFontRef(0.0f, null);
        String[] stringArray = MacFontFinder.getCascadeList(l);
        if (PrismFontFactory.debugFonts) {
            System.err.println("Cascading list for " + this.getFullName());
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            if (PrismFontFactory.debugFonts) {
                System.err.print("Entry : name=" + string + " file=" + string2);
            }
            if (string2 == null || string.startsWith(".")) {
                if (!PrismFontFactory.debugFonts) continue;
                System.err.println(" - *** not using this entry (.font and/or null file)");
                continue;
            }
            if (PrismFontFactory.debugFonts) {
                System.err.println();
            }
            fontFallbackInfo.add(string, string2, null);
        }
        if (PrismFontFactory.debugFonts) {
            System.err.println("End cascading list");
        }
    }

    static {
        CTFontFile.tx.a = 1.0;
        CTFontFile.tx.d = -1.0;
    }

    private static class SelfDisposerRecord
    implements DisposerRecord {
        private long fontRef;

        SelfDisposerRecord(long l) {
            this.fontRef = l;
        }

        @Override
        public synchronized void dispose() {
            if (this.fontRef != 0L) {
                OS.CFRelease(this.fontRef);
                this.fontRef = 0L;
            }
        }
    }
}

