/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.TreeTableViewBackingList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.control.skin.TreeTableViewSkin;
import javafx.util.Callback;

class TableSkinUtils {
    private TableSkinUtils() {
    }

    public static boolean resizeColumn(TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase, TableColumnBase<?, ?> tableColumnBase, double d) {
        if (!tableColumnBase.isResizable()) {
            return false;
        }
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).resizeColumn((TableColumn)tableColumnBase, d);
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).resizeColumn((TreeTableColumn)tableColumnBase, d);
        }
        return false;
    }

    public static ObjectProperty<Callback<ResizeFeaturesBase, Boolean>> columnResizePolicyProperty(TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).columnResizePolicyProperty();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).columnResizePolicyProperty();
        }
        return null;
    }

    public static BooleanProperty tableMenuButtonVisibleProperty(TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).tableMenuButtonVisibleProperty();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).tableMenuButtonVisibleProperty();
        }
        return null;
    }

    public static ObjectProperty<Node> placeholderProperty(TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).placeholderProperty();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).placeholderProperty();
        }
        return null;
    }

    public static <C extends Control, I extends IndexedCell<?>> ObjectProperty<Callback<C, I>> rowFactoryProperty(TableViewSkinBase<?, ?, C, I, ?> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).rowFactoryProperty();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).rowFactoryProperty();
        }
        return null;
    }

    public static ObservableList<TableColumnBase<?, ?>> getSortOrder(TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).getSortOrder();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).getSortOrder();
        }
        return FXCollections.emptyObservableList();
    }

    public static ObservableList<TableColumnBase<?, ?>> getColumns(TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).getColumns();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).getColumns();
        }
        return FXCollections.emptyObservableList();
    }

    public static <T> TableSelectionModel<T> getSelectionModel(TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).getSelectionModel();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).getSelectionModel();
        }
        return null;
    }

    public static <T> TableFocusModel<T, ?> getFocusModel(TableViewSkinBase<T, ?, ?, ?, ?> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).getFocusModel();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).getFocusModel();
        }
        return null;
    }

    public static <T, TC extends TableColumnBase<T, ?>> TablePositionBase<? extends TC> getFocusedCell(TableViewSkinBase<?, T, ?, ?, TC> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).getFocusModel().getFocusedCell();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).getFocusModel().getFocusedCell();
        }
        return null;
    }

    public static <TC extends TableColumnBase<?, ?>> ObservableList<TC> getVisibleLeafColumns(TableViewSkinBase<?, ?, ?, ?, TC> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).getVisibleLeafColumns();
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).getVisibleLeafColumns();
        }
        return FXCollections.emptyObservableList();
    }

    public static int getVisibleLeafIndex(TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase, TableColumnBase tableColumnBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).getVisibleLeafIndex((TableColumn)tableColumnBase);
        }
        if (skinnable instanceof TreeTableView) {
            return ((TreeTableView)skinnable).getVisibleLeafIndex((TreeTableColumn)tableColumnBase);
        }
        return -1;
    }

    public static <T, TC extends TableColumnBase<T, ?>> TC getVisibleLeafColumn(TableViewSkinBase<?, T, ?, ?, TC> tableViewSkinBase, int n) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return (TC)((TableView)skinnable).getVisibleLeafColumn(n);
        }
        if (skinnable instanceof TreeTableView) {
            return (TC)((TreeTableView)skinnable).getVisibleLeafColumn(n);
        }
        return null;
    }

    public static <T> ObjectProperty<ObservableList<T>> itemsProperty(TableViewSkinBase<?, ?, ?, ?, ?> tableViewSkinBase) {
        Skinnable skinnable = tableViewSkinBase.getSkinnable();
        if (skinnable instanceof TableView) {
            return ((TableView)skinnable).itemsProperty();
        }
        if (skinnable instanceof TreeTableView && tableViewSkinBase instanceof TreeTableViewSkin) {
            TreeTableViewSkin treeTableViewSkin = (TreeTableViewSkin)tableViewSkinBase;
            if (treeTableViewSkin.tableBackingListProperty == null) {
                treeTableViewSkin.tableBackingList = new TreeTableViewBackingList((TreeTableView)skinnable);
                treeTableViewSkin.tableBackingListProperty = new SimpleObjectProperty(treeTableViewSkin.tableBackingList);
            }
            return treeTableViewSkin.tableBackingListProperty;
        }
        return null;
    }

    public static boolean isConstrainedResizePolicy(Callback<? extends ResizeFeaturesBase, Boolean> callback) {
        return callback == TableView.CONSTRAINED_RESIZE_POLICY || callback == TreeTableView.CONSTRAINED_RESIZE_POLICY;
    }
}

