/*
 * Decompiled with CFR 0.152.
 */
package buildings;

import device.SensorNode;
import geo_objects.GeoZone;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import javax.vecmath.Vector3d;
import map.MapLayer;
import math.Intersect;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import utilities.MapCalc;

public class Building
implements MouseListener,
KeyListener {
    protected int type = 10;
    private double[] coordX;
    private double[] coordY;
    private int[] iCoordX;
    private int[] iCoordY;
    private int nPoints = 0;
    private boolean selected = false;
    private boolean hide = false;
    private int mapZoom = 0;
    private double height = 10.0;

    public Building(int nPoints) {
        this.mapZoom = MapLayer.mapViewer.getZoom();
        this.nPoints = nPoints;
        this.coordX = new double[nPoints];
        this.coordY = new double[nPoints];
        this.iCoordX = new int[nPoints];
        this.iCoordY = new int[nPoints];
    }

    public Building(String[] str) {
        this.nPoints = str.length;
        this.coordX = new double[this.nPoints];
        this.coordY = new double[this.nPoints];
        this.iCoordX = new int[this.nPoints];
        this.iCoordY = new int[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            this.coordX[i] = Double.valueOf(str[i * 2]);
            this.coordY[i] = Double.valueOf(str[i * 2 + 1]);
            this.computeIntCoord(i);
        }
    }

    public Building(String str) {
        String[] vStr = str.split(" ");
        this.nPoints = vStr.length / 2;
        this.coordX = new double[this.nPoints];
        this.coordY = new double[this.nPoints];
        this.iCoordX = new int[this.nPoints];
        this.iCoordY = new int[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            this.coordX[i] = Double.valueOf(vStr[i * 2]);
            this.coordY[i] = Double.valueOf(vStr[i * 2 + 1]);
            this.computeIntCoord(i);
        }
    }

    public void set(double x, double y, int i) {
        this.coordX[i] = x;
        this.coordY[i] = y;
        this.computeIntCoord(i);
    }

    public void setInt(int x, int y, int i) {
        this.iCoordX[i] = x;
        this.iCoordY[i] = y;
        this.coordX[i] = MapCalc.pixelMapToGeo(x, y).getLongitude();
        this.coordY[i] = MapCalc.pixelMapToGeo(x, y).getLatitude();
    }

    public void set(String x, String y, int i) {
        this.coordX[i] = Double.valueOf(x);
        this.coordY[i] = Double.valueOf(y);
        this.computeIntCoord(i);
    }

    public double getXCoords(int i) {
        return this.coordX[i];
    }

    public double[] getXCoords() {
        return this.coordX;
    }

    public double[] getYCoords() {
        return this.coordY;
    }

    public double getYCoords(int i) {
        return this.coordY[i];
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public void computeIntCoord(int i) {
        int[] coord = MapCalc.geoToPixelMapA(this.coordY[i], this.coordX[i]);
        this.iCoordX[i] = coord[0];
        this.iCoordY[i] = coord[1];
    }

    public void computeIntCoords() {
        int[] coord = null;
        for (int i = 0; i < this.nPoints; ++i) {
            coord = MapCalc.geoToPixelMapA(this.coordY[i], this.coordX[i]);
            this.iCoordX[i] = coord[0];
            this.iCoordY[i] = coord[1];
        }
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(0.6f));
        if (!this.hide) {
            int newZoom = MapLayer.mapViewer.getZoom();
            if (newZoom != this.mapZoom) {
                this.mapZoom = newZoom;
                this.computeIntCoords();
            }
            g2.setColor(new Color(194, 182, 164, 50));
            if (this.selected) {
                g2.setColor(new Color(194, 182, 164, 120));
            }
            g2.fillPolygon(this.iCoordX, this.iCoordY, this.nPoints);
            g2.setColor(Color.GRAY);
            if (this.selected) {
                g2.setColor(Color.DARK_GRAY);
            }
            g2.drawPolygon(this.iCoordX, this.iCoordY, this.nPoints);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg) {
        if (this.inside(arg.getX(), arg.getY())) {
            this.selected = !this.selected;
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public boolean inside(int xs, int ys) {
        Point p = new Point(xs, ys);
        GeoPosition gp = MapLayer.mapViewer.convertPointToGeoPosition(p);
        Point2D p1 = MapLayer.mapViewer.getTileFactory().geoToPixel(gp, MapLayer.mapViewer.getZoom());
        Polygon poly = new Polygon(this.iCoordX, this.iCoordY, this.nPoints);
        return poly.contains(p1);
    }

    public boolean inside(double latitude, double longitude) {
        GeoPosition gp = new GeoPosition(latitude, longitude);
        Point2D p1 = MapLayer.mapViewer.getTileFactory().geoToPixel(gp, MapLayer.mapViewer.getZoom());
        Polygon poly = new Polygon(this.iCoordX, this.iCoordY, this.nPoints);
        return poly.contains(p1);
    }

    public boolean inside(SensorNode sn) {
        GeoPosition gp = sn.getGeoCenter();
        Point2D p1 = MapLayer.mapViewer.getTileFactory().geoToPixel(gp, MapLayer.mapViewer.getZoom());
        Polygon poly = new Polygon(this.iCoordX, this.iCoordY, this.nPoints);
        return poly.contains(p1);
    }

    @Override
    public void keyPressed(KeyEvent key) {
        if (key.getKeyCode() == 27) {
            this.selected = false;
        }
        if (key.getKeyCode() == 65 && key.isControlDown()) {
            this.selected = true;
        }
        if (key.getKeyChar() == 'i') {
            boolean bl = this.selected = !this.selected;
        }
        if (key.getKeyChar() == 'H') {
            if (!this.selected) {
                boolean bl = this.hide = !this.hide;
            }
            if (this.hide) {
                this.selected = false;
            }
            MapLayer.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public void setSelection(boolean b) {
        this.selected = b;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int size() {
        return this.nPoints;
    }

    public Vector3d[] toIntVector3d() {
        Vector3d[] vector = new Vector3d[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            vector[i] = new Vector3d(this.iCoordY[i], this.iCoordX[i], 10.0);
            System.out.println(vector[i]);
        }
        return vector;
    }

    public Vector3d[] toVector3d() {
        Vector3d[] vector = new Vector3d[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            vector[i] = new Vector3d(this.coordY[i], this.coordX[i], 10.0);
        }
        return vector;
    }

    public Vector3d[] toVector3d(double xref, double yref, double zm) {
        Vector3d[] vector = new Vector3d[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            vector[i] = new Vector3d((this.coordY[i] - xref) * zm, (this.coordX[i] - yref) * zm, 10.0);
        }
        return vector;
    }

    public Polygon getPoly() {
        Polygon poly = new Polygon(this.iCoordX, this.iCoordY, this.nPoints);
        return poly;
    }

    public void display() {
        for (int i = 0; i < this.nPoints; ++i) {
            System.out.println("(" + this.iCoordX[i] + ", " + this.iCoordY[i] + ")");
        }
    }

    public boolean intersect(Building building) {
        Polygon poly = new Polygon(this.iCoordX, this.iCoordY, this.nPoints);
        for (int i = 0; i < building.getNPoints(); ++i) {
            int[] coord = MapCalc.geoToPixelMapA(building.getYCoords(i), building.getXCoords(i));
            Point p1 = new Point(coord[0], coord[1]);
            if (!poly.contains(p1)) continue;
            return true;
        }
        return false;
    }

    public boolean intersect(Polygon p) {
        for (int i = 0; i < this.nPoints; ++i) {
            if (!p.contains(this.iCoordX[i], this.iCoordY[i])) continue;
            return true;
        }
        return false;
    }

    public boolean intersect(GeoZone zone) {
        for (int i = 0; i < this.nPoints; ++i) {
            if (!zone.toPolygon().contains(this.iCoordX[i], this.iCoordY[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public String toString() {
        Object s = "";
        for (int i = 0; i < this.coordX.length; ++i) {
            s = (String)s + "(" + this.coordX[i] + ", " + this.coordY[i] + ") ";
        }
        return s;
    }

    public boolean intersect(double x1, double y1, double x2, double y2) {
        for (int i = 0; i < this.nPoints - 1; ++i) {
            if (!Intersect.intersect(x1, y1, x2, y2, this.coordY[i], this.coordX[i], this.coordY[i + 1], this.coordX[i + 1])) continue;
            return true;
        }
        return Intersect.intersect(x1, y1, x2, y2, this.coordY[0], this.coordX[0], this.coordY[this.nPoints - 1], this.coordX[this.nPoints - 1]);
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }
}

