/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon;

import action.CupActionStack;
import cupcarbon.CupCarbonController;
import cupcarbon_script.CupCarbonFileNames;
import java.awt.Image;
import java.awt.Taskbar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.stage.Stage;
import javax.swing.ImageIcon;
import simulation.Executor;
import solver.SolverProxyParams;

public class CupCarbonApp
extends Application {
    public static String cupcarbonSession = "";
    public static Stage stage;
    public static CupCarbonController cupCarbonController;
    public static boolean macos;

    @Override
    public void start(Stage mainStage) throws Exception {
        try {
            stage = mainStage;
            String os = System.getProperty("os.name", "UNKNOWN");
            if (os != null && os.startsWith("Mac")) {
                macos = true;
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CupCarbon");
                URL iconURL = CupCarbonApp.class.getResource("cupcarbon_logo.png");
                Image image = new ImageIcon(iconURL).getImage();
                Taskbar taskbar = Taskbar.getTaskbar();
                taskbar.setIconImage(image);
            }
            CupActionStack.init();
            CupCarbonApp.setUserAgentStylesheet("MODENA");
            mainStage.setTitle("CupCarbon Klines 7.2");
            mainStage.getIcons().add(new javafx.scene.image.Image(this.getClass().getResourceAsStream("cupcarbon_logo_small.png")));
            stage.setMaximized(true);
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(this.getClass().getResource("cupcarbon.fxml"));
            Parent panneau = (Parent)loader.load();
            Scene scene = new Scene(panneau);
            mainStage.setScene(scene);
            mainStage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String generateCode(int size) {
        Object code = "";
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        for (int i = 0; i < size; ++i) {
            code = (String)code + chars.charAt(random.nextInt(62));
        }
        return code;
    }

    public static void main2(String[] args2) {
        try {
            Process process = Runtime.getRuntime().exec("python3 hgate1.py");
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String s = "";
            while ((s = br.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args2) {
        String executorPathFile;
        File file_code;
        System.out.println("Welcome to CupCarbon Version Klines 7.2");
        System.out.println("Session Generation ...");
        System.out.println("Version Code Update: 45");
        cupcarbonSession = "cupcarbon_" + CupCarbonApp.generateCode(30);
        if (args2.length > 1) {
            SolverProxyParams.proxyset = "true";
            SolverProxyParams.host = args2[0];
            SolverProxyParams.port = args2[1];
            CupCarbonApp.setProxy();
        }
        if ((file_code = new File(executorPathFile = CupCarbonFileNames.executorPath)).exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(file_code));
                String pythonPath = br.readLine();
                String juliaPath = br.readLine();
                String nodejsPath = br.readLine();
                if (pythonPath == null) {
                    System.err.println("[CupCarbon] Undefined Python Executor path!");
                } else {
                    Executor.executorList.put("py", pythonPath);
                }
                if (juliaPath == null) {
                    System.err.println("[CupCarbon] Undefined Julia Executor path!");
                } else {
                    Executor.executorList.put("jl", juliaPath);
                }
                if (nodejsPath == null) {
                    System.err.println("[CupCarbon] Undefined NodeJS Executor path!");
                } else {
                    Executor.executorList.put("js", nodejsPath);
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                file_code.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CupCarbonApp.launch(args2);
    }

    public static void setProxy() {
        System.getProperties().put("http.proxySet", SolverProxyParams.proxyset);
        System.getProperties().put("http.proxyHost", SolverProxyParams.host);
        System.getProperties().put("http.proxyPort", SolverProxyParams.port);
    }

    public static boolean internetIsAvailable() {
        try {
            URL url = new URL("http://a.basemaps.cartocdn.com/light_all/0/0/0.png");
            InputStream is = url.openStream();
            System.out.println("Internet: OK");
            int x1 = is.read();
            int x2 = is.read();
            int x3 = is.read();
            int x4 = is.read();
            int x5 = is.read();
            is.close();
            if (x1 == 137 && x2 == 80 && x3 == 78 && x4 == 71 && x5 == 13) {
                URL url2 = new URL("http://www.cupcarbon.com/download/cupcarbon_update_v.txt");
                InputStream is2 = url2.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is2));
                int u = Integer.parseInt(br.readLine());
                if (u > 45) {
                    System.out.println("NEW VERSION AVAILABE");
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            Alert alert = new Alert(Alert.AlertType.INFORMATION);
                            alert.setTitle("New Version");
                            alert.setHeaderText("New Version is available.");
                            alert.setContentText("Visit www.cupcarbon.com");
                            alert.showAndWait();
                        }
                    });
                } else {
                    System.out.println("UPDATED VERSION");
                }
                return true;
            }
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void stop() {
        System.exit(0);
    }

    static {
        macos = false;
    }
}

